/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.util;

import java.time.Duration;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class TimeUtils {
    public static final long toMillisLong(@Nullable Duration duration, long nullValue) {
        if (duration == null) {
            return nullValue;
        }
        long millis = duration.toMillis();
        if (millis <= 0L) {
            return 1L;
        }
        return millis;
    }

    public static final int toMillisInt(@Nullable Duration duration, int nullValue) {
        if (duration == null) {
            return nullValue;
        }
        long millis = duration.toMillis();
        if (millis <= 0L) {
            return 1;
        }
        if (millis >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)millis;
    }

    private TimeUtils() {
    }
}

