/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.graphics.core;

import org.eclipse.statet.ecommons.graphics.core.ColorDef;
import org.eclipse.statet.jcommons.lang.Nullable;

public class HSVColorDef
extends ColorDef {
    protected float fHue;
    protected float fSaturation;
    protected float fValue;

    public HSVColorDef(float hue, float saturation, float value) {
        if (hue < 0.0f || hue > 1.0f) {
            throw new IllegalArgumentException("hue");
        }
        if (saturation < 0.0f || saturation > 1.0f) {
            throw new IllegalArgumentException("saturation");
        }
        if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException("value");
        }
        this.setHSV(hue, saturation, value);
        this.HSVtoRGB();
    }

    public HSVColorDef(ColorDef def) {
        super(def);
        if (def instanceof HSVColorDef) {
            HSVColorDef other = (HSVColorDef)def;
            this.fHue = other.fHue;
            this.fSaturation = other.fSaturation;
            this.fValue = other.fValue;
        } else {
            this.RGBtoHSV();
        }
    }

    @Override
    public String getType() {
        return "hsv";
    }

    protected void setHSV(float hue, float saturation, float value) {
        this.fHue = (float)Math.round(hue * 1000.0f) / 1000.0f;
        this.fSaturation = (float)Math.round(saturation * 1000.0f) / 1000.0f;
        this.fValue = (float)Math.round(value * 1000.0f) / 1000.0f;
    }

    private void HSVtoRGB() {
        float r;
        float g;
        float b;
        float hue = this.fHue;
        float saturation = this.fSaturation;
        float value = this.fValue;
        if (saturation == 0.0f) {
            g = b = value;
            r = b;
        } else {
            if (hue == 1.0f) {
                hue = 0.0f;
            }
            int i = (int)(hue *= 6.0f);
            float f = hue - (float)i;
            float p = value * (1.0f - saturation);
            float q = value * (1.0f - saturation * f);
            float t = value * (1.0f - saturation * (1.0f - f));
            switch (i) {
                case 0: {
                    r = value;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = value;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = value;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = value;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = value;
                    break;
                }
                default: {
                    r = value;
                    g = p;
                    b = q;
                }
            }
        }
        this.fRed = (int)((double)(r * 255.0f) + 0.5);
        this.fGreen = (int)((double)(g * 255.0f) + 0.5);
        this.fBlue = (int)((double)(b * 255.0f) + 0.5);
    }

    private void RGBtoHSV() {
        float r = (float)this.fRed / 255.0f;
        float g = (float)this.fGreen / 255.0f;
        float b = (float)this.fBlue / 255.0f;
        float max = Math.max(Math.max(r, g), b);
        float min = Math.min(Math.min(r, g), b);
        float delta = max - min;
        float hue = 0.0f;
        if (delta != 0.0f) {
            hue = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        this.setHSV(hue, max == 0.0f ? 0.0f : (max - min) / max, max);
    }

    public float getHue() {
        return this.fHue;
    }

    public float getSaturation() {
        return this.fSaturation;
    }

    public float getValue() {
        return this.fValue;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HSVColorDef)) {
            return false;
        }
        HSVColorDef other = (HSVColorDef)obj;
        return this.fHue == other.fHue && this.fSaturation == other.fSaturation && this.fValue == other.fValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HSV: ");
        sb.append(this.fHue);
        sb.append(", ");
        sb.append(this.fSaturation);
        sb.append(", ");
        sb.append(this.fValue);
        sb.append(" (#");
        this.printRGBHex(sb);
        sb.append(")");
        return sb.toString();
    }
}

