/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.breakpoints;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.ui.IDetailPane3;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.debug.ui.breakpoints.AbstractBreakpointDetailEditor;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractBreakpointDetailPane
implements IDetailPane3 {
    private final String id;
    private final String name;
    private final String description;
    private AbstractBreakpointDetailEditor editor;
    private IWorkbenchPartSite site;
    private final CopyOnWriteIdentityListSet<IPropertyListener> propertyListeners = new CopyOnWriteIdentityListSet();
    private Composite composite;

    public AbstractBreakpointDetailPane(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public void init(IWorkbenchPartSite partSite) {
        this.site = partSite;
    }

    public void dispose() {
        this.editor = null;
        this.site = null;
        this.propertyListeners.clear();
        this.composite.dispose();
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.propertyListeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.propertyListeners.remove((Object)listener);
    }

    protected CopyOnWriteIdentityListSet<IPropertyListener> getPropertyListeners() {
        return this.propertyListeners;
    }

    protected void firePropertyChange(int property) {
        for (IPropertyListener listener : this.propertyListeners) {
            listener.propertyChanged((Object)this, property);
        }
    }

    public Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)LayoutUtils.newContentGrid());
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor = this.createEditor(this.composite);
        Composite editorControl = this.editor.createControl(this.composite);
        editorControl.setLayoutData((Object)new GridData(4, 4, true, true));
        return this.composite;
    }

    protected abstract AbstractBreakpointDetailEditor createEditor(Composite var1);

    protected AbstractBreakpointDetailEditor getEditor() {
        return this.editor;
    }

    public boolean setFocus() {
        return this.composite.setFocus();
    }

    public boolean isDirty() {
        return this.editor != null && this.editor.isDirty();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty() && this.editor.getStatus().isOK();
    }

    public void doSave(IProgressMonitor monitor) {
        IStatus status;
        IStatusLineManager statusLine = this.getStatusLine();
        if (statusLine != null) {
            statusLine.setErrorMessage(null);
        }
        if ((status = this.editor.save()) != null && !status.isOK() && statusLine != null) {
            statusLine.setErrorMessage(status.getMessage());
            Display.getCurrent().beep();
        }
    }

    /*
     * WARNING - void declaration
     */
    private IStatusLineManager getStatusLine() {
        IWorkbenchPartSite iWorkbenchPartSite = this.site;
        if (iWorkbenchPartSite instanceof IViewSite) {
            void site;
            IViewSite iViewSite = (IViewSite)iWorkbenchPartSite;
            IViewSite cfr_ignored_0 = (IViewSite)iWorkbenchPartSite;
            return site.getActionBars().getStatusLineManager();
        }
        return null;
    }

    public void display(IStructuredSelection selection) {
        IStatusLineManager statusLine = this.getStatusLine();
        if (statusLine != null) {
            statusLine.setErrorMessage(null);
        }
        AbstractBreakpointDetailEditor editor = this.getEditor();
        Object input = null;
        if (selection != null && selection.size() == 1) {
            input = selection.getFirstElement();
        }
        editor.setInput(input);
    }
}

