/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style.editor;

import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.core.style.HorizontalAlignment;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class HorizontalAlignmentPicker
extends Composite {
    private final Combo combo;

    public HorizontalAlignmentPicker(Composite parent, HorizontalAlignment alignment) {
        super(parent, 0);
        this.setLayout((Layout)new RowLayout());
        this.combo = new Combo((Composite)this, 12);
        this.combo.setItems(new String[]{Messages.getString("HorizontalAlignmentPicker.center"), Messages.getString("HorizontalAlignmentPicker.left"), Messages.getString("HorizontalAlignmentPicker.right")});
        this.update(alignment);
    }

    private void update(HorizontalAlignment alignment) {
        if (alignment.equals((Object)HorizontalAlignment.CENTER)) {
            this.combo.select(0);
        } else if (alignment.equals((Object)HorizontalAlignment.LEFT)) {
            this.combo.select(1);
        } else if (alignment.equals((Object)HorizontalAlignment.RIGHT)) {
            this.combo.select(2);
        } else {
            throw new IllegalArgumentException("bad alignment: " + (Object)((Object)alignment));
        }
    }

    public HorizontalAlignment getSelectedAlignment() {
        long idx = this.combo.getSelectionIndex();
        if (idx == 0L) {
            return HorizontalAlignment.CENTER;
        }
        if (idx == 1L) {
            return HorizontalAlignment.LEFT;
        }
        if (idx == 2L) {
            return HorizontalAlignment.RIGHT;
        }
        throw new IllegalStateException("shouldn't happen");
    }

    public void setSelectedAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("null");
        }
        this.update(horizontalAlignment);
    }
}

