/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.tooltip;

import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellPainter;
import org.eclipse.statet.ecommons.waltable.layer.cell.CellDisplayConversionUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.PasswordTextPainter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class TableContentTooltip
extends DefaultToolTip {
    protected NatTable natTable;
    protected String[] tooltipRegions;

    public TableContentTooltip(NatTable natTable, String ... tooltipRegions) {
        super((Control)natTable, 2, false);
        this.setPopupDelay(500);
        this.setShift(new Point(10, 10));
        this.activate();
        this.natTable = natTable;
        this.tooltipRegions = tooltipRegions;
    }

    protected Object getToolTipArea(Event event) {
        long col = this.natTable.getColumnPositionByX(event.x);
        long row = this.natTable.getRowPositionByY(event.y);
        return new LPoint(col, row);
    }

    protected String getText(Event event) {
        String tooltipValue;
        LayerCellPainter painter;
        long row;
        long col = this.natTable.getColumnPositionByX(event.x);
        LayerCell cell = this.natTable.getCellByPosition(col, row = this.natTable.getRowPositionByY(event.y));
        if (cell != null && this.isVisibleContentPainter(painter = this.natTable.getConfigRegistry().getAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, cell.getLabels().getLabels())) && (tooltipValue = CellDisplayConversionUtils.convertDataType(cell, this.natTable.getConfigRegistry())).length() > 0) {
            return tooltipValue;
        }
        return null;
    }

    protected boolean isVisibleContentPainter(LayerCellPainter painter) {
        if (painter instanceof PasswordTextPainter) {
            return false;
        }
        if (painter instanceof CellPainterWrapper) {
            return this.isVisibleContentPainter(((CellPainterWrapper)painter).getWrappedPainter());
        }
        return true;
    }

    protected boolean shouldCreateToolTip(Event event) {
        boolean regionCheckPassed = false;
        if (this.tooltipRegions.length > 0) {
            LabelStack regionLabels = this.natTable.getRegionLabelsByXY(event.x, event.y);
            if (regionLabels != null) {
                String[] stringArray = this.tooltipRegions;
                int n = this.tooltipRegions.length;
                int n2 = 0;
                while (n2 < n) {
                    String label = stringArray[n2];
                    if (regionLabels.hasLabel(label)) {
                        regionCheckPassed = true;
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            regionCheckPassed = true;
        }
        if (regionCheckPassed && this.getText(event) != null) {
            return super.shouldCreateToolTip(event);
        }
        return false;
    }
}

