/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.time.Duration;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.NullProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public abstract class TunnelClientSocketImpl
extends SocketImpl {
    protected static final int RCVBUF_DEFAULT = 32768;
    private @Nullable InetSocketAddress targetAddress;
    private @Nullable InputStream inputStream;
    private @Nullable OutputStream outputStream;
    protected boolean tcpNoDelay;
    protected @Nullable ProgressMonitor connectMonitor;

    public TunnelClientSocketImpl() throws IOException {
        this.localport = 0;
    }

    @Override
    protected void create(boolean stream) throws IOException {
        if (!stream) {
            throw new IOException("Not supported");
        }
    }

    @Override
    protected void connect(@Nullable String host, int port) throws IOException {
        this.connect(InetAddress.getByName(host), port);
    }

    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        this.connect((SocketAddress)new InetSocketAddress(address, port), 0);
    }

    @Override
    protected void connect(SocketAddress address, int timeout) throws IOException {
        this.connect(address, timeout != 0 ? Duration.ofMillis(timeout) : null);
    }

    protected void connect(SocketAddress address, @Nullable Duration timeout) throws IOException {
        ObjectUtils.nonNullAssert(address);
        if (!(address instanceof InetSocketAddress)) {
            throw new UnsupportedOperationException("addressType= " + address.getClass().toString());
        }
        InetSocketAddress targetAddress = (InetSocketAddress)address;
        if (this.localport != 0) {
            throw new IOException("Not supported: reconnect to " + address.toString());
        }
        ProgressMonitor m = this.connectMonitor;
        if (m == null) {
            m = new NullProgressMonitor();
        }
        try {
            this.connectRemote(targetAddress, timeout, m);
            assert (this.inputStream != null && this.outputStream != null);
            this.targetAddress = targetAddress;
            this.address = targetAddress.getAddress();
            this.port = targetAddress.getPort();
            this.localport = -1;
        }
        catch (IOException | StatusException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
    }

    protected @Nullable InetSocketAddress getTargetAddress() {
        return this.targetAddress;
    }

    protected void setInputStream(InputStream inputStream) {
        this.inputStream = ObjectUtils.nonNullAssert(inputStream);
    }

    protected void setOutputStream(OutputStream outputStream) {
        this.outputStream = ObjectUtils.nonNullAssert(outputStream);
    }

    protected abstract void connectRemote(InetSocketAddress var1, @Nullable Duration var2, ProgressMonitor var3) throws IOException, StatusException;

    @Override
    protected void bind(InetAddress host, int port) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    protected void listen(int backlog) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    protected void accept(SocketImpl s) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        InputStream inputStream = this.inputStream;
        if (inputStream == null) {
            throw new IOException("Not yet initialized");
        }
        return inputStream;
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = this.outputStream;
        if (outputStream == null) {
            throw new IOException("Not yet initialized");
        }
        return outputStream;
    }

    @Override
    protected int available() throws IOException {
        InputStream inputStream = this.inputStream;
        return inputStream != null ? inputStream.available() : 0;
    }

    @Override
    protected void close() throws IOException {
        this.localport = -1;
    }

    @Override
    protected void shutdownInput() throws IOException {
        InputStream inputStream = this.inputStream;
        if (inputStream == null) {
            return;
        }
        inputStream.close();
    }

    @Override
    protected void shutdownOutput() throws IOException {
        OutputStream outputStream = this.outputStream;
        if (outputStream == null) {
            return;
        }
        outputStream.close();
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        switch (optID) {
            case 1: {
                if ((Boolean)value != this.tcpNoDelay) break;
                return;
            }
            case 8: {
                if (((Boolean)value).booleanValue()) break;
                return;
            }
            case 4102: {
                return;
            }
            case 4097: 
            case 4098: {
                return;
            }
        }
        throw new SocketException("Not supported: option= " + optID + " with value= " + value);
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        switch (optID) {
            case 1: {
                return this.tcpNoDelay;
            }
            case 8: {
                return Boolean.FALSE;
            }
            case 4102: {
                return 0;
            }
            case 4097: {
                return 1024;
            }
            case 4098: {
                return 32768;
            }
        }
        throw new SocketException("Not supported: option= " + optID);
    }
}

