/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.internal.r.core.rmodel.AnonymousAccess;
import org.eclipse.statet.internal.r.core.rmodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.rmodel.BuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.rmodel.ElementAccess;
import org.eclipse.statet.internal.r.core.rmodel.RSourceModel;
import org.eclipse.statet.internal.r.core.rmodel.SubNamedPartSyntacticElementAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.r.core.rmodel.Parameters;
import org.eclipse.statet.r.core.rmodel.RElement;
import org.eclipse.statet.r.core.rmodel.RElementAccess;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.rmodel.RFrame;
import org.eclipse.statet.r.core.rmodel.RLangClass;
import org.eclipse.statet.r.core.rmodel.RLangClassExtension;
import org.eclipse.statet.r.core.rmodel.RLangMethod;
import org.eclipse.statet.r.core.rmodel.RLangPackageLoad;
import org.eclipse.statet.r.core.rmodel.RLangSlot;
import org.eclipse.statet.r.core.rmodel.RLangSourceElement;
import org.eclipse.statet.r.core.rmodel.RModelUtils;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.source.ast.DocuComment;
import org.eclipse.statet.r.core.source.ast.FDef;

@NonNullByDefault
abstract class RSourceElementByElementAccess
implements RLangSourceElement,
LtkModelElementFilter<LtkModelElement<?>> {
    private final RLangSourceElement parent;
    private RElementAccess access;
    int type;
    int occurrenceCount;

    public RSourceElementByElementAccess(RLangSourceElement parent, int elementType, @Nullable ElementAccess defAccess) {
        this.parent = parent;
        this.type = elementType;
        this.setAccess(defAccess);
    }

    protected void setAccess(@Nullable AnonymousAccess access) {
        if (access != null) {
            this.access = access;
        }
    }

    protected void setAccess(@Nullable ElementAccess access) {
        if (access != null) {
            access.modelElement = this;
            this.access = access;
        }
    }

    public final String getModelTypeId() {
        return "R";
    }

    public final RElementAccess getAccess() {
        return this.access;
    }

    public boolean include(LtkModelElement<?> element) {
        return element == this;
    }

    @Override
    public final @Nullable RElement<?> getModelParent() {
        List elements = this.access.getFrame().getModelElements();
        for (RElement element : elements) {
            if (!element.hasModelChildren(this)) continue;
            return element;
        }
        return null;
    }

    public final RLangSourceElement getSourceParent() {
        return this.parent;
    }

    @Override
    public final RSourceUnit getSourceUnit() {
        return this.parent.getSourceUnit();
    }

    public final int getElementType() {
        return this.type;
    }

    @Override
    public final RElementName getElementName() {
        return this.access;
    }

    public final String getId() {
        String name = this.getElementName().getDisplayName();
        StringBuilder sb = new StringBuilder(name.length() + 10);
        sb.append(Integer.toHexString(this.type & 0xFF0));
        sb.append(':');
        sb.append(name);
        sb.append('#');
        sb.append(this.occurrenceCount);
        return sb.toString();
    }

    public final boolean exists() {
        return this.parent.exists();
    }

    public final boolean isReadOnly() {
        return this.parent.isReadOnly();
    }

    public final TextRegion getSourceRange() {
        return this.access.getNode();
    }

    public final TextRegion getNameSourceRange() {
        return RModelUtils.getNameSourceRegion(this.access.getLastSegment());
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)((Object)this.access.getNode());
        }
        if (adapterType == RElementAccess.class) {
            return (T)this.access;
        }
        return null;
    }

    public int hashCode() {
        return (this.type & 0xFF0) * this.getElementName().hashCode() + this.occurrenceCount;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                void other;
                if (this == obj) break block2;
                Object object = obj;
                if (!(object instanceof RSourceElementByElementAccess)) break block3;
                RSourceElementByElementAccess rSourceElementByElementAccess = (RSourceElementByElementAccess)object;
                RSourceElementByElementAccess cfr_ignored_0 = (RSourceElementByElementAccess)object;
                if ((this.type & 0xFF0) == (other.type & 0xFF0) && this.occurrenceCount == other.occurrenceCount && ((this.type & 0xF00) == 512 || this.getSourceParent().equals(other.getSourceParent())) && this.getElementName().equals(other.getElementName())) break block2;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" (RSourceElementByElementAccess)");
        RElementName elementName = this.getElementName();
        if (elementName != null) {
            sb.append(' ').append(elementName);
        } else {
            sb.append(" <unnamed>");
        }
        return sb.toString();
    }

    static abstract class DocuCommentableElement
    extends RSourceElementByElementAccess {
        private @Nullable DocuComment docu;

        public DocuCommentableElement(RLangSourceElement parent, int elementType, @Nullable ElementAccess defAccess) {
            super(parent, elementType, defAccess);
        }

        void setDocu(DocuComment docu) {
            this.docu = docu;
        }

        public final @Nullable DocuComment getDocumentationRange() {
            return this.docu;
        }
    }

    static abstract class DocuCommentableEnvirElement
    extends DocuCommentableElement
    implements BuildSourceFrameElement {
        private List<? extends RLangSourceElement> sourceChildrenProtected = RSourceModel.NO_R_SOURCE_CHILDREN;
        private @Nullable List<? extends RLangSourceElement> modelChildrenProtected;
        private final BuildSourceFrame envir;

        protected DocuCommentableEnvirElement(RLangSourceElement parent, BuildSourceFrame envir, int elementType, @Nullable ElementAccess defAccess) {
            super(parent, elementType, defAccess);
            this.envir = envir;
        }

        @Override
        public void setSourceChildren(List<? extends RLangSourceElement> children) {
            this.sourceChildrenProtected = children;
        }

        @Override
        public BuildSourceFrame getBuildFrame() {
            return this.envir;
        }

        @Override
        public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            List<? extends RLangSourceElement> children = this.modelChildrenProtected;
            if (children == null) {
                this.modelChildrenProtected = children = this.envir.getModelChildren(this);
            }
            return LtkModelUtils.hasChildren(children, filter);
        }

        @Override
        public List<? extends RLangSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            List<? extends RLangSourceElement> children = this.modelChildrenProtected;
            if (children == null) {
                this.modelChildrenProtected = children = this.envir.getModelChildren(this);
            }
            return LtkModelUtils.getChildren(children, filter);
        }

        @Override
        public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return LtkModelUtils.hasChildren(this.sourceChildrenProtected, filter);
        }

        @Override
        public List<? extends RLangSourceElement> getSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return LtkModelUtils.getChildren(this.sourceChildrenProtected, filter);
        }

        @Override
        public <T> @Nullable T getAdapter(Class<T> adapterType) {
            if (adapterType == RFrame.class) {
                return (T)this.envir;
            }
            return super.getAdapter(adapterType);
        }
    }

    static final class RClass
    extends DocuCommentableEnvirElement
    implements RLangClass<RLangSourceElement> {
        private static final List<String> NO_PARENTS = Collections.emptyList();
        private List<String> superClassesTypeNames = NO_PARENTS;
        private List<String> superClassesTypeNamesProtected = NO_PARENTS;

        public RClass(RLangSourceElement parent, ElementAccess defAccess, BuildSourceFrame envir) {
            super(parent, envir, 1152, defAccess);
        }

        public void addSuperClasses(@Nullable String[] typeNames) {
            int n;
            if (this.superClassesTypeNames == NO_PARENTS) {
                int count = 0;
                String[] stringArray = typeNames;
                int n2 = typeNames.length;
                n = 0;
                while (n < n2) {
                    String name = stringArray[n];
                    if (name != null) {
                        ++count;
                    }
                    ++n;
                }
                if (count == 0) {
                    return;
                }
                this.superClassesTypeNames = new ArrayList<String>(count);
                this.superClassesTypeNamesProtected = Collections.unmodifiableList(this.superClassesTypeNames);
            }
            String[] stringArray = typeNames;
            n = typeNames.length;
            int n3 = 0;
            while (n3 < n) {
                String name = stringArray[n3];
                if (name != null && !this.superClassesTypeNames.contains(name)) {
                    this.superClassesTypeNames.add(name);
                }
                ++n3;
            }
        }

        @Override
        public List<String> getExtendedClassNames() {
            return this.superClassesTypeNamesProtected;
        }
    }

    static final class RClassExt
    extends RSourceElementByElementAccess
    implements RLangClassExtension<RLangSourceElement>,
    BuildSourceFrameElement {
        private List<? extends RLangSourceElement> sourceChildrenProtected = RSourceModel.NO_R_SOURCE_CHILDREN;
        private @Nullable List<? extends RLangSourceElement> modelChildrenProtected;
        private final BuildSourceFrame envir;
        private final String extCommand;
        private @Nullable String extTypeName;

        public RClassExt(RLangSourceElement parent, ElementAccess defAccess, BuildSourceFrame envir, String command) {
            super(parent, 1168, defAccess);
            this.envir = envir;
            this.extCommand = command;
        }

        public void complete(@Nullable String extTypeName) {
            this.extTypeName = extTypeName;
        }

        @Override
        public void setSourceChildren(List<? extends RLangSourceElement> children) {
            this.sourceChildrenProtected = children;
        }

        @Override
        public BuildSourceFrame getBuildFrame() {
            return this.envir;
        }

        @Override
        public String getExtCommand() {
            return this.extCommand;
        }

        @Override
        public @Nullable String getExtTypeName() {
            return this.extTypeName;
        }

        public @Nullable TextRegion getDocumentationRange() {
            return null;
        }

        @Override
        public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            List<? extends RLangSourceElement> children = this.modelChildrenProtected;
            if (children == null) {
                this.modelChildrenProtected = children = this.envir.getModelChildren(this);
            }
            return LtkModelUtils.hasChildren(children, filter);
        }

        @Override
        public List<? extends RLangSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            List<? extends RLangSourceElement> children = this.modelChildrenProtected;
            if (children == null) {
                this.modelChildrenProtected = children = this.envir.getModelChildren(this);
            }
            return LtkModelUtils.getChildren(children, filter);
        }

        @Override
        public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return LtkModelUtils.hasChildren(this.sourceChildrenProtected, filter);
        }

        @Override
        public List<? extends RLangSourceElement> getSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return LtkModelUtils.getChildren(this.sourceChildrenProtected, filter);
        }

        @Override
        public <T> @Nullable T getAdapter(Class<T> adapterType) {
            if (adapterType == RFrame.class) {
                return (T)this.envir;
            }
            return super.getAdapter(adapterType);
        }
    }

    static final class RDataFrame
    extends DocuCommentableElement {
        private List<RElementAccess> columns;

        public RDataFrame(RLangSourceElement parent, int elementType, List<SubNamedPartSyntacticElementAccess> columns) {
            super(parent, elementType, null);
        }

        @Override
        public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return false;
        }

        @Override
        public final List<? extends RLangSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return RSourceModel.NO_R_SOURCE_CHILDREN;
        }

        @Override
        public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return false;
        }

        @Override
        public List<? extends RLangSourceElement> getSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return RSourceModel.NO_R_SOURCE_CHILDREN;
        }
    }

    static final class RMethod
    extends DocuCommentableEnvirElement
    implements RLangMethod<RLangSourceElement> {
        private final FDef fDefNode;
        private @Nullable Parameters parameters;

        public RMethod(RLangSourceElement parent, BuildSourceFrame envir, FDef fdefNode) {
            super(parent, envir, 1296, null);
            this.fDefNode = fdefNode;
        }

        void complete(int type, ElementAccess defAccess, @Nullable Parameters parameters) {
            this.type = type;
            this.setAccess(defAccess);
            this.parameters = parameters;
        }

        void complete(AnonymousAccess defAccess, Parameters parameters) {
            this.setAccess(defAccess);
            this.parameters = parameters;
        }

        public RMethod(RLangSourceElement parent, int type, ElementAccess access, BuildSourceFrame envir) {
            super(parent, envir, type, access);
            this.fDefNode = null;
        }

        public void complete(Parameters parameters) {
            this.parameters = parameters;
        }

        public FDef getFDefNode() {
            return this.fDefNode;
        }

        @Override
        public @Nullable Parameters getParameters() {
            return this.parameters;
        }

        @Override
        public <T> @Nullable T getAdapter(Class<T> adapterType) {
            if (adapterType == FDef.class) {
                return (T)((Object)this.fDefNode);
            }
            return super.getAdapter(adapterType);
        }
    }

    static final class RPkgImport
    extends RSourceElementByElementAccess
    implements RLangPackageLoad<RLangSourceElement> {
        public RPkgImport(RLangSourceElement parent, ElementAccess access) {
            super(parent, 784, access);
        }

        public @Nullable TextRegion getDocumentationRange() {
            return null;
        }

        @Override
        public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return false;
        }

        @Override
        public final List<? extends RLangSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return RSourceModel.NO_R_SOURCE_CHILDREN;
        }

        @Override
        public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return false;
        }

        @Override
        public List<? extends RLangSourceElement> getSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return RSourceModel.NO_R_SOURCE_CHILDREN;
        }
    }

    static final class RSlot
    extends RSourceElementByElementAccess
    implements RLangSlot<RLangSourceElement> {
        private @Nullable String typeName;
        private String prototypeCode;

        public RSlot(RLangSourceElement parent, ElementAccess defAccess) {
            super(parent, 1664, defAccess);
        }

        void completeType(@Nullable String name) {
            this.typeName = name;
        }

        @Override
        public @Nullable String getTypeName() {
            return this.typeName;
        }

        public @Nullable TextRegion getDocumentationRange() {
            return null;
        }

        @Override
        public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return false;
        }

        @Override
        public final List<? extends RLangSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return RSourceModel.NO_R_SOURCE_CHILDREN;
        }

        @Override
        public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return false;
        }

        @Override
        public List<? extends RLangSourceElement> getSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return RSourceModel.NO_R_SOURCE_CHILDREN;
        }
    }

    static final class RVariable
    extends DocuCommentableElement {
        public RVariable(RLangSourceElement parent, int elementType, ElementAccess defAccess) {
            super(parent, elementType, defAccess);
        }

        @Override
        public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return false;
        }

        @Override
        public final List<? extends RLangSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return RSourceModel.NO_R_SOURCE_CHILDREN;
        }

        @Override
        public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return false;
        }

        @Override
        public List<? extends RLangSourceElement> getSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
            return RSourceModel.NO_R_SOURCE_CHILDREN;
        }
    }
}

