/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.dataeditor;

import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.util.ToolTerminateListener;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.ui.dataeditor.RDataTableInput;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.ts.core.RTool;

@NonNullByDefault
public class RToolDataTableInput
implements RDataTableInput {
    private final RElementName elementName;
    private final String fullName;
    private final String shortName;
    private final FQRObjectRef<? extends RTool> elementRef;
    private final RTool tool;
    private @Nullable ToolTerminateListener processListener;
    private final CopyOnWriteIdentityListSet<RDataTableInput.StateListener> listeners = new CopyOnWriteIdentityListSet();

    public RToolDataTableInput(RElementName elementName, FQRObjectRef<? extends RTool> elementRef) {
        if (elementName == null) {
            throw new NullPointerException("name");
        }
        if (elementRef == null) {
            throw new NullPointerException("elementRef");
        }
        if (!(elementRef.getRHandle() instanceof RTool)) {
            throw new IllegalArgumentException("Unsupported elementRef.rHandle");
        }
        this.elementName = elementName;
        this.elementRef = elementRef;
        this.fullName = RElementName.createDisplayName((RElementName)elementName, (int)3);
        RElementName name = elementName;
        while (elementName.getNextSegment() != null) {
            if (elementName.getType() == 17) {
                name = elementName;
            }
            elementName = elementName.getNextSegment();
        }
        this.shortName = name.getDisplayName();
        this.tool = (RTool)elementRef.getRHandle();
    }

    @Override
    public RElementName getElementName() {
        return this.elementName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.shortName;
    }

    @Override
    public FQRObjectRef<? extends RTool> getElementRef() {
        return this.elementRef;
    }

    @Override
    public Tool getTool() {
        return this.tool;
    }

    @Override
    public boolean isAvailable() {
        return !this.tool.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStateListener(RDataTableInput.StateListener listener) {
        CopyOnWriteIdentityListSet<RDataTableInput.StateListener> copyOnWriteIdentityListSet = this.listeners;
        synchronized (copyOnWriteIdentityListSet) {
            ToolTerminateListener processListener;
            if (this.listeners.add((Object)listener) && (processListener = this.processListener) == null) {
                processListener = new ToolTerminateListener((Tool)this.tool){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void toolTerminated() {
                        ImIdentityList listeners;
                        CopyOnWriteIdentityListSet<RDataTableInput.StateListener> copyOnWriteIdentityListSet = RToolDataTableInput.this.listeners;
                        synchronized (copyOnWriteIdentityListSet) {
                            this.dispose();
                            RToolDataTableInput.this.processListener = null;
                            listeners = RToolDataTableInput.this.listeners.toList();
                        }
                        for (RDataTableInput.StateListener listener : listeners) {
                            listener.tableUnavailable();
                        }
                    }
                };
                processListener.install();
                this.processListener = processListener;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStateListener(RDataTableInput.StateListener listener) {
        CopyOnWriteIdentityListSet<RDataTableInput.StateListener> copyOnWriteIdentityListSet = this.listeners;
        synchronized (copyOnWriteIdentityListSet) {
            ToolTerminateListener processListener;
            if (this.listeners.remove((Object)listener) && this.listeners.isEmpty() && (processListener = this.processListener) != null) {
                this.processListener = null;
                processListener.dispose();
            }
        }
    }

    public int hashCode() {
        return this.shortName.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                void other;
                if (this == obj) break block2;
                Object object = obj;
                if (!(object instanceof RToolDataTableInput)) break block3;
                RToolDataTableInput rToolDataTableInput = (RToolDataTableInput)object;
                RToolDataTableInput cfr_ignored_0 = (RToolDataTableInput)object;
                if (this.tool.equals(other.tool) && this.fullName.equals(other.fullName)) break block2;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.fullName + " in " + this.tool.getLabel(1) + ")";
    }
}

