/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.snakeyaml.scanner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.CharConstants;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.SimpleKey;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.StreamReader;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.SyntaxProblem;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.AliasToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.AnchorToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.BlockEndToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.BlockEntryToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.BlockMappingStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.BlockSequenceStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.CommentType;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.DirectiveToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.DocumentEndToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.DocumentStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.Dummy;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.FlowEntryToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.KeyToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.ScalarStyle;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.ScalarToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.StreamEndToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.StreamStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.TagToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.TagTuple;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.Token;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.ValueToken;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.source.StatusDetail;

@NonNullByDefault
public class ScannerImpl {
    private static final byte CHOMPING_STRIP = 0;
    private static final byte CHOMPING_CLIP = 1;
    private static final byte CHOMPING_KEEP = 2;
    private StreamReader reader;
    private boolean done = false;
    private int flowLevel = 0;
    private final List<Token> tokens = new ArrayList<Token>(64);
    private int tokensTaken = 0;
    private int indent = -1;
    private final IntList indents = new IntArrayList(16);
    private final StringBuilder tmpSB = new StringBuilder(256);
    private final StringBuilder tmpSB2 = new StringBuilder();
    private int tmpInt;
    private boolean scanOK;
    private @Nullable SyntaxProblem scanProblem;
    private boolean createAnchorText;
    private boolean createContentText;
    private boolean parseComments;
    private boolean allowSimpleKey = true;
    private final Map<Integer, SimpleKey> possibleSimpleKeys = new LinkedHashMap<Integer, SimpleKey>();

    public ScannerImpl(boolean createRefText, boolean createContentText, boolean parseComments) {
        this.createAnchorText = createRefText;
        this.createContentText = createContentText;
        this.parseComments = parseComments;
    }

    public boolean getCreateAnchorText() {
        return this.createAnchorText;
    }

    public void setCreateAnchorText(boolean enable) {
        this.createAnchorText = enable;
    }

    public boolean getCreateContentText() {
        return this.createContentText;
    }

    public void setCreateContentText(boolean enable) {
        this.createContentText = enable;
    }

    public boolean getParseComments() {
        return this.parseComments;
    }

    public void setParseComments(boolean enable) {
        this.parseComments = enable;
    }

    public void reset(StreamReader in) {
        this.reader = in;
        this.done = false;
        this.tokens.clear();
        this.tokensTaken = 0;
        this.resetToRoot();
        this.fetchStreamStart();
    }

    public void reset(String s, int index) {
        this.reset(new StreamReader(s, index, 2048));
    }

    public void resetToRoot() {
        this.flowLevel = 0;
        this.indent = -1;
        this.indents.clear();
        this.allowSimpleKey = true;
    }

    public @Nullable Token nextToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            ++this.tokensTaken;
            return this.tokens.remove(0);
        }
        return null;
    }

    private boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        if (this.tokens.isEmpty()) {
            return true;
        }
        this.stalePossibleSimpleKeys();
        return this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private void fetchMoreTokens() {
        this.scanToNextToken();
        this.stalePossibleSimpleKeys();
        this.unwindIndent(this.reader.getColumn());
        int c = this.reader.peek();
        switch (c) {
            case 0: {
                this.fetchStreamEnd();
                return;
            }
            case 37: {
                if (!this.checkDirective()) break;
                this.fetchDirective();
                return;
            }
            case 45: {
                if (this.checkDocumentStart()) {
                    this.fetchDocumentIndicator(Token.ID.DocumentStart);
                    return;
                }
                if (!this.checkBlockEntry()) break;
                this.fetchBlockEntry();
                return;
            }
            case 46: {
                if (!this.checkDocumentEnd()) break;
                this.fetchDocumentIndicator(Token.ID.DocumentEnd);
                return;
            }
            case 91: {
                this.fetchFlowSequenceStart();
                return;
            }
            case 123: {
                this.fetchFlowMappingStart();
                return;
            }
            case 93: {
                this.fetchFlowSequenceEnd();
                return;
            }
            case 125: {
                this.fetchFlowMappingEnd();
                return;
            }
            case 44: {
                this.fetchFlowEntry();
                return;
            }
            case 63: {
                if (!this.checkKey()) break;
                this.fetchKey();
                return;
            }
            case 58: {
                if (!this.checkValue()) break;
                this.fetchValue();
                return;
            }
            case 42: {
                this.fetchAlias();
                return;
            }
            case 38: {
                this.fetchAnchor();
                return;
            }
            case 33: {
                this.fetchTag();
                return;
            }
            case 124: {
                if (this.flowLevel != 0) break;
                this.fetchLiteral();
                return;
            }
            case 62: {
                if (this.flowLevel != 0) break;
                this.fetchFolded();
                return;
            }
            case 39: {
                this.fetchSingle();
                return;
            }
            case 34: {
                this.fetchDouble();
                return;
            }
        }
        if (this.checkPlain()) {
            this.fetchPlain();
            return;
        }
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.reader.forward(1);
        this.newScannerException((byte)1, startMark, 4194608, startMark, this.reader.getMark(), Character.toString(c));
        this.tokens.add(new Dummy(startMark, this.reader.getMark(), this.scanProblem));
    }

    private int nextPossibleSimpleKey() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            return this.possibleSimpleKeys.values().iterator().next().getTokenNumber();
        }
        return -1;
    }

    private void stalePossibleSimpleKeys() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            Iterator<SimpleKey> iterator = this.possibleSimpleKeys.values().iterator();
            while (iterator.hasNext()) {
                SimpleKey key = iterator.next();
                if (key.getLine() == this.reader.getLine() && this.reader.getIndex() - key.getIndex() <= 1024) continue;
                if (key.isRequired()) {
                    this.newScannerException((byte)7, key.getMark(), 4477744, this.reader.getMark());
                }
                iterator.remove();
            }
        }
    }

    private void savePossibleSimpleKey() {
        boolean required;
        boolean bl = required = this.flowLevel == 0 && this.indent == this.reader.getColumn();
        if (!this.allowSimpleKey && required) {
            throw new RuntimeException("A simple key is required only if it is the first token in the current line");
        }
        if (this.allowSimpleKey) {
            int mark = this.reader.getMark();
            this.removePossibleSimpleKey(mark);
            int tokenNumber = this.tokensTaken + this.tokens.size();
            SimpleKey key = new SimpleKey(tokenNumber, required, this.reader.getIndex(), this.reader.getLine(), this.reader.getColumn(), mark);
            this.possibleSimpleKeys.put(this.flowLevel, key);
        }
    }

    private void removePossibleSimpleKey(int mark) {
        SimpleKey key = this.possibleSimpleKeys.remove(this.flowLevel);
        if (key != null && key.isRequired()) {
            this.newScannerException((byte)7, key.getMark(), 4477744, mark);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void unwindIndent(int col) {
        if (this.flowLevel == 0) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            mark = this.reader.getMark();
            this.indent = this.indents.removeAt(this.indents.size() - 1);
            this.tokens.add(new BlockEndToken(mark, mark, null));
lbl7:
            // 2 sources

            ** while (this.indent > col)
        }
lbl8:
        // 1 sources

    }

    private boolean addIndent(int column) {
        if (this.indent < column) {
            this.indents.add(this.indent);
            this.indent = column;
            return true;
        }
        return false;
    }

    private void fetchStreamStart() {
        int mark = this.reader.getMark();
        StreamStartToken token = new StreamStartToken(mark, mark, null);
        this.tokens.add(token);
    }

    private void fetchStreamEnd() {
        this.unwindIndent(-1);
        int mark = this.reader.getMark();
        this.clearProblems();
        this.removePossibleSimpleKey(mark);
        this.allowSimpleKey = false;
        this.possibleSimpleKeys.clear();
        StreamEndToken token = new StreamEndToken(mark, mark, null);
        this.tokens.add(token);
        this.done = true;
    }

    private void fetchDirective() {
        this.unwindIndent(-1);
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.removePossibleSimpleKey(startMark);
        this.allowSimpleKey = false;
        Token tok = this.scanDirective(startMark);
        this.tokens.add(tok);
    }

    private void fetchDocumentIndicator(Token.ID type) {
        this.unwindIndent(-1);
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.removePossibleSimpleKey(startMark);
        this.allowSimpleKey = false;
        this.reader.forward(3);
        if (type == Token.ID.DocumentEnd) {
            this.scanIgnoredLineTail((byte)0, startMark);
            this.resetToRoot();
        }
        int endMark = this.reader.getMark();
        this.tokens.add(switch (type) {
            case Token.ID.DocumentStart -> new DocumentStartToken(startMark, endMark, this.scanProblem);
            case Token.ID.DocumentEnd -> new DocumentEndToken(startMark, endMark, this.scanProblem);
            default -> throw new IllegalArgumentException();
        });
    }

    private void fetchFlowSequenceStart() {
        this.fetchFlowCollectionStart(false);
    }

    private void fetchFlowMappingStart() {
        this.fetchFlowCollectionStart(true);
    }

    private void fetchFlowCollectionStart(boolean isMappingStart) {
        this.clearProblems();
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        int startMark = this.reader.getMark();
        this.reader.forward(1);
        int endMark = this.reader.getMark();
        Token token = isMappingStart ? new FlowMappingStartToken(startMark, endMark, this.scanProblem) : new FlowSequenceStartToken(startMark, endMark, this.scanProblem);
        this.tokens.add(token);
    }

    private void fetchFlowSequenceEnd() {
        this.fetchFlowCollectionEnd(false);
    }

    private void fetchFlowMappingEnd() {
        this.fetchFlowCollectionEnd(true);
    }

    private void fetchFlowCollectionEnd(boolean isMappingEnd) {
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.removePossibleSimpleKey(startMark);
        --this.flowLevel;
        this.allowSimpleKey = false;
        this.reader.forward();
        int endMark = this.reader.getMark();
        Token token = isMappingEnd ? new FlowMappingEndToken(startMark, endMark, this.scanProblem) : new FlowSequenceEndToken(startMark, endMark, this.scanProblem);
        this.tokens.add(token);
    }

    private void fetchFlowEntry() {
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey(startMark);
        this.reader.forward();
        int endMark = this.reader.getMark();
        FlowEntryToken token = new FlowEntryToken(startMark, endMark, this.scanProblem);
        this.tokens.add(token);
    }

    private void fetchBlockEntry() {
        int startMark = this.reader.getMark();
        this.clearProblems();
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                this.newScannerException((byte)0, startMark, 0x400200, startMark);
            }
            if (this.addIndent(this.reader.getColumn())) {
                this.tokens.add(new BlockSequenceStartToken(startMark, startMark, this.scanProblem));
            }
        }
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey(startMark);
        this.reader.forward();
        int endMark = this.reader.getMark();
        BlockEntryToken token = new BlockEntryToken(startMark, endMark, this.scanProblem);
        this.tokens.add(token);
    }

    private void fetchKey() {
        int startMark = this.reader.getMark();
        this.clearProblems();
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                this.newScannerException((byte)0, startMark, 0x400200, startMark);
            }
            if (this.addIndent(this.reader.getColumn())) {
                int mark = this.reader.getMark();
                this.tokens.add(new BlockMappingStartToken(mark, mark, this.scanProblem));
            }
        }
        this.allowSimpleKey = this.flowLevel == 0;
        this.removePossibleSimpleKey(startMark);
        this.reader.forward();
        int endMark = this.reader.getMark();
        KeyToken token = new KeyToken(startMark, endMark, this.scanProblem);
        this.tokens.add(token);
    }

    private void fetchValue() {
        int startMark = this.reader.getMark();
        this.clearProblems();
        SimpleKey key = this.possibleSimpleKeys.remove(this.flowLevel);
        if (key != null) {
            this.tokens.add(key.getTokenNumber() - this.tokensTaken, new KeyToken(key.getMark(), key.getMark(), null));
            if (this.flowLevel == 0 && this.addIndent(key.getColumn())) {
                this.tokens.add(key.getTokenNumber() - this.tokensTaken, new BlockMappingStartToken(key.getMark(), key.getMark(), null));
            }
            this.allowSimpleKey = false;
        } else {
            if (this.flowLevel == 0 && !this.allowSimpleKey) {
                this.newScannerException((byte)0, startMark, 0x400200, startMark);
            }
            if (this.flowLevel == 0 && this.addIndent(this.reader.getColumn())) {
                int mark = this.reader.getMark();
                this.tokens.add(new BlockMappingStartToken(mark, mark, null));
            }
            this.allowSimpleKey = this.flowLevel == 0;
            this.removePossibleSimpleKey(startMark);
        }
        this.reader.forward();
        int endMark = this.reader.getMark();
        ValueToken token = new ValueToken(startMark, endMark, this.scanProblem);
        this.tokens.add(token);
    }

    private void fetchAlias() {
        this.clearProblems();
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor((byte)9);
        this.tokens.add(tok);
    }

    private void fetchAnchor() {
        this.clearProblems();
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanAnchor((byte)8);
        this.tokens.add(tok);
    }

    private void fetchTag() {
        this.clearProblems();
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanTag();
        this.tokens.add(tok);
    }

    private void fetchLiteral() {
        this.fetchBlockScalar(ScalarStyle.LITERAL);
    }

    private void fetchFolded() {
        this.fetchBlockScalar(ScalarStyle.FOLDED);
    }

    private void fetchBlockScalar(ScalarStyle style) {
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey(startMark);
        Token tok = this.scanBlockScalar(style, startMark);
        this.tokens.add(tok);
    }

    private void fetchSingle() {
        this.fetchFlowScalar((byte)12);
    }

    private void fetchDouble() {
        this.fetchFlowScalar((byte)13);
    }

    private void fetchFlowScalar(byte context) {
        this.clearProblems();
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanFlowScalar(context);
        this.tokens.add(tok);
    }

    private void fetchPlain() {
        this.clearProblems();
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token tok = this.scanPlain();
        this.tokens.add(tok);
    }

    private boolean checkDirective() {
        return this.reader.getColumn() == 0;
    }

    private boolean checkDocumentStart() {
        if (this.reader.getColumn() == 0) {
            return "---".equals(this.reader.prefix(3)) && CharConstants.isWhiteSpaceOrEol(this.reader.peek(3));
        }
        return false;
    }

    private boolean checkDocumentEnd() {
        if (this.reader.getColumn() == 0) {
            return "...".equals(this.reader.prefix(3)) && CharConstants.isWhiteSpaceOrEol(this.reader.peek(3));
        }
        return false;
    }

    private boolean checkBlockEntry() {
        return CharConstants.isWhiteSpaceOrEol(this.reader.peek(1));
    }

    private boolean checkKey() {
        if (this.flowLevel != 0) {
            return true;
        }
        return CharConstants.isWhiteSpaceOrEol(this.reader.peek(1));
    }

    private boolean checkValue() {
        if (this.flowLevel != 0) {
            return true;
        }
        return CharConstants.isWhiteSpaceOrEol(this.reader.peek(1));
    }

    private boolean checkPlain() {
        int c = this.reader.peek();
        return CharConstants.NULL_BL_T_LINEBR.hasNo(c, "-?:,[]{}#&*!|>'\"@`") || CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(1)) && (c == 45 || this.flowLevel == 0 && "?:".indexOf(c) != -1);
    }

    private void scanToNextToken() {
        if (this.reader.getIndex() == 0 && this.reader.peek() == 65279) {
            this.reader.forward();
        }
        boolean found = false;
        int inlineStartColumn = -1;
        while (!found) {
            String breaks;
            int startMark = this.reader.getMark();
            int startColumn = this.reader.getColumn();
            boolean commentSeen = false;
            int ff = 0;
            while (this.reader.peek(ff) == 32 || this.reader.peek(ff) == 9) {
                ++ff;
            }
            if (ff > 0) {
                this.reader.forward(ff);
            }
            if (this.reader.peek() == 35) {
                CommentType type;
                commentSeen = true;
                if (startColumn != 0) {
                    type = CommentType.IN_LINE;
                    inlineStartColumn = this.reader.getColumn();
                } else if (inlineStartColumn == this.reader.getColumn()) {
                    type = CommentType.IN_LINE;
                } else {
                    inlineStartColumn = -1;
                    type = CommentType.BLOCK;
                }
                this.scanComment(type);
            }
            if ((breaks = this.scanLineBreak()).length() != 0) {
                if (this.flowLevel != 0) continue;
                this.allowSimpleKey = true;
                continue;
            }
            found = true;
        }
    }

    private void forwardToLineEnd() {
        int c;
        while (!CharConstants.isEol(c = this.reader.peek())) {
            if (c == 35) {
                this.scanComment(CommentType.IN_LINE);
                break;
            }
            this.reader.forward();
        }
    }

    private void scanComment(CommentType type) {
        int startMark = this.reader.getMark();
        this.reader.forward();
        while (!CharConstants.isEol(this.reader.peek())) {
            this.reader.forward();
        }
        if (this.getParseComments()) {
            this.handleComment(type, startMark, this.reader.getMark());
        }
    }

    private Token scanDirective(int startMark) {
        int endMark;
        List<Object> value;
        this.reader.forward();
        String name = this.scanDirectiveName(startMark);
        if ("YAML".equals(name)) {
            value = this.scanYamlDirectiveValue(startMark);
            endMark = this.reader.getMark();
            this.scanIgnoredLineTail((byte)3, startMark);
        } else if ("TAG".equals(name)) {
            value = this.scanTagDirectiveValue(startMark);
            endMark = this.reader.getMark();
            this.scanIgnoredLineTail((byte)3, startMark);
        } else {
            value = null;
            endMark = this.reader.getMark();
            this.forwardToLineEnd();
        }
        return new DirectiveToken<Integer>(name, value, startMark, endMark, this.scanProblem);
    }

    private String scanDirectiveName(int startMark) {
        int c;
        int length = 0;
        while (CharConstants.ALPHA.has(c = this.reader.peek(length))) {
            ++length;
        }
        if (length == 0) {
            this.newScannerException((byte)3, startMark, 4194673, this.reader.getMark());
            return "";
        }
        if (!CharConstants.isWhiteSpaceOrEol(c)) {
            this.newScannerException((byte)3, startMark, 4194675, this.reader.getMark());
        }
        return this.reader.prefixForward(length);
    }

    private List<@Nullable Integer> scanYamlDirectiveValue(int startMark) {
        Integer minor = null;
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        int startOffset = this.reader.getMark();
        Integer major = this.scanYamlDirectiveNumber(startMark);
        if (major == null) {
            this.newScannerException((byte)4, startMark, 4194689, startOffset);
        }
        if (this.reader.peek() != 46) {
            this.newScannerException((byte)4, startMark, 4194690, startOffset, this.reader.getMark() + 1, null);
        } else {
            this.reader.forward();
            minor = this.scanYamlDirectiveNumber(startMark);
            if (minor == null) {
                this.newScannerException((byte)4, startMark, 4194690, startOffset, this.reader.getMark() + 1, null);
            }
        }
        if (!this.scanOK) {
            this.forwardToLineEnd();
        }
        ArrayList<Integer> result = new ArrayList<Integer>(2);
        result.add(major);
        result.add(minor);
        return result;
    }

    private @Nullable Integer scanYamlDirectiveNumber(int startMark) {
        int c;
        int length = 0;
        while ((c = this.reader.peek(length)) >= 48 && c <= 57) {
            ++length;
        }
        if (length == 0) {
            return null;
        }
        return Integer.valueOf(this.reader.prefixForward(length));
    }

    private List<@Nullable String> scanTagDirectiveValue(int startMark) {
        String prefix = null;
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        String handle = this.scanTagHandle((byte)5, startMark);
        if (this.scanOK) {
            int c = this.reader.peek();
            if (c != 32) {
                this.newScannerException((byte)5, startMark, 4194723, this.reader.getMark(), this.reader.getMark() + 1, null);
            }
            while (this.reader.peek() == 32) {
                this.reader.forward();
            }
            prefix = this.scanTagUri((byte)5, startMark);
        }
        ArrayList<String> result = new ArrayList<String>(2);
        result.add(handle);
        result.add(prefix);
        return result;
    }

    private void scanIgnoredLineTail(byte context, int startMark) {
        String lineBreak;
        int c;
        int length = 0;
        while ((c = this.reader.peek(length)) == 32) {
            ++length;
        }
        this.reader.forward(length);
        if (c == 35) {
            if (length == 0) {
                this.newScannerException(context, startMark, 4194609, this.reader.getMark());
            }
            this.scanComment(CommentType.IN_LINE);
        }
        if ((lineBreak = this.scanLineBreak()).isEmpty() && (c = this.reader.peek()) != 0) {
            this.newScannerException(context, startMark, 4194610, this.reader.getMark(), this.reader.getMark() + 1, null);
            this.forwardToLineEnd();
        }
    }

    private Token scanAnchor(byte context) {
        int c;
        int startMark = this.reader.getMark();
        this.reader.forward();
        int length = 0;
        while (CharConstants.NULL_BL_T_LINEBR.hasNo(c = this.reader.peek(length), ",[]{}/.&")) {
            ++length;
        }
        String value = null;
        if (length == 0) {
            this.newScannerException(context, startMark, 4194673, this.reader.getMark());
        } else if (this.createAnchorText) {
            value = this.reader.prefixForward(length);
        } else {
            this.reader.forward(length);
        }
        if (this.scanOK && CharConstants.NULL_BL_T_LINEBR.hasNo(c = this.reader.peek(), "?:,]}%@`")) {
            this.newScannerException(context, startMark, 4194608, this.reader.getMark(), this.reader.getMark() + 1, Character.toString(c));
        }
        int endMark = this.reader.getMark();
        Token tok = context == 9 ? new AliasToken(value, startMark, endMark, this.scanProblem) : new AnchorToken(value, startMark, endMark, this.scanProblem);
        return tok;
    }

    private Token scanTag() {
        String suffix;
        String handle;
        int startMark = this.reader.getMark();
        int c = this.reader.peek(1);
        if (c == 60) {
            handle = null;
            this.reader.forward(2);
            suffix = this.scanTagUri((byte)10, startMark);
            c = this.reader.peek();
            if (c != 62) {
                this.newScannerException((byte)10, startMark, 4919568);
            } else {
                this.reader.forward();
            }
        } else if (CharConstants.isWhiteSpaceOrEol(c)) {
            handle = null;
            suffix = "!";
            this.reader.forward();
        } else {
            int length = 1;
            boolean useHandle = false;
            while (!CharConstants.isWhiteSpaceOrEol(c)) {
                if (c == 33) {
                    useHandle = true;
                    break;
                }
                c = this.reader.peek(++length);
            }
            if (useHandle) {
                handle = this.scanTagHandle((byte)10, startMark);
            } else {
                handle = "!";
                this.reader.forward();
            }
            suffix = this.scanTagSuffix((byte)10, startMark);
        }
        if (!(!this.scanOK || CharConstants.isWhiteSpaceOrEol(c = this.reader.peek()) || this.flowLevel != 0 && CharConstants.isFlowCollectionEntryEndControl(c))) {
            this.newScannerException((byte)10, startMark, 4194610, this.reader.getMark());
        }
        int endMark = this.reader.getMark();
        TagTuple value = new TagTuple(handle, suffix);
        return new TagToken(value, startMark, endMark, this.scanProblem);
    }

    private Token scanBlockScalar(ScalarStyle style, int startMark) {
        int blockIndent;
        int endMark;
        StringBuilder chunks = this.getScalarSB();
        this.reader.forward();
        Chomping chomping = this.scanBlockScalarIndicators(startMark);
        this.scanIgnoredLineTail((byte)11, startMark);
        int minIndent = this.indent + 1;
        if (chomping.increment == -1) {
            endMark = this.scanBlockScalarIndentation();
            int maxIndent = this.tmpInt;
            blockIndent = Math.max(minIndent, maxIndent);
        } else {
            blockIndent = minIndent + chomping.increment - 1;
            endMark = this.scanBlockScalarBreaks(blockIndent);
        }
        String lineBreak = "";
        while (this.reader.getColumn() == blockIndent && this.reader.peek() != 0) {
            boolean leadingNonSpace = !CharConstants.isWhiteSpace(this.reader.peek());
            int length = 0;
            while (!CharConstants.isEol(this.reader.peek(length))) {
                ++length;
            }
            if (length == 3 && this.reader.prefix(length).equals("...")) {
                lineBreak = "";
                break;
            }
            if (chunks != null) {
                chunks.append(this.getBreaks());
                chunks.append(this.reader.prefix(length));
            }
            this.reader.forward(length);
            lineBreak = this.scanLineBreak();
            endMark = this.scanBlockScalarBreaks(blockIndent);
            if (this.reader.getColumn() != blockIndent || this.reader.peek() == 0) break;
            if (chunks == null) continue;
            if (style == ScalarStyle.FOLDED && "\n".equals(lineBreak) && leadingNonSpace && " \t".indexOf(this.reader.peek()) == -1) {
                if (this.getBreaks().length() != 0) continue;
                chunks.append(" ");
                continue;
            }
            chunks.append(lineBreak);
        }
        if (chunks != null) {
            switch (chomping.method) {
                case 1: {
                    chunks.append(lineBreak);
                    break;
                }
                case 2: {
                    chunks.append(lineBreak);
                    chunks.append(this.getBreaks());
                    break;
                }
            }
        }
        return new ScalarToken(chunks != null ? chunks.toString() : null, style, startMark, endMark, this.scanProblem);
    }

    private Chomping scanBlockScalarIndicators(int startMark) {
        int chomping = 1;
        int increment = -1;
        int c = this.reader.peek();
        while (c == 45 || c == 43) {
            if (chomping == 1) {
                chomping = c == 43 ? 2 : 0;
            } else {
                this.newScannerException((byte)11, startMark, 4194659, this.reader.getIndex(), this.reader.getIndex() + 1, null);
            }
            this.reader.forward();
            c = this.reader.peek();
        }
        if (c >= 48 && c <= 57) {
            int startOffset = this.reader.getMark();
            increment = c - 48;
            int length = 1;
            while ((c = this.reader.peek(length)) >= 48 && c <= 57) {
                ++length;
            }
            if (length > 1 || increment == 0) {
                this.newScannerException((byte)11, startMark, 4194657, startOffset, this.reader.getMark() + length, this.reader.prefix(length));
                increment = -1;
            }
            this.reader.forward(length);
            while (c == 45 || c == 43) {
                if (chomping == 1) {
                    chomping = c == 43 ? 2 : 0;
                } else {
                    this.newScannerException((byte)11, startMark, 4194659, this.reader.getIndex(), this.reader.getIndex() + 1, null);
                }
                this.reader.forward();
                c = this.reader.peek();
            }
        }
        return new Chomping((byte)chomping, increment);
    }

    private int scanBlockScalarIndentation() {
        StringBuilder chunks = this.getBreaksSB();
        int maxIndent = 0;
        int endMark = this.reader.getMark();
        while (CharConstants.LINEBR.has(this.reader.peek(), " \r")) {
            if (this.reader.peek() != 32) {
                chunks.append(this.scanLineBreak());
                endMark = this.reader.getMark();
                continue;
            }
            this.reader.forward();
            if (this.reader.getColumn() <= maxIndent) continue;
            maxIndent = this.reader.getColumn();
        }
        this.tmpInt = maxIndent;
        return endMark;
    }

    private int scanBlockScalarBreaks(int indent) {
        StringBuilder chunks = this.getBreaksSB();
        int endMark = this.reader.getMark();
        int col = this.reader.getColumn();
        while (col < indent && this.reader.peek() == 32) {
            this.reader.forward();
            ++col;
        }
        String lineBreak = null;
        while ((lineBreak = this.scanLineBreak()).length() != 0) {
            chunks.append(lineBreak);
            endMark = this.reader.getMark();
            col = this.reader.getColumn();
            while (col < indent && this.reader.peek() == 32) {
                this.reader.forward();
                ++col;
            }
        }
        return endMark;
    }

    private Token scanFlowScalar(byte context) {
        StringBuilder chunks;
        ScalarStyle style;
        int startMark;
        block7: {
            startMark = this.reader.getMark();
            int quote = switch (context) {
                case 13 -> {
                    style = ScalarStyle.DOUBLE_QUOTED;
                    yield 34;
                }
                case 12 -> {
                    style = ScalarStyle.SINGLE_QUOTED;
                    yield 39;
                }
                default -> throw new IllegalStateException(Integer.toString(context));
            };
            if (this.reader.peek() != quote) {
                throw new IllegalStateException(new String(Character.toChars(this.reader.peek())));
            }
            this.reader.forward();
            chunks = this.getScalarSB();
            do {
                this.scanFlowScalarNonSpaces(quote == 34, startMark, chunks);
                if (this.reader.peek() != quote) continue;
                this.reader.forward();
                break block7;
            } while (this.scanFlowScalarSpaces(context, startMark, chunks));
            this.newScannerException(context, startMark, 4751632);
        }
        int endMark = this.reader.getMark();
        if (this.reader.peek() == 35) {
            this.newScannerException(context, startMark, 4194609, this.reader.getMark());
        }
        return new ScalarToken(chunks != null ? chunks.toString() : null, style, startMark, endMark, this.scanProblem);
    }

    private void scanFlowScalarNonSpaces(boolean doubleQuoted, int startMark, @Nullable StringBuilder chunks) {
        while (true) {
            int expLength;
            Character ch;
            Character bmp;
            int length = 0;
            while (CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(length), "'\"\\")) {
                ++length;
            }
            if (length != 0) {
                if (chunks != null) {
                    chunks.append(this.reader.prefix(length));
                }
                this.reader.forward(length);
            }
            int c = this.reader.peek();
            if (!doubleQuoted && c == 39 && this.reader.peek(1) == 39) {
                if (chunks != null) {
                    chunks.append("'");
                }
                this.reader.forward(2);
                continue;
            }
            if (doubleQuoted && c == 39 || !doubleQuoted && "\"\\".indexOf(c) != -1) {
                if (chunks != null) {
                    chunks.appendCodePoint(c);
                }
                this.reader.forward();
                continue;
            }
            if (!doubleQuoted || c != 92) break;
            int startOffset = this.reader.getMark();
            this.reader.forward();
            c = this.reader.peek();
            Character c2 = bmp = Character.isBmpCodePoint(c) ? Character.valueOf((char)c) : null;
            if (bmp != null && (ch = CharConstants.getEscapeReplacement(bmp)) != null) {
                this.reader.forward();
                if (chunks == null) continue;
                chunks.append(ch);
                continue;
            }
            if (bmp != null && (expLength = CharConstants.getEscapeCodeBytes(bmp.charValue())) > 0) {
                this.reader.forward();
                length = 0;
                while (length < expLength) {
                    c = this.reader.peek(length);
                    if (!CharConstants.isHexDigit(c)) break;
                    ++length;
                }
                if (length != expLength) {
                    chunks = null;
                    this.newScannerException((byte)13, startMark, 4751648, startOffset, this.reader.getMark() + length, "\\" + bmp + this.reader.prefix(length));
                } else if (chunks != null) {
                    int codePoint = Integer.parseInt(this.reader.prefix(length), 16);
                    chunks.appendCodePoint(codePoint);
                }
                this.reader.forward(length);
                continue;
            }
            if (this.scanLineBreak().length() != 0) {
                this.scanFlowScalarBreaks((byte)13, startMark);
                if (chunks == null) continue;
                chunks.append(this.getBreaks());
                continue;
            }
            this.newScannerException((byte)13, startMark, 4751648, startOffset, this.reader.getMark() + 1, "\\" + Character.toString(c));
        }
    }

    private boolean scanFlowScalarSpaces(byte context, int startMark, @Nullable StringBuilder chunks) {
        int length = 0;
        while (" \t".indexOf(this.reader.peek(length)) != -1) {
            ++length;
        }
        String whitespaces = chunks != null ? this.reader.prefix(length) : null;
        this.reader.forward(length);
        if (this.reader.peek() == 0) {
            return false;
        }
        String lineBreak = this.scanLineBreak();
        if (lineBreak.length() != 0) {
            if (!this.scanFlowScalarBreaks(context, startMark)) {
                return false;
            }
            if (chunks != null) {
                String breaks = this.getBreaks();
                if (!"\n".equals(lineBreak)) {
                    chunks.append(lineBreak);
                } else if (breaks.length() == 0) {
                    chunks.append(" ");
                }
                chunks.append(breaks);
            }
        } else if (chunks != null) {
            chunks.append(whitespaces);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean scanFlowScalarBreaks(byte context, int startMark) {
        chunks = this.getBreaksSB();
        while (true) {
            if (!"---".equals(prefix = this.reader.prefix(3)) && !"...".equals(prefix) || !CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) ** GOTO lbl6
            return false;
lbl-1000:
            // 1 sources

            {
                this.reader.forward();
lbl6:
                // 2 sources

                ** while (CharConstants.isWhiteSpace((int)this.reader.peek()))
            }
lbl7:
            // 1 sources

            lineBreak = this.scanLineBreak();
            if (lineBreak.length() == 0) break;
            chunks.append(lineBreak);
        }
        return true;
    }

    private Token scanPlain() {
        int startMark = this.reader.getMark();
        StringBuilder chunks = this.getScalarSB();
        int endMark = startMark;
        int plainIndent = this.indent + 1;
        String spaces = "";
        do {
            int c;
            int length = 0;
            if (this.reader.peek() == 35) break;
            while (!(CharConstants.NULL_BL_T_LINEBR.has(c = this.reader.peek(length)) || c == 58 && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(length + 1), this.flowLevel != 0 ? ",[]{}" : "") || this.flowLevel != 0 && ",?[]{}".indexOf(c) != -1)) {
                ++length;
            }
            if (length == 0) break;
            this.allowSimpleKey = false;
            if (chunks != null) {
                chunks.append(spaces);
                chunks.append(this.reader.prefix(length));
            }
            this.reader.forward(length);
            endMark = this.reader.getMark();
        } while ((spaces = this.scanPlainSpaces()).length() != 0 && this.reader.peek() != 35 && (this.flowLevel != 0 || this.reader.getColumn() >= plainIndent));
        return new ScalarToken(chunks != null ? chunks.toString() : null, ScalarStyle.PLAIN, startMark, endMark, this.scanProblem);
    }

    private boolean atEndOfPlain() {
        int c;
        int wsLength = 0;
        int wsColumn = this.reader.getColumn();
        while ((c = this.reader.peek(wsLength)) != 0 && CharConstants.NULL_BL_T_LINEBR.has(c)) {
            if (!(CharConstants.LINEBR.has(c) || c == 13 && this.reader.peek(++wsLength + 1) == 10 || c == 65279)) {
                ++wsColumn;
                continue;
            }
            wsColumn = 0;
        }
        if (this.reader.peek(wsLength) == 35 || this.reader.peek(wsLength + 1) == 0 || this.flowLevel == 0 && wsColumn < this.indent) {
            return true;
        }
        if (this.flowLevel == 0) {
            int extra = 1;
            while ((c = this.reader.peek(wsLength + extra)) != 0 && !CharConstants.NULL_BL_T_LINEBR.has(c)) {
                if (c == 58 && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(wsLength + extra + 1))) {
                    return true;
                }
                ++extra;
            }
        }
        return false;
    }

    private String scanPlainSpaces() {
        int length = 0;
        while (CharConstants.isWhiteSpace(this.reader.peek(length))) {
            ++length;
        }
        String whitespaces = this.reader.prefixForward(length);
        String lineBreak = this.scanLineBreak();
        if (lineBreak.length() != 0) {
            StringBuilder breaks;
            block8: {
                this.allowSimpleKey = true;
                String prefix = this.reader.prefix(3);
                if (("---".equals(prefix) || "...".equals(prefix)) && CharConstants.isWhiteSpaceOrEol(this.reader.peek(3))) {
                    return "";
                }
                if (this.getParseComments() && this.atEndOfPlain()) {
                    return "";
                }
                breaks = this.getBreaksSB();
                while (true) {
                    if (CharConstants.isWhiteSpace(this.reader.peek())) {
                        this.reader.forward();
                        continue;
                    }
                    String lb = this.scanLineBreak();
                    if (lb.length() == 0) break block8;
                    breaks.append(lb);
                    prefix = this.reader.prefix(3);
                    if (("---".equals(prefix) || "...".equals(prefix)) && CharConstants.isWhiteSpaceOrEol(this.reader.peek(3))) break;
                }
                return "";
            }
            if (!"\n".equals(lineBreak)) {
                return String.valueOf(lineBreak) + breaks;
            }
            if (breaks.length() == 0) {
                return " ";
            }
            return breaks.toString();
        }
        return whitespaces;
    }

    private @Nullable String scanTagHandle(byte context, int startMark) {
        String value = null;
        int c = this.reader.peek();
        if (c != 33) {
            this.newScannerException(context, startMark, 4194721, this.reader.getMark());
            return null;
        }
        int length = 1;
        c = this.reader.peek(length);
        if (c != 32) {
            while (CharConstants.ALPHA.has(c)) {
                c = this.reader.peek(++length);
            }
            if (c == 33) {
                ++length;
            } else {
                this.newScannerException(context, startMark, 4194722, this.reader.getMark());
            }
        }
        if (this.createAnchorText) {
            value = this.reader.prefix(length);
        }
        this.reader.forward(length);
        return value;
    }

    private String scanTagUri(byte context, int startMark) {
        int length = 0;
        while (CharConstants.isUriChar(this.reader.peek(length))) {
            ++length;
        }
        if (length == 0) {
            this.newScannerException(context, startMark, 4194705, this.reader.getMark());
        }
        return this.reader.prefixForward(length);
    }

    private String scanTagSuffix(byte context, int startMark) {
        int length = 0;
        while (CharConstants.isTagChar(this.reader.peek(length))) {
            ++length;
        }
        if (length == 0) {
            this.newScannerException(context, startMark, 4194725, this.reader.getMark());
        }
        return this.reader.prefixForward(length);
    }

    private String scanLineBreak() {
        switch (this.reader.peek()) {
            case 10: 
            case 133: {
                this.reader.forward();
                return "\n";
            }
            case 13: {
                if (10 == this.reader.peek(1)) {
                    this.reader.forward(2);
                } else {
                    this.reader.forward();
                }
                return "\n";
            }
            case 8232: {
                this.reader.forward();
                return "\u2028";
            }
            case 8233: {
                this.reader.forward();
                return "\u2029";
            }
        }
        return "";
    }

    private @Nullable StringBuilder getScalarSB() {
        if (this.createContentText) {
            this.tmpSB.setLength(0);
            return this.tmpSB;
        }
        return null;
    }

    private StringBuilder getBreaksSB() {
        this.tmpSB2.setLength(0);
        return this.tmpSB2;
    }

    private String getBreaks() {
        return this.tmpSB2.toString();
    }

    private void newScannerException(byte context, int contextMark, int status) {
        if (this.scanOK) {
            this.scanOK = false;
            this.handleSyntaxProblem(context, contextMark, status, null);
        }
    }

    private void newScannerException(byte context, int contextMark, int status, int offset) {
        if (this.scanOK) {
            this.scanOK = false;
            this.handleSyntaxProblem(context, contextMark, status, new StatusDetail(offset, offset, null));
        }
    }

    private void newScannerException(byte context, int contextMark, int status, int startOffset, int endOffset, @Nullable String problemArg1) {
        if (this.scanOK) {
            this.scanOK = false;
            this.handleSyntaxProblem(context, contextMark, status, new StatusDetail(startOffset, endOffset, problemArg1));
        }
    }

    protected void clearProblems() {
        this.scanOK = true;
        this.scanProblem = null;
    }

    protected void handleSyntaxProblem(byte context, int contextIndex, int status, @Nullable StatusDetail statusDetail) {
        this.scanProblem = new SyntaxProblem(context, status, statusDetail);
    }

    protected void handleComment(CommentType type, int startIndex, int endIndex) {
    }

    private static class Chomping {
        final byte method;
        final int increment;

        public Chomping(byte method, int increment) {
            this.method = method;
            this.increment = increment;
        }
    }
}

