/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.models.core.util;

import java.lang.reflect.Array;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class ElementPartitionFactory<E, T> {
    public static final int DEFAULT_PART_SIZE = 100;
    private static final int PART_LAST_ADD = 10;
    private final int partSize;
    private final int partLastSize;
    private final Class<E> elementClass;

    public ElementPartitionFactory(Class<E> elementClass, int partSize) {
        this.elementClass = elementClass;
        this.partSize = partSize;
        this.partLastSize = partSize + 10;
    }

    public E[] getElements(T value, long length) {
        long l;
        if (length <= (long)this.partLastSize) {
            return this.getChildren(value, 0L, (int)length);
        }
        long dim = 1L;
        while ((l = length % dim > 10L ? length / (dim *= (long)this.partSize) + 1L : length / (dim *= (long)this.partSize)) > (long)this.partLastSize) {
        }
        return this.createPartitions(value, dim, 0L, length);
    }

    private E[] createPartitions(T value, long dim, long start, long length) {
        long nextDim = dim / (long)this.partSize;
        Object[] variables = (Object[])Array.newInstance(this.elementClass, length / nextDim % (long)this.partSize > 10L ? (int)(length / dim + 1L) : (int)(length / dim));
        int last = variables.length - 1;
        int i = 0;
        while (i < last) {
            variables[i] = this.createPartition(value, new PartitionHandle(nextDim, start + (long)i * dim, dim));
            ++i;
        }
        variables[last] = this.createPartition(value, new PartitionHandle(nextDim, start + (long)last * dim, length - (long)last * dim));
        return variables;
    }

    protected abstract E createPartition(T var1, PartitionHandle var2);

    protected abstract E[] getChildren(T var1, long var2, int var4);

    public final class PartitionHandle {
        private final long dim;
        private final long start;
        private final long length;

        private PartitionHandle(long dim, long start, long length) {
            this.dim = dim;
            this.start = start;
            this.length = length;
        }

        public long getStart() {
            return this.start;
        }

        public long getLength() {
            return this.length;
        }

        public E[] getElements(T value) {
            return this.dim == 1L ? ElementPartitionFactory.this.getChildren(value, this.start, (int)this.length) : ElementPartitionFactory.this.createPartitions(value, this.dim, this.start, this.length);
        }

        public int hashCode() {
            long s = (this.start >>> 1) + 7L;
            return (int)(this.dim ^ this.dim >>> 32 ^ s ^ s >>> 32);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof PartitionHandle && this.equals((PartitionHandle)obj);
        }

        public boolean equals(PartitionHandle other) {
            return this.dim == other.dim && this.start == other.start;
        }
    }
}

