/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core;

import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class SearchPattern {
    public static final int EXACT_MATCH = 2;
    public static final int PREFIX_MATCH = 4;
    public static final int WORD_PREFIX_MATCH = 8;
    public static final int SUBSTRING_MATCH = 16;
    public static final int OTHER_MATCH = 0x1000000;
    private int allowedRules;
    private String pattern = "";
    private char @Nullable [] patternChars;
    private String nameCharsString;
    private char @Nullable [] nameChars;
    protected final IntList tmpRegions = new IntArrayList();

    public SearchPattern(int rules, String pattern) {
        this.setRules(rules);
        this.setPattern(pattern);
    }

    public int getSupportedRules() {
        return 20;
    }

    public int getRules() {
        return this.allowedRules;
    }

    protected int checkRules(int rules) {
        if ((rules & 0x10) != 0) {
            rules |= 4;
        }
        return rules & this.getSupportedRules();
    }

    public void setRules(int rules) {
        if ((rules = this.checkRules(rules)) == this.allowedRules) {
            return;
        }
        this.allowedRules = rules;
    }

    public void setPattern(String pattern) {
        if (pattern.equals(this.pattern)) {
            return;
        }
        this.pattern = pattern;
        this.patternChars = null;
        this.onPatternChanged(pattern);
    }

    protected void onPatternChanged(String pattern) {
    }

    public String getPattern() {
        return this.pattern;
    }

    protected char[] getPatternChars() {
        char[] patternChars = this.patternChars;
        if (patternChars == null) {
            this.patternChars = patternChars = this.createCompareChars(this.getPattern());
        }
        return patternChars;
    }

    protected char[] getNameChars(String name) {
        char[] nameChars;
        char[] cArray = nameChars = this.nameCharsString == name ? this.nameChars : null;
        if (nameChars == null) {
            nameChars = this.createCompareChars(name);
            this.nameCharsString = name;
            this.nameChars = nameChars;
        }
        return nameChars;
    }

    protected char[] createCompareChars(String s) {
        char[] chars = new char[s.length()];
        int i = 0;
        while (i < chars.length) {
            chars[i] = Character.toLowerCase(s.charAt(i));
            ++i;
        }
        return chars;
    }

    public int matches(String name) {
        int allowedRules = this.getRules();
        char[] patternChars = null;
        char[] nameChars = null;
        int patternLength = this.getPattern().length();
        int lDiff = name.length() - patternLength;
        if (lDiff >= 0) {
            if ((allowedRules & 4) != 0 && (patternLength == 0 || this.isPrefixMatch(patternChars = this.getPatternChars(), 0, patternChars.length, name, 0, name.length()))) {
                return 4;
            }
            if (lDiff > 0 && (allowedRules & 0x10) != 0 && this.isSubstringMatch(patternChars = this.getPatternChars(), 0, patternChars.length, nameChars = this.getNameChars(name), 1, nameChars.length)) {
                return 16;
            }
        }
        return 0;
    }

    public int @Nullable [] getMatchingRegions(String name, int matchRule) {
        switch (matchRule) {
            case 2: 
            case 4: {
                if (this.pattern.isEmpty()) {
                    return null;
                }
                int[] nArray = new int[2];
                nArray[1] = this.pattern.length();
                return nArray;
            }
            case 16: {
                this.tmpRegions.clear();
                char[] patternChars = this.getPatternChars();
                char[] nameChars = this.getNameChars(name);
                this.addSubstringMatches(patternChars, 0, patternChars.length, nameChars, 0, nameChars.length);
                return this.tmpRegions.toArray();
            }
        }
        return null;
    }

    protected boolean isPrefixMatch(char[] pattern, int patternStart, int patternEnd, String name, int nameStart, int nameEnd) {
        if (nameEnd - nameStart < patternEnd - patternStart) {
            return false;
        }
        int patternIdx = patternStart;
        int nameIdx = nameStart;
        while (patternIdx < patternEnd) {
            char nameChar;
            char patternChar = pattern[patternIdx++];
            if ((nameChar = name.charAt(nameIdx++)) == patternChar || Character.toLowerCase(nameChar) == patternChar) continue;
            return false;
        }
        return true;
    }

    protected boolean isPrefixMatch(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd) {
        if (nameEnd - nameStart < patternEnd - patternStart) {
            return false;
        }
        int patternIdx = patternStart;
        int nameIdx = nameStart;
        while (patternIdx < patternEnd) {
            char patternChar;
            char nameChar;
            if ((nameChar = name[nameIdx++]) == (patternChar = pattern[patternIdx++]) || Character.toLowerCase(nameChar) == patternChar) continue;
            return false;
        }
        return true;
    }

    protected void addPrefixMatch(int patternStart, int patternEnd, int nameStart) {
        this.tmpRegions.add(nameStart);
        this.tmpRegions.add(patternEnd - patternStart);
    }

    protected boolean isSubstringMatch(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd) {
        int nameLastStart = nameEnd - (patternEnd - patternStart);
        block0: for (int nameCurrentStart = nameStart; nameCurrentStart <= nameLastStart; ++nameCurrentStart) {
            int patternIdx = patternStart;
            int nameIdx = nameCurrentStart;
            while (patternIdx < patternEnd) {
                char patternChar;
                char nameChar;
                if ((nameChar = name[nameIdx++]) == (patternChar = pattern[patternIdx++])) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    protected void addSubstringMatches(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd) {
        if (patternEnd - patternStart == 0) {
            return;
        }
        int nameLastStart = nameEnd - (patternEnd - patternStart);
        int nameCurrentStart = nameStart;
        block0: while (nameCurrentStart <= nameLastStart) {
            int patternIdx = patternStart;
            int nameIdx = nameCurrentStart;
            while (patternIdx < patternEnd) {
                char patternChar;
                char nameChar;
                if ((nameChar = name[nameIdx++]) == (patternChar = pattern[patternIdx++])) continue;
                ++nameCurrentStart;
                continue block0;
            }
            this.tmpRegions.add(nameCurrentStart);
            this.tmpRegions.add(nameIdx);
            nameCurrentStart = nameIdx;
        }
    }
}

