/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.refactoring;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.components.DataAdapter;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.r.ui.refactoring.Messages;
import org.eclipse.statet.ltk.ui.refactoring.RefactoringBasedStatus;
import org.eclipse.statet.r.core.refactoring.FunctionToS4MethodRefactoring;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FunctionToS4MethodWizard
extends RefactoringWizard {
    public FunctionToS4MethodWizard(FunctionToS4MethodRefactoring ref) {
        super((Refactoring)ref, 100);
        this.setDefaultPageTitle(Messages.FunctionToS4Method_Wizard_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new InputPage());
    }

    private static class InputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "FunctionToS4Method.InputPage";
        private Text functionNameControl;
        private CheckboxTableViewer argumentsViewer;
        private ButtonGroup<FunctionToS4MethodRefactoring.Variable> argumentsButtons;
        private Button generateGenericControl;

        public InputPage() {
            super(PAGE_NAME);
        }

        protected FunctionToS4MethodRefactoring getRefactoring() {
            return (FunctionToS4MethodRefactoring)super.getRefactoring();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
            this.setControl((Control)composite);
            String title = Messages.FunctionToS4Method_Wizard_header;
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
            label.setText(title);
            label.setFont(JFaceResources.getBannerFont());
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Label label2 = new Label(composite, 0);
            label2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            label2.setText(Messages.FunctionToS4Method_Wizard_VariableName_label);
            this.functionNameControl = new Text(composite, 2048);
            this.functionNameControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.functionNameControl.setFont(JFaceResources.getTextFont());
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Control table = this.createArgumentsTable(composite);
            table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            this.generateGenericControl = new Button(composite, 32);
            this.generateGenericControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.generateGenericControl.setText(Messages.FunctionToS4Method_Wizard_GenerateGeneric_label);
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Dialog.applyDialogFont((Control)composite);
            this.initBindings();
            for (FunctionToS4MethodRefactoring.Variable variable : this.getRefactoring().getVariables()) {
                if (!variable.getName().equals("...")) {
                    this.argumentsViewer.setChecked((Object)variable, variable.getUseAsGenericArgumentDefault());
                    continue;
                }
                this.argumentsViewer.setGrayed((Object)variable, true);
                this.argumentsViewer.setChecked((Object)variable, true);
            }
            this.argumentsButtons.updateState();
        }

        private Control createArgumentsTable(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
            Composite above = new Composite(composite, 0);
            above.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
            above.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
            Label label = new Label(above, 0);
            label.setLayoutData((Object)new GridData(4, 1024, true, false));
            label.setText("Method &parameters:");
            label.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 128) {
                        e.doit = false;
                        argumentsViewer.getControl().setFocus();
                    }
                }
            });
            ViewerUtils.CheckboxTableComposite table = new ViewerUtils.CheckboxTableComposite(composite, 67588);
            GridData gd = new GridData(4, 4, true, true, 1, 1);
            gd.heightHint = LayoutUtils.hintHeight((Table)table.table, (int)12);
            table.setLayoutData((Object)gd);
            table.setLayoutData((Object)gd);
            table.table.setHeaderVisible(true);
            table.table.setLinesVisible(true);
            this.argumentsViewer = table.viewer;
            TableViewerColumn column = table.addColumn("Name", 16384, (ColumnLayoutData)new ColumnWeightData(1));
            column.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    Object element = cell.getElement();
                    if (element instanceof FunctionToS4MethodRefactoring.Variable) {
                        cell.setFont(JFaceResources.getDialogFont());
                        FunctionToS4MethodRefactoring.Variable variable = (FunctionToS4MethodRefactoring.Variable)element;
                        cell.setText(variable.getName());
                        return;
                    }
                    cell.setText("");
                }
            });
            column = table.addColumn("Type", 16384, (ColumnLayoutData)new ColumnWeightData(1));
            column.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    Object element = cell.getElement();
                    if (element instanceof FunctionToS4MethodRefactoring.Variable) {
                        cell.setFont(JFaceResources.getTextFont());
                        FunctionToS4MethodRefactoring.Variable variable = (FunctionToS4MethodRefactoring.Variable)element;
                        String type = variable.getArgumentType();
                        cell.setText(type != null ? type : "");
                        return;
                    }
                    cell.setText("");
                }
            });
            TypeEditing editing = new TypeEditing((ColumnViewer)table.viewer);
            column.setEditingSupport((EditingSupport)editing);
            ViewerUtils.installDefaultEditBehaviour((TableViewer)this.argumentsViewer);
            this.argumentsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.argumentsButtons = new ButtonGroup(composite);
            this.argumentsButtons.setLayoutData((Object)new GridData(4, 128, false, true));
            this.argumentsButtons.addUpButton(null);
            this.argumentsButtons.addDownButton(null);
            return composite;
        }

        protected void initBindings() {
            Realm realm = Realm.getDefault();
            DataBindingContext dbc = new DataBindingContext(realm);
            this.addBindings(dbc, realm);
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        }

        protected void addBindings(DataBindingContext dbc, Realm realm) {
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.functionNameControl), PojoProperties.value(FunctionToS4MethodRefactoring.class, (String)"functionName", String.class).observe(realm, (Object)this.getRefactoring()), new UpdateValueStrategy().setAfterGetValidator(value -> new RefactoringBasedStatus(this.getRefactoring().checkFunctionName(value))), null);
            WritableList argumentsList = new WritableList(realm, this.getRefactoring().getVariables(), FunctionToS4MethodRefactoring.Variable.class);
            this.argumentsViewer.addCheckStateListener(arg_0 -> this.lambda$1((IObservableList)argumentsList, arg_0));
            this.argumentsViewer.setInput((Object)argumentsList);
            this.argumentsButtons.connectTo((StructuredViewer)this.argumentsViewer, (DataAdapter)new DataAdapter.ListAdapter<FunctionToS4MethodRefactoring.Variable>((IObservableCollection)argumentsList, null){

                protected void moveByIdx(int oldIdx, int newIdx) {
                    Object upperElement = argumentsViewer.getElementAt(Math.min(oldIdx, newIdx));
                    Object lowerElement = argumentsViewer.getElementAt(Math.max(oldIdx, newIdx));
                    super.moveByIdx(oldIdx, newIdx);
                    if (upperElement instanceof FunctionToS4MethodRefactoring.Variable && !((FunctionToS4MethodRefactoring.Variable)upperElement).getName().equals("...") && lowerElement instanceof FunctionToS4MethodRefactoring.Variable && !((FunctionToS4MethodRefactoring.Variable)lowerElement).getName().equals("...")) {
                        boolean checked = argumentsViewer.getChecked(upperElement);
                        ((FunctionToS4MethodRefactoring.Variable)lowerElement).setUseAsGenericArgument(checked);
                        argumentsViewer.setChecked(lowerElement, checked);
                    }
                }
            });
            dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.generateGenericControl), PojoProperties.value(FunctionToS4MethodRefactoring.class, (String)"generateGeneric", Boolean.TYPE).observe(realm, (Object)this.getRefactoring()));
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.functionNameControl.setFocus();
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$1(IObservableList iObservableList, CheckStateChangedEvent event) {
            Object element = event.getElement();
            Object object = element;
            if (object instanceof FunctionToS4MethodRefactoring.Variable) {
                void variable;
                FunctionToS4MethodRefactoring.Variable variable2 = (FunctionToS4MethodRefactoring.Variable)object;
                FunctionToS4MethodRefactoring.Variable cfr_ignored_0 = (FunctionToS4MethodRefactoring.Variable)object;
                if (!variable.getName().equals("...")) {
                    boolean check = event.getChecked();
                    int idx = iObservableList.indexOf(element);
                    if (check) {
                        FunctionToS4MethodRefactoring.Variable previousVariable = null;
                        while (idx > 0) {
                            Object previousElement = iObservableList.get(idx - 1);
                            if (previousElement instanceof FunctionToS4MethodRefactoring.Variable && !((FunctionToS4MethodRefactoring.Variable)previousElement).getName().equals("...")) {
                                previousVariable = (FunctionToS4MethodRefactoring.Variable)previousElement;
                                break;
                            }
                            --idx;
                        }
                        if (previousVariable == null || previousVariable.getUseAsGenericArgument() == event.getChecked()) {
                            variable.setUseAsGenericArgument(event.getChecked());
                            this.argumentsViewer.setChecked((Object)variable, event.getChecked());
                            return;
                        }
                    } else {
                        FunctionToS4MethodRefactoring.Variable nextVariable = null;
                        while (idx < iObservableList.size() - 1) {
                            Object nextElement = iObservableList.get(idx + 1);
                            if (nextElement instanceof FunctionToS4MethodRefactoring.Variable && !((FunctionToS4MethodRefactoring.Variable)nextElement).getName().equals("...")) {
                                nextVariable = (FunctionToS4MethodRefactoring.Variable)nextElement;
                                break;
                            }
                            ++idx;
                        }
                        if (nextVariable == null || nextVariable.getUseAsGenericArgument() == event.getChecked()) {
                            variable.setUseAsGenericArgument(event.getChecked());
                            this.argumentsViewer.setChecked((Object)variable, event.getChecked());
                            return;
                        }
                    }
                    this.argumentsViewer.setChecked((Object)variable, !event.getChecked());
                } else {
                    this.argumentsViewer.setChecked((Object)variable, true);
                }
            }
        }

        private static class TypeEditing
        extends EditingSupport {
            private final TextCellEditor cellEditor;

            public TypeEditing(ColumnViewer viewer) {
                super(viewer);
                this.cellEditor = new TextCellEditor((Composite)viewer.getControl());
                this.cellEditor.getControl().setFont(JFaceResources.getTextFont());
            }

            protected boolean canEdit(Object element) {
                return element instanceof FunctionToS4MethodRefactoring.Variable;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof FunctionToS4MethodRefactoring.Variable) {
                    return this.cellEditor;
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            protected Object getValue(Object element) {
                Object object = element;
                if (object instanceof FunctionToS4MethodRefactoring.Variable) {
                    void variable;
                    FunctionToS4MethodRefactoring.Variable variable2 = (FunctionToS4MethodRefactoring.Variable)object;
                    FunctionToS4MethodRefactoring.Variable cfr_ignored_0 = (FunctionToS4MethodRefactoring.Variable)object;
                    String type = variable.getArgumentType();
                    return type != null ? type : "";
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            protected void setValue(Object element, Object value) {
                Object object = element;
                if (object instanceof FunctionToS4MethodRefactoring.Variable) {
                    void variable;
                    FunctionToS4MethodRefactoring.Variable variable2 = (FunctionToS4MethodRefactoring.Variable)object;
                    FunctionToS4MethodRefactoring.Variable cfr_ignored_0 = (FunctionToS4MethodRefactoring.Variable)object;
                    variable.setArgumentType((String)value);
                    this.getViewer().update(element, null);
                }
            }
        }
    }
}

