/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ide.ui.preferences;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.ecommons.preferences.ui.ScopedPreferenceStore;
import org.eclipse.statet.internal.ide.ui.StatetUIPlugin;

public final class CodeGenerationTemplatesStore {
    public static final String KEY = "org.eclipse.statet.base.ui.text.custom_code_templates";
    private final TemplateStore[] fInstanceStores;
    private final TemplateStore fProjectStore;
    private boolean fDisableProjectSettings;
    private final String fPreferenceQualifier;
    private final String fPreferenceKey;

    public static boolean hasProjectSpecificTempates(IProject project) {
        String pref = new ProjectScope(project).getNode("org.eclipse.statet.ide.ui").get(KEY, null);
        if (pref != null && pref.trim().length() > 0) {
            StringReader input = new StringReader(pref);
            TemplateReaderWriter reader = new TemplateReaderWriter();
            try {
                TemplatePersistenceData[] datas = reader.read((Reader)input);
                return datas.length > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public CodeGenerationTemplatesStore(IProject project, TemplateStore[] pluginStores) {
        this.fPreferenceQualifier = "org.eclipse.statet.ide.ui";
        this.fPreferenceKey = KEY;
        this.fInstanceStores = pluginStores;
        if (project == null) {
            this.fProjectStore = null;
        } else {
            final ScopedPreferenceStore projectSettings = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), this.fPreferenceQualifier);
            this.fProjectStore = new TemplateStore((IPreferenceStore)projectSettings, this.fPreferenceKey){

                public void add(TemplatePersistenceData data) {
                    this.internalAdd(data);
                }

                public void save() throws IOException {
                    if (CodeGenerationTemplatesStore.this.fDisableProjectSettings) {
                        projectSettings.setValue(CodeGenerationTemplatesStore.this.fPreferenceKey, null);
                    } else {
                        StringWriter output = new StringWriter();
                        TemplateReaderWriter writer = new TemplateReaderWriter();
                        writer.save(this.getTemplateData(false), (Writer)output);
                        projectSettings.setValue(CodeGenerationTemplatesStore.this.fPreferenceKey, output.toString());
                    }
                    if (projectSettings.needsSaving()) {
                        projectSettings.save();
                    }
                }
            };
        }
    }

    public TemplatePersistenceData[] getAllTemplateData() {
        if (this.fProjectStore != null) {
            return this.fProjectStore.getTemplateData(true);
        }
        int length = 0;
        TemplatePersistenceData[][] datas = new TemplatePersistenceData[this.fInstanceStores.length][];
        int i = 0;
        while (i < this.fInstanceStores.length) {
            datas[i] = this.fInstanceStores[i].getTemplateData(true);
            length += datas[i].length;
            ++i;
        }
        TemplatePersistenceData[] allData = new TemplatePersistenceData[length];
        int i2 = 0;
        int k = 0;
        while (i2 < datas.length) {
            System.arraycopy(datas[i2], 0, allData, k, datas[i2].length);
            k += datas[i2].length;
            ++i2;
        }
        return allData;
    }

    public TemplatePersistenceData[] getTemplateData(int categoryIndex) {
        if (this.fProjectStore != null) {
            TemplatePersistenceData[] data = this.fInstanceStores[categoryIndex].getTemplateData(true);
            TemplatePersistenceData[] allProjectData = this.fProjectStore.getTemplateData(true);
            int i = 0;
            while (i < data.length) {
                int j = 0;
                while (j < allProjectData.length) {
                    if (data[i].getId().equals(allProjectData[j].getId())) {
                        data[i] = allProjectData[j];
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return data;
        }
        return this.fInstanceStores[categoryIndex].getTemplateData(true);
    }

    public Template findTemplateById(String id) {
        Template template = null;
        if (this.fProjectStore != null) {
            template = this.fProjectStore.findTemplateById(id);
        }
        int i = 0;
        while (template == null && i < this.fInstanceStores.length) {
            template = this.fInstanceStores[i].findTemplateById(id);
            ++i;
        }
        return template;
    }

    public TemplatePersistenceData getTemplateData(String id) {
        TemplatePersistenceData data = null;
        if (this.fProjectStore != null) {
            data = this.fProjectStore.getTemplateData(id);
        }
        int i = 0;
        while (data == null && i < this.fInstanceStores.length) {
            data = this.fInstanceStores[i].getTemplateData(id);
            ++i;
        }
        return data;
    }

    public TemplatePersistenceData getTemplateData(int categoryIndex, String id) {
        TemplatePersistenceData data = null;
        if (this.fProjectStore != null) {
            data = this.fProjectStore.getTemplateData(id);
        }
        if (data == null) {
            data = this.fInstanceStores[categoryIndex].getTemplateData(id);
        }
        return data;
    }

    public void load() throws IOException {
        if (this.fProjectStore != null) {
            this.fProjectStore.load();
            HashSet<String> collectedDatas = new HashSet<String>();
            TemplatePersistenceData[] datas = this.fProjectStore.getTemplateData(false);
            int i = 0;
            while (i < datas.length) {
                collectedDatas.add(datas[i].getId());
                ++i;
            }
            i = 0;
            while (i < this.fInstanceStores.length) {
                datas = this.fInstanceStores[i].getTemplateData(false);
                int j = 0;
                while (j < datas.length) {
                    TemplatePersistenceData orig = datas[j];
                    if (!collectedDatas.contains(orig.getId())) {
                        TemplatePersistenceData copy = new TemplatePersistenceData(new Template(orig.getTemplate()), orig.isEnabled(), orig.getId());
                        this.fProjectStore.add(copy);
                        copy.setDeleted(true);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public boolean isProjectSpecific(String id) {
        if (id == null) {
            return false;
        }
        if (this.fProjectStore == null) {
            return false;
        }
        TemplatePersistenceData data = this.fProjectStore.getTemplateData(id);
        return data != null && !data.isDeleted();
    }

    public void setProjectSpecific(boolean projectSpecific) {
        assert (this.fProjectStore != null);
        this.fDisableProjectSettings = !projectSpecific;
    }

    public void setProjectSpecific(String id, boolean projectSpecific) {
        assert (this.fProjectStore != null);
        TemplatePersistenceData data = this.fProjectStore.getTemplateData(id);
        if (data != null) {
            data.setDeleted(!projectSpecific);
        }
    }

    public void restoreDefaults() {
        if (this.fProjectStore == null) {
            int i = 0;
            while (i < this.fInstanceStores.length) {
                this.fInstanceStores[i].restoreDefaults();
                ++i;
            }
        } else {
            try {
                this.load();
            }
            catch (IOException e) {
                StatetUIPlugin.logUnexpectedError(e);
            }
        }
    }

    public void save() throws IOException {
        if (this.fProjectStore == null) {
            int i = 0;
            while (i < this.fInstanceStores.length) {
                this.fInstanceStores[i].save();
                ++i;
            }
        } else {
            this.fProjectStore.save();
        }
    }

    public void revertChanges() throws IOException {
        if (this.fProjectStore == null) {
            int i = 0;
            while (i < this.fInstanceStores.length) {
                this.fInstanceStores[i].load();
                ++i;
            }
        }
    }
}

