/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.coordinate;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class LRange
implements Comparable<LRange> {
    public long start;
    public long end;

    public LRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public LRange(long value) {
        this.start = value;
        this.end = value + 1L;
    }

    public long size() {
        return this.end - this.start;
    }

    @Override
    public int compareTo(LRange other) {
        if (this.start < other.start) {
            return -1;
        }
        if (this.start > other.start) {
            return 1;
        }
        if (this.end < other.end) {
            return -1;
        }
        if (this.end > other.end) {
            return 1;
        }
        return 0;
    }

    public boolean contains(long position) {
        return position >= this.start && position < this.end;
    }

    public boolean overlap(LRange lRange) {
        return this.start < this.end && lRange.start < lRange.end && (this.contains(lRange.start) || this.contains(lRange.end - 1L) || lRange.contains(this.start) || lRange.contains(this.end - 1L));
    }

    public int hashCode() {
        int h = (int)(this.start ^ this.start >>> 32);
        h = Integer.rotateRight(h, 15);
        return (h ^= (int)(this.end ^ this.end >>> 32)) ^ h >>> 7;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LRange) {
            LRange other = (LRange)obj;
            return this.start == other.start && this.end == other.end;
        }
        return false;
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + ")L";
    }
}

