/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.core;

import java.net.URI;
import java.nio.file.Path;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.statet.jcommons.io.UriUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.input.SourceFragment;
import org.eclipse.statet.ltk.model.core.SourceUnitIdFactory;

@NonNullByDefault
public class DefaultSourceUnitIdFactory
implements SourceUnitIdFactory {
    public static final String WORKSPACE_PREFIX = "platform:/resource";

    public static final String createResourceId(IResource file) {
        IPath path = file.getFullPath();
        return WORKSPACE_PREFIX + path.toPortableString();
    }

    public static final String createResourceId(URI uri) {
        if ((uri = uri.normalize()).getScheme() == null) {
            return "xxx:" + uri.toString();
        }
        return uri.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public @Nullable String createId(Object from) {
        if (from instanceof IFile) {
            return DefaultSourceUnitIdFactory.createResourceId((IResource)((IFile)from));
        }
        if (from instanceof IFileStore) {
            return DefaultSourceUnitIdFactory.createResourceId(((IFileStore)from).toURI());
        }
        if (from instanceof Path) {
            return DefaultSourceUnitIdFactory.createResourceId(((Path)from).toUri());
        }
        if (from instanceof SourceFragment) {
            return ((SourceFragment)from).getId();
        }
        Object object = from;
        if (object instanceof String) {
            void s;
            String string = (String)object;
            String cfr_ignored_0 = (String)object;
            int sepIdx = s.indexOf(58);
            return sepIdx > 0 && UriUtils.isValidScheme((String)s, (int)0, (int)sepIdx) ? s : null;
        }
        return null;
    }
}

