/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.settings;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.ecommons.text.ui.settings.PreferenceStoreTextStyleManager;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.RGB;

@NonNullByDefault
public class CssTextStyleManager
extends PreferenceStoreTextStyleManager<String> {
    public static final String ROOT_STYLE_KEY = "ROOT";
    private final String defaultStyleKey;

    private static void appendCssColor(StringBuilder sb, RGB color) {
        sb.append('#');
        String s = Integer.toHexString(color.red);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
        s = Integer.toHexString(color.green);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
        s = Integer.toHexString(color.blue);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
    }

    public CssTextStyleManager(IPreferenceStore preferenceStore, String stylesGroupId, String defaultStyleKey) {
        super(preferenceStore, stylesGroupId);
        this.defaultStyleKey = defaultStyleKey;
    }

    public TextStyleManager.TextStyleToken<String> getRootStyleToken() {
        return this.getToken(ROOT_STYLE_KEY);
    }

    @Override
    protected @Nullable String createStyleData(String key) {
        if (key != ROOT_STYLE_KEY) {
            if ((key = this.resolveUsedKey(key)).equals(this.defaultStyleKey)) {
                return null;
            }
        } else {
            key = this.defaultStyleKey;
        }
        StringBuilder sb = new StringBuilder(32);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)(String.valueOf(key) + ".color"));
        sb.append("color: ");
        CssTextStyleManager.appendCssColor(sb, rgb);
        sb.append("; ");
        if (this.preferenceStore.getBoolean(String.valueOf(key) + ".bold")) {
            sb.append("font-weight: bold; ");
        }
        if (this.preferenceStore.getBoolean(String.valueOf(key) + ".italic")) {
            sb.append("font-style: italic; ");
        }
        boolean strikethrough = this.preferenceStore.getBoolean(String.valueOf(key) + ".strikethrough");
        boolean underline = this.preferenceStore.getBoolean(String.valueOf(key) + ".underline");
        if (strikethrough || underline) {
            sb.append("text-decoration:");
            if (strikethrough) {
                sb.append(" line-through");
            }
            if (underline) {
                sb.append(" underline");
            }
            sb.append("; ");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

