/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.internal.r.debug.core.model.BasicRVariable;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTargetImpl;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.internal.r.debug.core.model.RVariableProxy;
import org.eclipse.statet.internal.r.debug.core.model.RVectorValue;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.debug.core.RIndexedVariableItem;
import org.eclipse.statet.r.debug.core.RValue;
import org.eclipse.statet.r.debug.core.RVariable;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RStore;

@NonNullByDefault
public class RVectorIndexVariable
extends BasicRVariable
implements RIndexedVariableItem,
RValue {
    private final RVectorValue mainValue;
    private final long index;

    public RVectorIndexVariable(RVectorValue value, long index, RVariable parent) {
        super((RDebugTargetImpl)value.getDebugTarget(), parent);
        this.mainValue = value;
        this.index = index;
    }

    @Override
    public long[] getIndex() {
        return new long[]{this.index};
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.index + 1L);
        sb.append(']');
        String name = this.mainValue.getName(this.index);
        if (name != null) {
            sb.append(' ');
            sb.append(' ');
            sb.append(name);
        }
        return sb.toString();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.mainValue.hasValueChanged(this.index);
    }

    @Override
    public RValue getValue() throws DebugException {
        return this;
    }

    @Override
    public RVariable getAssignedVariable() {
        return this;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    @Override
    public String getReferenceTypeName() throws DebugException {
        CombinedRElement element = this.mainValue.element;
        return RDataUtils.getStoreAbbr((RStore)element.getData());
    }

    @Override
    public String getValueString() throws DebugException {
        String data = this.mainValue.getDataExpr(this.index);
        if (data == null) {
            throw this.newRequestLoadDataFailed();
        }
        return data;
    }

    @Override
    public boolean supportsValueModification() {
        return true;
    }

    @Override
    public boolean verifyValue(String expression) throws DebugException {
        return this.mainValue.validateDataExpr(expression);
    }

    @Override
    public void setValue(String expression) throws DebugException {
        this.mainValue.setDataExpr(this.index, expression);
    }

    @Override
    public String getDetailString() {
        String data = this.mainValue.getDataExpr(this.index);
        if (data == null) {
            return "<error>";
        }
        return data;
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public @NonNull IVariable[] getVariables() throws DebugException {
        return RElementVariableValue.NO_VARIABLES;
    }

    public int hashCode() {
        return this.mainValue.hashCode() + (int)(this.index ^ this.index >>> 32);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                void other;
                if (this == obj || this == (obj = RVariableProxy.unproxy(obj))) break block2;
                Object object = obj;
                if (!(object instanceof RVectorIndexVariable)) break block3;
                RVectorIndexVariable rVectorIndexVariable = (RVectorIndexVariable)object;
                RVectorIndexVariable cfr_ignored_0 = (RVectorIndexVariable)object;
                if (this.mainValue.equals(other.mainValue) && this.index == other.index) break block2;
            }
            return false;
        }
        return true;
    }
}

