/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.statet.ecommons.ui.components.SearchText;
import org.eclipse.statet.ecommons.ui.content.IElementFilter;
import org.eclipse.statet.ecommons.ui.content.SearchTextBinding;
import org.eclipse.statet.ecommons.ui.content.TableFilterController;
import org.eclipse.statet.ecommons.ui.content.TextElementFilter;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.r.ui.rhelp.Messages;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpLabelProvider;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PackageSelectionDialog
extends SelectionDialog {
    private final List<RPkgHelp> input;
    private SearchText filterText;
    private CheckboxTableViewer viewer;
    private TableFilterController filterController;
    private final List<RPkgHelp> selection;

    protected PackageSelectionDialog(Shell parentShell, List<RPkgHelp> packages, List<RPkgHelp> initialSelection) {
        super(parentShell);
        this.input = packages;
        this.selection = initialSelection;
        this.setTitle(Messages.PackageSelection_title);
        this.setMessage(Messages.PackageSelection_message);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.list_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newDialogGrid((int)1));
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.filterText = new SearchText(composite);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterText.setMessage("Filter");
        ViewerUtils.CheckboxTableComposite tableComposite = new ViewerUtils.CheckboxTableComposite(composite, 0x10010A00);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = LayoutUtils.hintHeight((Table)tableComposite.table, (int)10);
        data.widthHint = LayoutUtils.hintWidth((Table)tableComposite.table, (int)40);
        tableComposite.setLayoutData((Object)data);
        this.viewer = tableComposite.viewer;
        TableViewerColumn column = tableComposite.addColumn("Name", 16384, (ColumnLayoutData)new ColumnWeightData(1));
        column.setLabelProvider((CellLabelProvider)new RHelpLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableComposite.viewer);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            /*
             * WARNING - void declaration
             */
            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                Object object = element;
                if (object instanceof RPkgHelp) {
                    void pkg;
                    RPkgHelp rPkgHelp = (RPkgHelp)object;
                    RPkgHelp cfr_ignored_0 = (RPkgHelp)object;
                    if (!PackageSelectionDialog.this.selection.remove(pkg)) {
                        PackageSelectionDialog.this.selection.add((RPkgHelp)pkg);
                    }
                }
            }
        });
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return PackageSelectionDialog.this.selection.contains(element);
            }
        });
        this.filterController = new TableFilterController((TableViewer)this.viewer);
        TextElementFilter filter = new TextElementFilter();
        this.filterController.setFilter(0, (IElementFilter)filter);
        new SearchTextBinding(this.filterText, this.filterController, filter);
        this.filterController.setInput(this.input);
        ViewerUtils.installSearchTextNavigation((TableViewer)this.viewer, (SearchText)this.filterText, (boolean)true);
        Button clearAllControl = new Button(composite, 8);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Button)clearAllControl);
        clearAllControl.setLayoutData((Object)gd);
        clearAllControl.setText(Messages.PackageSelection_ClearAll_label);
        clearAllControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageSelectionDialog.this.selection.clear();
                PackageSelectionDialog.this.viewer.refresh();
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
        this.setSelectionResult(this.selection.toArray(new RPkgHelp[this.selection.size()]));
    }

    public RPkgHelp[] getResult() {
        return (RPkgHelp[])super.getResult();
    }
}

