/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r.ui.editors;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.statet.docmlet.tex.core.model.LtxSourceUnitModelInfo;
import org.eclipse.statet.docmlet.tex.ui.TexUIResources;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.ecommons.ui.workbench.BasicEditorOutlinePage;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.internal.redocs.tex.r.RedocsTexRPlugin;
import org.eclipse.statet.internal.redocs.tex.r.ui.editors.LtxRweaveRefactoringFactory;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.element.EmbeddingForeignSrcStrElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringFactory;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor2OutlinePage;
import org.eclipse.statet.ltk.ui.util.ViewerDragSupport;
import org.eclipse.statet.ltk.ui.util.ViewerDropSupport;
import org.eclipse.statet.redocs.r.ui.RedocsRUIResources;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class LtxRweaveOutlinePage
extends SourceEditor2OutlinePage {
    private static final String EXPAND_ELEMENTS_COMMAND_ID = "org.eclipse.statet.workbench.commands.ExpandElements";
    private static final Map<String, String> SECTION_PARAMETERS = Collections.singletonMap("type", "sections");
    private static final Map<String, String> CHAPTER_PARAMETERS = Collections.singletonMap("type", "chapters");
    private static final Map<String, String> SUBSECTION_PARAMETERS = Collections.singletonMap("type", "subsections");
    private static final Map<String, String> RCHUNK_PARAMETERS = Collections.singletonMap("type", "rchunks");
    private final ContentFilter contentFilter = new ContentFilter();

    private static boolean isRChunk(SourceStructElement<?, ?> element) {
        SourceStructElement foreignElement;
        return element instanceof EmbeddingForeignSrcStrElement && (foreignElement = ((EmbeddingForeignSrcStrElement)element).getForeignElement()) != null && foreignElement.getModelTypeId() == "R";
    }

    public LtxRweaveOutlinePage(SourceEditor1 editor) {
        super(editor, "LtxRweave", (CommonRefactoringFactory)LtxRweaveRefactoringFactory.getInstance(), "org.eclipse.statet.redocs.tex.menus.LtxOutlineViewContextMenu");
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((Plugin)RedocsTexRPlugin.getInstance(), (String)"SweaveOutlineView");
    }

    protected LtkModelElementFilter<? super SourceStructElement<?, ?>> getContentFilter() {
        return this.contentFilter;
    }

    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        ViewerDropSupport drop = new ViewerDropSupport((StructuredViewer)viewer, (IAdaptable)this, this.getRefactoringFactory());
        drop.init();
        ViewerDragSupport drag = new ViewerDragSupport((StructuredViewer)viewer);
        drag.init();
    }

    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        super.initActions(serviceLocator, handlers);
        handlers.add(".FilterRChunks", (IHandler2)new FilterRChunks());
        ExpandElementsHandler handler = new ExpandElementsHandler();
        handlers.add(EXPAND_ELEMENTS_COMMAND_ID, (IHandler2)handler);
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        RedocsRUIResources sweaveResources = RedocsRUIResources.INSTANCE;
        toolBarManager.appendToGroup("view.expand", (IContributionItem)new ExpandElementsContributionItem(serviceLocator, handlers));
        toolBarManager.appendToGroup("view.filter", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, sweaveResources.getImageDescriptor("org.eclipse.statet.redocs.r/image/loctool/filter-r_chunks"), null, null, "Hide R Chunks", "R", null, 32, null, false), (IHandler2)ObjectUtils.nonNullAssert((Object)handlers.get(".FilterRChunks"))));
    }

    protected void contextMenuAboutToShow(IMenuManager m) {
        IPageSite site = this.getSite();
        super.contextMenuAboutToShow(m);
        if (m.find("stat.submit") == null) {
            m.insertBefore("additions", (IContributionItem)new Separator("stat.submit"));
        }
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitSelectionToR", null, null, null, null, null, "R", null, 8, null, false)));
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitUptoSelectionToR", null, null, null, null, null, "U", null, 8, null, false)));
        m.add((IContributionItem)new Separator("more"));
    }

    protected @Nullable LtxSourceUnitModelInfo getCurrentInputModel() {
        TreeViewer viewer = this.getViewer();
        if (viewer == null) {
            return null;
        }
        return (LtxSourceUnitModelInfo)this.getModelInfo(viewer.getInput());
    }

    private class ContentFilter
    implements LtkModelElementFilter<SourceStructElement<?, ?>> {
        private boolean hideRChunks;

        private ContentFilter() {
        }

        public boolean include(SourceStructElement<?, ?> element) {
            switch (element.getElementType() & 0xF00) {
                case 2048: {
                    if (!LtxRweaveOutlinePage.isRChunk(element)) break;
                    return !this.hideRChunks;
                }
            }
            return true;
        }
    }

    public class ExpandElementsContributionItem
    extends HandlerContributionItem {
        private final IHandler2 expandElementsHandler;

        public ExpandElementsContributionItem(IServiceLocator serviceLocator, HandlerCollection handlers) {
            super(new CommandContributionItemParameter(serviceLocator, ".ExpandElements", "org.eclipse.ui.navigate.expandAll", null, null, null, null, "Expand All", "E", null, 4, null, false), (IHandler2)ObjectUtils.nonNullAssert((Object)handlers.get("org.eclipse.ui.navigate.expandAll")));
            this.expandElementsHandler = (IHandler2)ObjectUtils.nonNullAssert((Object)handlers.get(LtxRweaveOutlinePage.EXPAND_ELEMENTS_COMMAND_ID));
        }

        protected void initDropDownMenu(final MenuManager menuManager) {
            menuManager.addMenuListener((IMenuListener)new IMenuListener2(){

                public void menuAboutToShow(IMenuManager manager) {
                    TreeViewer viewer = LtxRweaveOutlinePage.this.getViewer();
                    if (viewer == null) {
                        return;
                    }
                    LtxSourceUnitModelInfo modelInfo = LtxRweaveOutlinePage.this.getCurrentInputModel();
                    if (modelInfo == null) {
                        return;
                    }
                    TexUIResources texResources = TexUIResources.INSTANCE;
                    RedocsRUIResources sweaveResources = RedocsRUIResources.INSTANCE;
                    if (modelInfo.getMinSectionLevel() > 0) {
                        if (modelInfo.getMinSectionLevel() < 2 && modelInfo.getMaxSectionLevel() >= 2) {
                            manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)LtxRweaveOutlinePage.this.getSite(), null, LtxRweaveOutlinePage.EXPAND_ELEMENTS_COMMAND_ID, CHAPTER_PARAMETERS, texResources.getImageDescriptor("org.eclipse.statet.docmlet.tex/image/obj/sectioning-chapter"), null, null, "Show all Chapters", "C", null, 8, null, false), ExpandElementsContributionItem.this.expandElementsHandler));
                        }
                        if (modelInfo.getMinSectionLevel() < 3 && modelInfo.getMaxSectionLevel() >= 3) {
                            manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)LtxRweaveOutlinePage.this.getSite(), null, LtxRweaveOutlinePage.EXPAND_ELEMENTS_COMMAND_ID, SECTION_PARAMETERS, texResources.getImageDescriptor("org.eclipse.statet.docmlet.tex/image/obj/sectioning-section"), null, null, "Show all Sections", "S", null, 8, null, false), ExpandElementsContributionItem.this.expandElementsHandler));
                        }
                        if (modelInfo.getMinSectionLevel() < 4 && modelInfo.getMaxSectionLevel() >= 4) {
                            manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)LtxRweaveOutlinePage.this.getSite(), null, LtxRweaveOutlinePage.EXPAND_ELEMENTS_COMMAND_ID, SUBSECTION_PARAMETERS, texResources.getImageDescriptor("org.eclipse.statet.docmlet.tex/image/obj/sectioning-subsection"), null, null, "Show all SubSections", "u", null, 8, null, false), ExpandElementsContributionItem.this.expandElementsHandler));
                            manager.add((IContributionItem)new Separator());
                        }
                    }
                    if (!((ExpandElementsContributionItem)ExpandElementsContributionItem.this).LtxRweaveOutlinePage.this.contentFilter.hideRChunks) {
                        manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)LtxRweaveOutlinePage.this.getSite(), null, LtxRweaveOutlinePage.EXPAND_ELEMENTS_COMMAND_ID, RCHUNK_PARAMETERS, sweaveResources.getImageDescriptor("org.eclipse.statet.redocs.r/image/obj/rchunk"), null, null, "Show all R Chunks", "R", null, 8, null, false), ExpandElementsContributionItem.this.expandElementsHandler));
                    }
                }

                public void menuAboutToHide(IMenuManager manager) {
                    ExpandElementsContributionItem.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            menuManager.dispose();
                        }
                    });
                }
            });
        }
    }

    public class ExpandElementsHandler
    extends AbstractHandler {
        public @Nullable Object execute(ExecutionEvent event) {
            Object expandFilter;
            String type = event.getParameter("type");
            if (type == null) {
                return null;
            }
            final TreeViewer viewer = LtxRweaveOutlinePage.this.getViewer();
            if (viewer == null || !UIAccess.isOkToUse((Control)viewer.getControl())) {
                return null;
            }
            SourceUnitModelInfo modelInfo = LtxRweaveOutlinePage.this.getModelInfo(viewer.getInput());
            if (modelInfo == null) {
                return null;
            }
            final LtkModelElementFilter<? super SourceStructElement<?, ?>> contentFilter = LtxRweaveOutlinePage.this.getContentFilter();
            if (type.equals("rchunks")) {
                expandFilter = new LtkModelElementFilter<SourceStructElement<?, ?>>(){

                    public boolean include(SourceStructElement<?, ?> element) {
                        if (contentFilter.include(element)) {
                            if ((element.getElementType() & 0xF00) == 2048 && LtxRweaveOutlinePage.isRChunk(element)) {
                                ViewerUtils.expandToLevel((AbstractTreeViewer)viewer, element, (int)0);
                                return false;
                            }
                            element.hasSourceChildren((LtkModelElementFilter)this);
                            return false;
                        }
                        return false;
                    }
                };
            } else {
                final int sectionLevel = type.equals("chapters") ? 2 : (type.equals("sections") ? 3 : (type.equals("subsections") ? 4 : (type.equals("subsubsections") ? 5 : 0)));
                if (sectionLevel < 1 || sectionLevel > 5) {
                    return null;
                }
                expandFilter = new LtkModelElementFilter<SourceStructElement<?, ?>>(){
                    private boolean childExpand;

                    public boolean include(SourceStructElement<?, ?> element) {
                        if (contentFilter.include(element) && (element.getElementType() & 0xFF0) == 1056) {
                            int currentLevel = element.getElementType() & 0xF;
                            if (currentLevel < 1 || currentLevel > sectionLevel) {
                                return false;
                            }
                            if (currentLevel < sectionLevel) {
                                this.childExpand = false;
                                element.hasSourceChildren((LtkModelElementFilter)this);
                                if (this.childExpand) {
                                    return false;
                                }
                            }
                            ViewerUtils.expandToLevel((AbstractTreeViewer)viewer, element, (int)0);
                            this.childExpand = true;
                            return false;
                        }
                        return false;
                    }
                };
            }
            modelInfo.getSourceElement().hasSourceChildren((LtkModelElementFilter)expandFilter);
            return null;
        }
    }

    private class FilterRChunks
    extends BasicEditorOutlinePage.AbstractToggleHandler {
        public FilterRChunks() {
            super((BasicEditorOutlinePage)LtxRweaveOutlinePage.this, "filter.r_chunks.enabled", false, null, 0);
        }

        protected void apply(boolean on) {
            LtxRweaveOutlinePage.this.contentFilter.hideRChunks = on;
            TreeViewer viewer = LtxRweaveOutlinePage.this.getViewer();
            if (viewer == null || !UIAccess.isOkToUse((Control)viewer.getControl())) {
                return;
            }
            viewer.refresh(false);
        }
    }
}

