/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.docmlet.tex.core.project.TexProjects;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.docmlet.tex.ui.TexUIMessages;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConvertToTexProjectHandler
extends AbstractHandler {
    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<IProject> projects;
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
        ISelection iSelection = selection;
        if (iSelection instanceof IStructuredSelection) {
            void structuredSelection;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            projects = new ArrayList<IProject>(structuredSelection.size());
            for (Object obj : structuredSelection) {
                IProject project;
                if (!(obj instanceof IAdaptable) || (project = (IProject)((IAdaptable)obj).getAdapter(IProject.class)) == null) continue;
                projects.add(project);
            }
        } else {
            return null;
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)TexUIMessages.TexProject_ConvertTask_label, (int)20);
                try {
                    SubMonitor m1 = m.newChild(20).setWorkRemaining(projects.size());
                    for (IProject project : projects) {
                        if (m.isCanceled()) {
                            throw new InterruptedException();
                        }
                        TexProjects.setupTexProject((IProject)project, (IProgressMonitor)m1.newChild(1));
                    }
                }
                finally {
                    m.done();
                }
            }
        };
        try {
            UIAccess.getActiveWorkbenchWindow((boolean)true).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.ui", TexUIMessages.TexProject_ConvertTask_error_message, e.getTargetException()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }
}

