/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.net.core.sshd;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.credentials.CredentialsStore;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.IdentityPasswordProvider;
import org.eclipse.statet.internal.ecommons.net.core.ESshSettings;
import org.eclipse.statet.internal.ecommons.net.core.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;

@NonNullByDefault
public class EIdentityPasswordProvider
extends IdentityPasswordProvider {
    private final ESshSettings sshSettings;
    private boolean useSecureStore;

    public EIdentityPasswordProvider(@Nullable CredentialsProvider credentialsProvider, ESshSettings settings) {
        super(credentialsProvider);
        this.sshSettings = settings;
    }

    private CredentialsStore getCredentialsStore() {
        return (CredentialsStore)ObjectUtils.nonNullAssert((Object)Activator.getDefault().getCredentialsStore());
    }

    protected char @Nullable [] getPassword(URIish uri, int attempt, IdentityPasswordProvider.State state) throws IOException {
        if (attempt == 0) {
            this.useSecureStore = this.sshSettings.getSaveCredentialsInSecureStore();
            if (this.useSecureStore) {
                try {
                    String password;
                    UserPasswordCredentials credentials = this.getCredentialsStore().getCredentials(uri);
                    if (credentials != null && (password = credentials.getPassword()) != null) {
                        char[] pass = password.toCharArray();
                        state.setPassword(pass);
                        return pass;
                    }
                }
                catch (StorageException e) {
                    if (e.getErrorCode() == 4) {
                        this.useSecureStore = false;
                        this.sshSettings.setSaveCredentialsInSecureStore(false);
                    } else {
                        this.logError((Exception)((Object)e));
                    }
                }
                catch (Exception e) {
                    this.logError(e);
                }
            }
        }
        return super.getPassword(uri, attempt, state);
    }

    protected char @Nullable [] getPassword(URIish uri, @Nullable String message) {
        CredentialsProvider credentialsProvider = this.getCredentialsProvider();
        if (credentialsProvider == null) {
            return null;
        }
        ArrayList<Object> items = new ArrayList<Object>(3);
        if (message != null && !message.isEmpty()) {
            items.add(new CredentialItem.InformationalMessage(message));
        }
        CredentialItem.Password passwordItem = new CredentialItem.Password(Messages.SshSession_IdentityKey_Password_prompt);
        items.add(passwordItem);
        CredentialItem.YesNoType storeValueItem = new CredentialItem.YesNoType(Messages.SshSession_IdentityKey_Password_SaveInStore_label);
        storeValueItem.setValue(this.useSecureStore);
        items.add(storeValueItem);
        try {
            char[] pass;
            boolean shouldStore;
            if (!credentialsProvider.get(uri, items)) {
                this.cancelAuthentication();
            }
            if (this.useSecureStore != (shouldStore = storeValueItem.getValue())) {
                this.useSecureStore = shouldStore;
                this.sshSettings.setSaveCredentialsInSecureStore(shouldStore);
            }
            char[] cArray = (pass = passwordItem.getValue()) != null ? (char[])pass.clone() : null;
            return cArray;
        }
        finally {
            passwordItem.clear();
        }
    }

    protected boolean keyLoaded(URIish uri, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IdentityPasswordProvider.State state, char @Nullable [] password, @Nullable Exception err) throws IOException, GeneralSecurityException {
        if (state != null && password != null) {
            if (state.getCount() == 0) {
                if (err != null) {
                    try {
                        this.getCredentialsStore().clearCredentials(uri);
                    }
                    catch (Exception e) {
                        this.logError(e);
                    }
                    return true;
                }
            } else if (err == null && this.useSecureStore) {
                UserPasswordCredentials credentials = new UserPasswordCredentials("egit:ssh:resource", new String(password));
                try {
                    this.getCredentialsStore().putCredentials(uri, credentials);
                }
                catch (StorageException e) {
                    if (e.getErrorCode() == 4) {
                        this.useSecureStore = false;
                        this.sshSettings.setSaveCredentialsInSecureStore(false);
                    } else {
                        this.logError((Exception)((Object)e));
                    }
                }
                catch (Exception e) {
                    this.logError(e);
                }
            }
        }
        return super.keyLoaded(uri, state, password, err);
    }

    protected void logError(Exception e) {
        CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.ecommons.net.core", "An error occurred when accessing the credentials store.", (Throwable)e));
    }
}

