/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors.r;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.RDoubleCommentAction;
import org.eclipse.statet.internal.r.ui.editors.RStripCommentsHandler;
import org.eclipse.statet.internal.r.ui.editors.r.REditorTemplatesPage;
import org.eclipse.statet.internal.r.ui.editors.r.ROutlinePage;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.ModelManager;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.input.SourceFragmentEditorInput;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractMarkOccurrencesProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1OutlinePage;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingProvider;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.source.ast.FDef;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.core.source.doc.RDocumentContentInfo;
import org.eclipse.statet.r.ui.RUIHelp;
import org.eclipse.statet.r.ui.editors.RCorrectIndentHandler;
import org.eclipse.statet.r.ui.editors.RDefaultFoldingProvider;
import org.eclipse.statet.r.ui.editors.REditorOptions;
import org.eclipse.statet.r.ui.editors.RMarkOccurrencesLocator;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.InsertAssignmentHandler;
import org.eclipse.statet.r.ui.sourceediting.RSourceViewerConfiguration;
import org.eclipse.statet.r.ui.sourceediting.RSourceViewerConfigurator;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.templates.ITemplatesPage;

@NonNullByDefault
public class REditor
extends SourceEditor1
implements RSourceEditor {
    private static final ImList<String> KEY_CONTEXTS = ImCollections.newIdentityList((Object)"org.eclipse.statet.r.contexts.REditor");
    private static final ImList<String> CONTEXT_IDS = ImCollections.concatList((Collection)ACTION_SET_CONTEXT_IDS, KEY_CONTEXTS);
    private RSourceViewerConfigurator config;
    private IContextProvider helpContextProvider;

    public REditor() {
        super(RCore.R_CONTENT_TYPE);
        this.config = (RSourceViewerConfigurator)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.config)));
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setHelpContextId("org.eclipse.statet.r.ui.r_editor");
        this.setEditorContextMenuId("org.eclipse.statet.r.menus.REditorContextMenu");
        this.setRulerContextMenuId("org.eclipse.statet.r.menus.REditorRulerMenu");
    }

    protected SourceEditorViewerConfigurator createConfiguration() {
        this.setDocumentProvider((IDocumentProvider)RUIPlugin.getInstance().getRDocumentProvider());
        this.enableStructuralFeatures((ModelManager)RModel.getRModelManager(), (Preference)REditorOptions.FOLDING_ENABLED_PREF, (Preference)REditorOptions.PREF_MARKOCCURRENCES_ENABLED);
        this.config = new RSourceViewerConfigurator(RCore.getWorkbenchAccess(), new RSourceViewerConfiguration((DocContentSections)RDocumentContentInfo.INSTANCE, 0, this, null, null, null));
        return this.config;
    }

    protected SourceEditorViewerConfigurator createInfoConfigurator() {
        return new RSourceViewerConfigurator(this.getRCoreAccess(), new RSourceViewerConfiguration(0, null));
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof SourceFragmentEditorInput) {
            this.setDocumentProvider((IDocumentProvider)RUIPlugin.getInstance().getRFragmentDocumentProvider());
            this.overwriteTitleImage(input.getImageDescriptor());
        } else {
            this.setDocumentProvider((IDocumentProvider)RUIPlugin.getInstance().getRDocumentProvider());
            this.overwriteTitleImage(null);
        }
    }

    protected Image getDefaultImage() {
        return RUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.r.ui/images/obj/r_script");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        SourceViewer viewer = (SourceViewer)this.getSourceViewer();
        this.helpContextProvider = RUIHelp.createEnrichedRHelpContextProvider((IWorkbenchPart3)this, "org.eclipse.statet.r.ui.r_editor");
        viewer.getTextWidget().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(REditor.this.helpContextProvider.getContext(null));
            }
        });
    }

    protected SourceEditorAddon createCodeFoldingProvider() {
        return new FoldingEditorAddon((FoldingProvider)new RDefaultFoldingProvider());
    }

    protected SourceEditorAddon createMarkOccurrencesProvider() {
        return new MarkOccurrencesProvider(this);
    }

    @Override
    public @Nullable RSourceUnit getSourceUnit() {
        return (RSourceUnit)super.getSourceUnit();
    }

    public RCoreAccess getRCoreAccess() {
        return this.config.getRCoreAccess();
    }

    protected void setupConfiguration(@Nullable IEditorInput newInput) {
        super.setupConfiguration(newInput);
        RSourceUnit su = this.getSourceUnit();
        this.config.setSource(RCore.getContextAccess((IAdaptable)su));
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if ("tabWidth".equals(event.getProperty()) || "spacesForTabs".equals(event.getProperty())) {
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return false;
    }

    protected Collection<String> getContextIds() {
        return CONTEXT_IDS;
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
        super.collectContextMenuPreferencePages(pageIds);
        pageIds.add("org.eclipse.statet.r.preferencePages.REditorOptions");
        pageIds.add("org.eclipse.statet.r.preferencePages.RTextStyles");
        pageIds.add("org.eclipse.statet.r.preferencePages.REditorTemplates");
        pageIds.add("org.eclipse.statet.r.preferencePages.RCodeStyle");
    }

    protected void createActions() {
        super.createActions();
        IHandlerService handlerService = (IHandlerService)ObjectUtils.nonNullAssert((Object)((IHandlerService)this.getServiceLocator().getService(IHandlerService.class)));
        Object handler = new InsertAssignmentHandler(this);
        handlerService.activateHandler("org.eclipse.statet.ltk.commands.InsertAssignment", (IHandler)handler);
        this.markAsStateDependentHandler((IHandler2)handler, true);
        RDoubleCommentAction action = new RDoubleCommentAction(this, this.getRCoreAccess());
        this.setAction(action.getId(), (IAction)action);
        this.markAsStateDependentAction(action.getId(), true);
        handler = new RStripCommentsHandler(this);
        handlerService.activateHandler("org.eclipse.statet.ltk.commands.StripComments", (IHandler)handler);
    }

    protected IHandler2 createCorrectIndentHandler() {
        RCorrectIndentHandler handler = new RCorrectIndentHandler(this);
        this.markAsStateDependentHandler((IHandler2)handler, true);
        return handler;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menuManager) {
        IWorkbenchPartSite site = this.getSite();
        RSourceUnit su = this.getSourceUnit();
        super.editorContextMenuAboutToShow(menuManager);
        menuManager.insertBefore("additions", (IContributionItem)new Separator("search"));
        menuManager.insertBefore("additions", (IContributionItem)new Separator("stat.submit"));
        IContributionItem additions = menuManager.find("additions");
        if (additions != null) {
            additions.setVisible(false);
        }
        menuManager.remove("ShiftRight");
        menuManager.remove("ShiftLeft");
        menuManager.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitSelectionToR", 8)));
        menuManager.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitUptoSelectionToR", 8)));
        if (su != null && !su.isReadOnly()) {
            menuManager.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitSelectionToR_PasteOutput", 8)));
        }
    }

    protected @Nullable IRegion getRangeToReveal(SourceUnitModelInfo modelInfo, SourceStructElement<?, ?> element) {
        FDef def = (FDef)element.getAdapter(FDef.class);
        if (def != null) {
            RAstNode cont = def.getContChild();
            int offset = element.getSourceRange().getStartOffset();
            int length = cont.getStartOffset() - offset;
            if (cont.getLength() > 0) {
                ++length;
            }
            return new Region(offset, length);
        }
        return null;
    }

    protected SourceEditor1OutlinePage createOutlinePage() {
        return new ROutlinePage(this);
    }

    protected ITemplatesPage createTemplatesPage() {
        return new REditorTemplatesPage(this);
    }

    public @NonNull String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", "org.eclipse.ui.views.ContentOutline", "org.eclipse.statet.r.views.RHelp"};
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == RCoreAccess.class) {
            return (T)this.getRCoreAccess();
        }
        if (adapterType == REnv.class) {
            return (T)this.getRCoreAccess().getREnv();
        }
        if (adapterType == IContextProvider.class) {
            return (T)this.helpContextProvider;
        }
        return (T)super.getAdapter(adapterType);
    }

    private static class MarkOccurrencesProvider
    extends AbstractMarkOccurrencesProvider {
        private final RMarkOccurrencesLocator locator = new RMarkOccurrencesLocator();

        public MarkOccurrencesProvider(SourceEditor1 editor) {
            super(editor, RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT);
        }

        protected void doUpdate(AbstractMarkOccurrencesProvider.RunData run, SourceUnitModelInfo info, AstSelection astSelection, @Nullable ITextSelection orgSelection) throws BadLocationException, BadPartitioningException, UnsupportedOperationException {
            this.locator.run(run, info, astSelection, orgSelection);
        }
    }
}

