/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.util.UIResources;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchLabelUtil;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpSearchUIMatch;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.r.ui.rhelp.RHelpUI;
import org.eclipse.statet.rhelp.core.RHelpKeyword;
import org.eclipse.statet.rhelp.core.RHelpKeywordGroup;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpSearchMatch;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;

public class RHelpLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String TITLE_SEP = " \u2013 ";
    public static final int WITH_TITLE = 1;
    public static final int WITH_QUALIFIER = 2;
    public static final int HEADER = 32;
    public static final int TOOLTIP = 16;
    private boolean tooltip;
    private final boolean withTitle;
    private boolean withQualifier;
    private Object focusObject;
    private final StyledString.Styler defaultStyler;
    private final SharedUIResources commonUIResources = SharedUIResources.INSTANCE;
    private final UIResources helpUIResources = RHelpUI.getUIResources();

    public static void append(StyledString string, RHelpSearchMatch.MatchFragment fragment) {
        String text = fragment.getText();
        int startIdx = 0;
        int endIdx = 0;
        while ((startIdx = text.indexOf("<SMATCH-", endIdx)) >= 0) {
            int m;
            if (startIdx > endIdx) {
                string.append(text.substring(endIdx, startIdx));
            }
            if ((endIdx = text.indexOf(RHelpSearchMatch.POST_TAGS[m = text.charAt(startIdx + 8) - 65], startIdx += 10)) < 0) {
                return;
            }
            string.append(text.substring(startIdx, endIdx), TextSearchLabelUtil.HIGHLIGHT_STYLE);
            endIdx += 11;
        }
        if (endIdx < text.length()) {
            string.append(text.substring(endIdx, text.length()));
        }
    }

    public RHelpLabelProvider() {
        this(1);
    }

    public RHelpLabelProvider(int style) {
        this.tooltip = (style & 0x10) != 0;
        this.withQualifier = (style & 2) != 0;
        this.withTitle = (style & 0x11) != 0;
        this.defaultStyler = (style & 0x20) != 0 ? ElementLabelProvider.TITLE_STYLER : null;
    }

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column);
        if (viewer instanceof TableViewer) {
            this.withQualifier = true;
        }
    }

    public void setFocusObject(Object object) {
        this.focusObject = object;
    }

    public Image getImage(Object element) {
        if (element instanceof RHelpSearchUIMatch) {
            element = ((RHelpSearchUIMatch)element).getRHelpMatch().getPage();
        }
        if (element instanceof RHelpPage) {
            if (((RHelpPage)element).isInternal()) {
                return this.helpUIResources.getImage("org.eclipse.statet.r.ui.rhelp/image/obj/Page.internal");
            }
            return this.helpUIResources.getImage("org.eclipse.statet.r.ui.rhelp/image/obj/Page");
        }
        if (element instanceof RPkgHelp) {
            return this.helpUIResources.getImage("org.eclipse.statet.r.ui/images/obj/r_package");
        }
        if (element instanceof REnvConfiguration || element instanceof REnv) {
            return RUI.getImage("org.eclipse.statet.r.ui/images/obj/r_environment");
        }
        if (element instanceof RHelpSearchMatch.MatchFragment) {
            return this.commonUIResources.getImage("org.eclipse.statet.ecommons.uimisc/images/obj/line_match");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getText(Object element) {
        if (element instanceof RHelpSearchUIMatch) {
            element = ((RHelpSearchUIMatch)element).getRHelpMatch().getPage();
        }
        if (element instanceof RHelpPage) {
            StringBuilder sb = new StringBuilder(32);
            RHelpPage page = (RHelpPage)element;
            sb.append(page.getName());
            if (this.tooltip) {
                sb.append(" {");
                sb.append(page.getPackage().getName());
                sb.append("}\n");
                sb.append(page.getTitle());
            } else if (this.withTitle && page.getTitle().length() > 0) {
                sb.append(TITLE_SEP);
                sb.append(page.getTitle());
            }
            return sb.toString();
        }
        if (element instanceof RPkgHelp) {
            StringBuilder sb = new StringBuilder(32);
            RPkgHelp packageHelp = (RPkgHelp)element;
            if (this.tooltip) {
                sb.append(packageHelp.getName());
                sb.append(" [");
                sb.append(packageHelp.getVersion());
                sb.append("]\n");
                sb.append(packageHelp.getTitle());
            } else {
                sb.append(packageHelp.getName());
                if (element == this.focusObject && packageHelp.getTitle().length() > 0) {
                    sb.append(TITLE_SEP);
                    sb.append(packageHelp.getTitle());
                }
            }
            return sb.toString();
        }
        Object object = element;
        if (object instanceof REnvConfiguration) {
            void rEnv;
            REnvConfiguration sb = (REnvConfiguration)object;
            REnvConfiguration cfr_ignored_0 = (REnvConfiguration)object;
            return rEnv.getName();
        }
        Object object2 = element;
        if (object2 instanceof REnv) {
            void rEnv;
            REnv rEnv2 = (REnv)object2;
            REnv cfr_ignored_1 = (REnv)object2;
            String name = rEnv.getName();
            return name != null ? name : "";
        }
        Object object3 = element;
        if (object3 instanceof RHelpKeywordGroup) {
            void group;
            RHelpKeywordGroup name = (RHelpKeywordGroup)object3;
            RHelpKeywordGroup cfr_ignored_2 = (RHelpKeywordGroup)object3;
            return String.valueOf(group.getLabel()) + TITLE_SEP + group.getDescription();
        }
        if (element instanceof RPkgHelp) {
            RHelpKeyword keyword = (RHelpKeyword)element;
            return String.valueOf(keyword.getKeyword()) + TITLE_SEP + keyword.getDescription();
        }
        Object object4 = element;
        if (object4 instanceof RHelpSearchMatch.MatchFragment) {
            void fragment;
            RHelpSearchMatch.MatchFragment keyword = (RHelpSearchMatch.MatchFragment)object4;
            RHelpSearchMatch.MatchFragment cfr_ignored_3 = (RHelpSearchMatch.MatchFragment)object4;
            return RHelpSearchMatch.ALL_TAGS_PATTERN.matcher(fragment.getText()).replaceAll("");
        }
        Object object5 = element;
        if (object5 instanceof Object[]) {
            void array;
            Object[] objectArray = (Object[])object5;
            Object[] cfr_ignored_4 = (Object[])object5;
            return array[((void)array).length - 1].toString();
        }
        return element.toString();
    }

    public boolean useNativeToolTip(Object object) {
        return true;
    }

    public String getToolTipText(Object element) {
        boolean wasTooltip = this.tooltip;
        try {
            this.tooltip = true;
            String string = this.getText(element);
            return string;
        }
        finally {
            this.tooltip = wasTooltip;
        }
    }

    /*
     * WARNING - void declaration
     */
    public StyledString getStyledText(Object element) {
        StyledString text = new StyledString();
        if (element instanceof RHelpSearchUIMatch) {
            RHelpSearchMatch match = ((RHelpSearchUIMatch)element).getRHelpMatch();
            RHelpPage page = match.getPage();
            text.append(page.getName(), this.defaultStyler);
            if (this.withTitle && page.getTitle().length() > 0) {
                text.append(TITLE_SEP, this.defaultStyler);
                text.append(page.getTitle(), this.defaultStyler);
            }
            if (this.withQualifier) {
                text.append(" - ", StyledString.QUALIFIER_STYLER);
                text.append(page.getPackage().getName(), StyledString.QUALIFIER_STYLER);
            } else if (match.getMatchCount() > 0) {
                text.append(" (", StyledString.COUNTER_STYLER);
                text.append(Integer.toString(match.getMatchCount()), StyledString.COUNTER_STYLER);
                text.append(")", StyledString.COUNTER_STYLER);
            }
        } else {
            Object object = element;
            if (object instanceof RHelpPage) {
                void page;
                RHelpPage match = (RHelpPage)object;
                RHelpPage cfr_ignored_0 = (RHelpPage)object;
                text.append(page.getName(), this.defaultStyler);
                if (this.withTitle && page.getTitle().length() > 0) {
                    text.append(TITLE_SEP, this.defaultStyler);
                    text.append(page.getTitle(), this.defaultStyler);
                }
                if (this.withQualifier) {
                    text.append(" - ", StyledString.QUALIFIER_STYLER);
                    text.append(page.getPackage().getName(), StyledString.QUALIFIER_STYLER);
                }
            } else {
                Object object2 = element;
                if (object2 instanceof RPkgHelp) {
                    void packageHelp;
                    RPkgHelp rPkgHelp = (RPkgHelp)object2;
                    RPkgHelp cfr_ignored_1 = (RPkgHelp)object2;
                    text.append(packageHelp.getName(), this.defaultStyler);
                    if (packageHelp == this.focusObject && packageHelp.getTitle().length() > 0) {
                        text.append(TITLE_SEP, this.defaultStyler);
                        text.append(packageHelp.getTitle(), this.defaultStyler);
                    }
                } else {
                    Object object3 = element;
                    if (object3 instanceof RHelpKeywordGroup) {
                        void group;
                        RHelpKeywordGroup rHelpKeywordGroup = (RHelpKeywordGroup)object3;
                        RHelpKeywordGroup cfr_ignored_2 = (RHelpKeywordGroup)object3;
                        text.append(group.getLabel());
                        text.append(" - " + group.getDescription(), StyledString.QUALIFIER_STYLER);
                    } else {
                        Object object4 = element;
                        if (object4 instanceof RHelpKeyword) {
                            void keyword;
                            RHelpKeyword rHelpKeyword = (RHelpKeyword)object4;
                            RHelpKeyword cfr_ignored_3 = (RHelpKeyword)object4;
                            text.append(keyword.getKeyword());
                            text.append(" - " + keyword.getDescription(), StyledString.QUALIFIER_STYLER);
                        } else {
                            Object object5 = element;
                            if (object5 instanceof REnvConfiguration) {
                                void rEnv;
                                REnvConfiguration rEnvConfiguration = (REnvConfiguration)object5;
                                REnvConfiguration cfr_ignored_4 = (REnvConfiguration)object5;
                                text.append(rEnv.getName());
                            } else {
                                Object object6 = element;
                                if (object6 instanceof REnv) {
                                    void rEnv;
                                    REnv rEnv2 = (REnv)object6;
                                    REnv cfr_ignored_5 = (REnv)object6;
                                    String name = rEnv.getName();
                                    text.append(name != null ? name : "", this.defaultStyler);
                                } else {
                                    Object object7 = element;
                                    if (object7 instanceof RHelpSearchMatch.MatchFragment) {
                                        void fragment;
                                        RHelpSearchMatch.MatchFragment name = (RHelpSearchMatch.MatchFragment)object7;
                                        RHelpSearchMatch.MatchFragment cfr_ignored_6 = (RHelpSearchMatch.MatchFragment)object7;
                                        String fieldLabel = fragment.getFieldLabel();
                                        if (fieldLabel != null) {
                                            text.append(fieldLabel, StyledString.QUALIFIER_STYLER);
                                            text.append(": ", StyledString.QUALIFIER_STYLER);
                                        }
                                        RHelpLabelProvider.append(text, (RHelpSearchMatch.MatchFragment)fragment);
                                    } else {
                                        Object object8 = element;
                                        if (object8 instanceof Object[]) {
                                            void array;
                                            Object[] fieldLabel = (Object[])object8;
                                            Object[] cfr_ignored_7 = (Object[])object8;
                                            text.append(array[((void)array).length - 1].toString());
                                        } else {
                                            text.append(element.toString());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return text;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        Image image = this.getImage(element);
        StyledString text = this.getStyledText(element);
        cell.setImage(image);
        cell.setText(text.getString());
        cell.setStyleRanges(text.getStyleRanges());
        super.update(cell);
    }

    protected StyleRange prepareStyleRange(StyleRange styleRange, boolean applyColors) {
        if (!applyColors && styleRange.background != null) {
            styleRange = super.prepareStyleRange(styleRange, applyColors);
            styleRange.borderStyle = 4;
            return styleRange;
        }
        return super.prepareStyleRange(styleRange, applyColors);
    }
}

