/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.stream.IntStream;
import org.eclipse.statet.internal.jcommons.collections.AbstractImIntList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ImIntSeqList
extends AbstractImIntList {
    private final int e0;
    private final int length;

    public ImIntSeqList(int e0, int length) {
        this.e0 = e0;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(int element) {
        int index = element - this.e0;
        return index >= 0 && index < this.length;
    }

    @Override
    public int getAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.e0 + index;
    }

    @Override
    public int indexOf(int element) {
        int index = element - this.e0;
        if (index >= 0 && index < this.length) {
            return index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int element) {
        int index = element - this.e0;
        if (index >= 0 && index < this.length) {
            return index;
        }
        return -1;
    }

    @Override
    public IntStream stream() {
        return IntStream.range(this.e0, this.e0 + this.length);
    }

    @Override
    public int[] toArray() {
        int[] dest = new int[this.length];
        int i = 0;
        while (i < this.length) {
            dest[i] = this.e0 + i;
            ++i;
        }
        return dest;
    }

    @Override
    public String getString() {
        return new String(this.toArray(), 0, this.length);
    }

    public int hashCode() {
        int hashCode = 9;
        int i = 0;
        while (i < this.length) {
            hashCode = 31 * hashCode + this.e0 + i;
            ++i;
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntList) {
            IntList other = (IntList)obj;
            if (this.length != other.size()) {
                return false;
            }
            int i = 0;
            while (i < this.length) {
                if (this.e0 + i != other.getAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.e0);
        int i = 1;
        while (i < this.length) {
            sb.append(", ");
            sb.append(this.e0 + i);
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }
}

