/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.dsl.core.source.ast.Alias;
import org.eclipse.statet.dsl.core.source.ast.Anchor;
import org.eclipse.statet.dsl.core.source.ast.Collection;
import org.eclipse.statet.dsl.core.source.ast.Directive;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.DslAstVisitor;
import org.eclipse.statet.dsl.core.source.ast.Dummy;
import org.eclipse.statet.dsl.core.source.ast.KeyValuePair;
import org.eclipse.statet.dsl.core.source.ast.Marker;
import org.eclipse.statet.dsl.core.source.ast.Scalar;
import org.eclipse.statet.dsl.core.source.ast.SeqEntry;
import org.eclipse.statet.dsl.core.source.ast.Tag;
import org.eclipse.statet.internal.yaml.core.model.ProblemMessages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.model.core.AttachmentsElement;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AbstractAstProblemReporter;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.core.source.StatusDetail;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.yaml.core.source.ast.YamlCollection;

@NonNullByDefault
public class AstProblemReporter
extends AbstractAstProblemReporter {
    private final Visitor visitor = new Visitor();

    public AstProblemReporter() {
        super("Yaml");
    }

    public void run(DslAstNode node, SourceContent content, IssueRequestor requestor) {
        try {
            try {
                this.init(content, requestor);
                node.acceptInDsl((DslAstVisitor)this.visitor);
                this.flush();
            }
            catch (InvocationTargetException | OperationCanceledException throwable) {
                this.clear();
            }
        }
        finally {
            this.clear();
        }
    }

    protected void handleCommonCodes(DslAstNode node, int code) throws BadLocationException, InvocationTargetException {
        switch (code & 0x700FF0) {
            case 4194784: {
                this.addProblem(2, code, this.getMessageBuilder().bind(ProblemMessages.Syntax_Gen_TokenUnknown_message, (Object)this.getMessageUtil().getShortQuoteText((AstNode)node, 0)), node.getStartOffset(), node.getEndOffset());
                return;
            }
            case 0x400200: {
                this.addProblem(2, code, this.getMessageBuilder().bind(ProblemMessages.Syntax_Gen_TokenUnexpected_message, (Object)this.getMessageUtil().getMidQuoteText((AstNode)node, 0)), node.getStartOffset(), node.getEndOffset());
                return;
            }
            case 4195104: {
                return;
            }
            case 4194608: {
                StatusDetail detail = StatusDetail.get((AttachmentsElement)node);
                if (detail == null) break;
                switch (code & 0x700FFF) {
                    case 4194609: {
                        this.addProblem(2, code, ProblemMessages.Syntax_Comment_SpaceBeforeMissing_message, detail.getStartOffset(), detail.getEndOffset());
                        return;
                    }
                    case 4194610: {
                        this.addProblem(2, code, ProblemMessages.Syntax_Gen_LineBreakMissing_message, detail.getStartOffset(), detail.getEndOffset());
                        return;
                    }
                }
                this.addProblem(2, code, this.getMessageBuilder().bind(ProblemMessages.Syntax_Gen_TokenUnexpected_message, (Object)this.getMessageUtil().getShortQuoteText((AstNode)node, 0)), node.getStartOffset(), node.getEndOffset());
                return;
            }
        }
        super.handleCommonCodes((AstNode)node, code);
    }

    private static int getMissingSepOffset(YamlCollection.FlowCollection node) {
        int idx = node.getSepOffsets().indexOf(Integer.MIN_VALUE);
        DslAstNode child = node.getChild(idx + 1);
        return child.getStartOffset();
    }

    private class Visitor
    extends DslAstVisitor {
        private Visitor() {
        }

        public void visit(Marker node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        public void visit(Directive node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FF0) {
                        case 0x400200: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_Doc_DirectiveUnexpected_message, (Object)AstProblemReporter.this.getMessageUtil().getShortQuoteText((AstNode)node, 0)), node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        public void visit(Tag node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x7FFFF0) {
                        case 4919568: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_Tag_VerbatimTag_NotClosed_message, (Object)AstProblemReporter.this.getMessageUtil().getShortQuoteText((AstNode)node, 0)), node.getEndOffset(), node.getEndOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        public void visit(Anchor node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        public void visit(Collection node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x7FFFF0) {
                        case 4424992: {
                            int offset = node.getStartOffset();
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_FlowSeq_NotClosed_message, offset, offset + 1);
                            break;
                        }
                        case 4429088: {
                            int offset = node.getStartOffset();
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_FlowMap_NotClosed_message, offset, offset + 1);
                            break;
                        }
                        case 4425072: {
                            int offset = AstProblemReporter.getMissingSepOffset((YamlCollection.FlowCollection)node);
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_FlowSeq_SeqEntrySeparatorMissing_message, offset, offset + 1);
                            break;
                        }
                        case 4429168: {
                            int offset = AstProblemReporter.getMissingSepOffset((YamlCollection.FlowCollection)node);
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_FlowMap_MapEntrySeparatorMissing_message, offset, offset + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInDslChildren((DslAstVisitor)this);
        }

        public void visit(SeqEntry node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x7FFFF0) {
                        case 0x440330: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_Seq_SeqEntryIndicatorMissing_message, node.getStartOffset(), node.getStartOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInDslChildren((DslAstVisitor)this);
        }

        public void visit(KeyValuePair node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x7FFFF0) {
                        case 0x444330: {
                            int offset = node.getStartOffset();
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_Map_MapKeyIndicatorMissing_messsage, offset, offset + 1);
                            break;
                        }
                        case 4477744: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_Map_MapValueIndicatorMissing_message, node.getKey().getEndOffset() - 1, node.getKey().getEndOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInDslChildren((DslAstVisitor)this);
        }

        public void visit(Scalar node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x7FFFFF) {
                        case 4751632: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_Scalar_QuotedScalar_NotClosed_message, (Object)AstProblemReporter.this.getMessageUtil().getShortQuoteText((AstNode)node, 1), (Object)String.valueOf(node.getOperator())), node.getEndOffset() - 1, node.getEndOffset() + 1);
                            break;
                        }
                        case 4194657: {
                            StatusDetail detail = StatusDetail.get((AttachmentsElement)node);
                            if (detail != null) {
                                AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_Scalar_BlockScalar_IndentIndicatorInvalid_message, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                                break;
                            }
                            AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                            break;
                        }
                        case 4194659: {
                            StatusDetail detail = StatusDetail.get((AttachmentsElement)node);
                            if (detail != null) {
                                AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_Scalar_BlockScalar_ChompingIndicatorMultiple_message, detail.getStartOffset(), detail.getEndOffset());
                                break;
                            }
                            AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                            break;
                        }
                        case 4751648: {
                            StatusDetail detail = StatusDetail.get((AttachmentsElement)node);
                            if (detail != null) {
                                AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Syntax_Scalar_QuotedScalar_EscapeSequenceInvalid_messsage, (Object)detail.getText()), detail.getStartOffset(), detail.getEndOffset());
                                break;
                            }
                            AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        public void visit(Dummy node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x7FFFF0) {
                        case 4330256: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_Doc_DirectiveEndMarkerMissing_message, node.getStartOffset(), AstProblemReporter.this.getMessageUtil().expandSpaceEnd(node.getEndOffset()));
                            break;
                        }
                        case 4334368: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_Doc_ContentMissing_message, node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        case 4457248: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_FlowSeq_SeqEntryMissing_message, node.getStartOffset(), AstProblemReporter.this.getMessageUtil().expandSpaceEnd(node.getEndOffset()));
                            break;
                        }
                        case 4465440: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_FlowMap_MapEntryMissing_message, node.getStartOffset(), AstProblemReporter.this.getMessageUtil().expandSpaceEnd(node.getEndOffset()));
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        public void visit(Alias node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes((DslAstNode)node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }
}

