/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.internal.r.core.rmodel.RModelIndex;
import org.eclipse.statet.internal.r.core.rmodel.RModelManagerImpl;

public class ResourceTracker
implements IResourceChangeListener {
    private final RModelManagerImpl modelManager;
    private final Map<IProject, RProjectNature> knownProjects = new HashMap<IProject, RProjectNature>();

    public ResourceTracker(RModelManagerImpl manager) {
        this.modelManager = manager;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 6);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IProject project, RProjectNature rProject) {
        Map<IProject, RProjectNature> map = this.knownProjects;
        synchronized (map) {
            this.knownProjects.put(project, rProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IProject project) {
        RModelIndex index;
        RProjectNature rProject;
        Map<IProject, RProjectNature> map = this.knownProjects;
        synchronized (map) {
            rProject = this.knownProjects.remove(project);
        }
        if (rProject != null && (index = this.modelManager.getIndex()) != null) {
            index.updateProjectConfigRemoved(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void resourceChanged(IResourceChangeEvent event) {
        IResource resource = event.getResource();
        IResource iResource = resource;
        if (iResource instanceof IProject) {
            RProjectNature rProject;
            void project;
            IProject iProject = (IProject)iResource;
            IProject cfr_ignored_0 = (IProject)iResource;
            if (project.isOpen()) {
                try {
                    RModelIndex index;
                    if (project.hasNature("org.eclipse.statet.r.resourceProjects.R") && (index = this.modelManager.getIndex()) != null) {
                        switch (event.getType()) {
                            case 2: {
                                index.updateProjectConfigClosed((IProject)project);
                                break;
                            }
                            case 4: {
                                index.updateProjectConfigRemoved((IProject)project);
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
                catch (CoreException index) {
                    // empty catch block
                }
            }
            Map<IProject, RProjectNature> map = this.knownProjects;
            synchronized (map) {
                rProject = this.knownProjects.remove(project);
            }
            if (rProject != null) {
                rProject.dispose();
            }
        }
    }
}

