/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.ResourceIssueSupport;
import org.eclipse.statet.r.core.BasicRResourceSourceUnit;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.core.model.build.RSourceUnitModelContainer;
import org.eclipse.statet.r.core.source.doc.RDocumentContentInfo;

@NonNullByDefault
public final class RResourceSourceUnit
extends BasicRResourceSourceUnit
implements RWorkspaceSourceUnit {
    private static final SourceUnitIssueSupport ISSUE_SUPPORT = new ResourceIssueSupport(RSourceUnitModelContainer.ISSUE_TYPE_SET);
    private final RSourceUnitModelContainer model = new RSourceUnitModelContainer(this, ISSUE_SUPPORT);

    public RResourceSourceUnit(String id, IFile file) {
        super(id, file);
    }

    public String getModelTypeId() {
        return "R";
    }

    public DocContentSections getDocumentContentInfo() {
        return RDocumentContentInfo.INSTANCE;
    }

    public int getElementType() {
        return 529;
    }

    protected void unregister() {
        super.unregister();
        this.model.clear();
    }

    public @Nullable AstInfo getAstInfo(@Nullable String type, boolean ensureSync, IProgressMonitor monitor) {
        AstInfo ast = this.model.getCurrentAst();
        long stamp = this.getResource().getModificationStamp();
        if (ast != null && ast.getStamp().getContentStamp() == stamp) {
            return ast;
        }
        return null;
    }

    public @Nullable SourceUnitModelInfo getModelInfo(@Nullable String type, int syncLevel, IProgressMonitor monitor) {
        if (type == null || type.equals("R")) {
            return this.model.getModelInfo(syncLevel, monitor);
        }
        return null;
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == RSourceUnitModelContainer.class) {
            return (T)((Object)this.model);
        }
        return super.getAdapter(adapterType);
    }
}

