/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.string.Chars;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.jcommons.util.StringUtils;
import org.eclipse.statet.ltk.core.source.StatusDetail;
import org.eclipse.statet.r.core.source.RTerminal;

@NonNullByDefault
public class RLexer {
    public static final int SKIP_WHITESPACE = 1;
    public static final int SKIP_LINEBREAK = 2;
    public static final int SKIP_COMMENT = 4;
    public static final int ENABLE_QUICK_CHECK = 16;
    public static final int ENABLE_NUM_VALUE = 32;
    public static final int ENABLE_COLON_EQUAL = 256;
    public static final int DEFAULT = 32768;
    private static final char[] C1_FALSE = "FALSE".substring(1).toCharArray();
    private static final char[] C1_NA_real_ = "NA_real_".substring(1).toCharArray();
    private static final char[] C1_NA_integer_ = "NA_integer_".substring(1).toCharArray();
    private static final char[] C1_NA_complex_ = "NA_complex_".substring(1).toCharArray();
    private static final char[] C1_NA_character_ = "NA_character_".substring(1).toCharArray();
    private static final char[] C1_break = "break".substring(1).toCharArray();
    private static final char[] C1_function = "function".substring(1).toCharArray();
    private static final char[] C1_repeat = "repeat".substring(1).toCharArray();
    private static final char[] C1_while = "while".substring(1).toCharArray();
    private TextParserInput input;
    private final int configFlags;
    private RTerminal foundType;
    private int foundFlags;
    private @Nullable StatusDetail foundDetail;
    private int foundOffset;
    private int foundNum;
    private int foundLength;
    private int textOffset;
    private @Nullable StringBuilder textBuilder;
    private boolean textBuilderText;
    private double numValue;

    private static final int checkConfig(int flags) {
        if ((flags & 0x8000) != 0) {
            flags |= 0x100;
        }
        return flags;
    }

    private static StatusDetail createDetail(TextParserInput in, int startOffset, int endOffset, @Nullable String text) {
        int beginIndex = in.getIndex(startOffset);
        return new StatusDetail(beginIndex, in.getIndex() + in.getLengthInSource(endOffset), text);
    }

    private static boolean isLessEqual(TextParserInput in, int startOffset, String than) {
        int i = 0;
        while (i < than.length()) {
            if (in.get(startOffset + i) > than.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public RLexer(TextParserInput input) {
        this(32768);
        this.reset(input);
    }

    public RLexer(int configFlags) {
        this.configFlags = RLexer.checkConfig(configFlags);
    }

    public RLexer() {
        this(32768);
    }

    public void reset() {
        this.foundType = null;
        this.foundFlags = 0;
        this.foundDetail = null;
        this.foundOffset = this.input.getIndex();
        this.foundNum = 0;
        this.foundLength = 0;
        this.textBuilderText = false;
    }

    public void reset(TextParserInput input) {
        this.input = input;
        this.reset();
    }

    public final TextParserInput getInput() {
        return this.input;
    }

    public RTerminal next() {
        this.foundType = null;
        while (this.foundType == null) {
            this.input.consume(this.foundNum);
            this.foundOffset = this.input.getIndex();
            this.searchNext();
        }
        return this.foundType;
    }

    public final RTerminal getType() {
        return this.foundType;
    }

    public final int getOffset() {
        return this.foundOffset;
    }

    public final int getLength() {
        return this.foundLength;
    }

    public final int getEndOffset() {
        return this.foundOffset + this.foundLength;
    }

    public final @Nullable String getText() {
        switch (this.foundType) {
            case EOF: {
                return null;
            }
            case SPECIAL: {
                if ((this.foundFlags & 0x700FF0) == 4194592) {
                    return this.input.getString(1, this.foundNum);
                }
                return this.input.getString(1, this.foundNum - 1);
            }
            case SYMBOL_G: 
            case STRING_D: 
            case STRING_S: {
                if (this.textBuilderText) {
                    return this.textBuilder.toString();
                }
                if ((this.foundFlags & 0x700FF0) == 4194592) {
                    return this.input.getString(1, this.foundNum);
                }
                return this.input.getString(1, this.foundNum - 1);
            }
            case STRING_R: {
                switch (this.foundFlags & 0x700FF0) {
                    case 0x400110: {
                        return null;
                    }
                    case 4194592: {
                        return this.input.getString(this.textOffset, this.foundNum);
                    }
                }
                return this.input.getString(this.textOffset, this.foundNum - this.textOffset + 1);
            }
            case UNKNOWN: 
            case SYMBOL: 
            case NUM_INT: 
            case NUM_NUM: 
            case NUM_CPLX: {
                return this.input.getString(0, this.foundNum);
            }
        }
        return this.foundType.text;
    }

    public final @Nullable String getText(StringFactory textFactory) {
        switch (this.foundType) {
            case EOF: {
                return null;
            }
            case SPECIAL: {
                if ((this.foundFlags & 0x700FF0) == 4194592) {
                    return this.input.getString(1, this.foundNum, textFactory);
                }
                return this.input.getString(1, this.foundNum - 1, textFactory);
            }
            case SYMBOL_G: 
            case STRING_D: 
            case STRING_S: {
                if (this.textBuilderText) {
                    return textFactory.get((CharSequence)this.textBuilder);
                }
                if ((this.foundFlags & 0x700FF0) == 4194592) {
                    return this.input.getString(1, this.foundNum, textFactory);
                }
                return this.input.getString(1, this.foundNum - 1, textFactory);
            }
            case STRING_R: {
                switch (this.foundFlags & 0x700FF0) {
                    case 0x400110: {
                        return null;
                    }
                    case 4194592: {
                        return this.input.getString(this.textOffset, this.foundNum, textFactory);
                    }
                }
                return this.input.getString(this.textOffset, this.foundNum - this.textOffset + 1, textFactory);
            }
            case UNKNOWN: 
            case SYMBOL: 
            case NUM_INT: 
            case NUM_NUM: 
            case NUM_CPLX: {
                return this.input.getString(0, this.foundNum, textFactory);
            }
        }
        return this.foundType.text;
    }

    public final @Nullable TextRegion getTextRegion() {
        switch (this.foundType) {
            case SPECIAL: 
            case SYMBOL_G: 
            case STRING_D: 
            case STRING_S: {
                if ((this.foundFlags & 0x700FF0) == 4194592) {
                    return this.input.getRegionInSource(1, this.foundNum);
                }
                return this.input.getRegionInSource(1, this.foundNum - 1);
            }
            case STRING_R: {
                switch (this.foundFlags & 0x700FF0) {
                    case 0x400110: {
                        return null;
                    }
                    case 4194592: {
                        return this.input.getRegionInSource(this.textOffset, this.foundNum);
                    }
                }
                return this.input.getRegionInSource(this.textOffset, this.foundNum - this.textOffset + 1);
            }
        }
        return null;
    }

    public final int getFlags() {
        return this.foundFlags;
    }

    public final @Nullable StatusDetail getStatusDetail() {
        return this.foundDetail;
    }

    private void foundEOF(TextParserInput in) {
        this.foundType = RTerminal.EOF;
        this.foundFlags = 0;
        this.foundDetail = null;
        this.foundNum = 0;
        this.foundLength = in.getLengthInSource(0);
    }

    private void foundLinebreak(TextParserInput in, int n) {
        if ((this.configFlags & 2) == 0) {
            this.foundType = RTerminal.LINEBREAK;
            this.foundFlags = 0;
            this.foundDetail = null;
        }
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
        this.handleNewLine(this.foundOffset + this.foundLength);
    }

    private void foundWhitespace(TextParserInput in, int n) {
        if ((this.configFlags & 1) == 0) {
            this.foundType = RTerminal.BLANK;
            this.foundFlags = 0;
            this.foundDetail = null;
        }
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
    }

    private void foundComment(TextParserInput in, RTerminal type, int n) {
        if ((this.configFlags & 4) == 0) {
            this.foundType = type;
            this.foundFlags = 0;
            this.foundDetail = null;
        }
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
    }

    private void found1(TextParserInput in, RTerminal type) {
        this.foundType = type;
        this.foundFlags = 0;
        this.foundDetail = null;
        this.foundNum = 1;
        this.foundLength = in.getLengthInSource(1);
    }

    private void found2(TextParserInput in, RTerminal type) {
        this.foundType = type;
        this.foundFlags = 0;
        this.foundDetail = null;
        this.foundNum = 2;
        this.foundLength = in.getLengthInSource(2);
    }

    private void found3(TextParserInput in, RTerminal type) {
        this.foundType = type;
        this.foundFlags = 0;
        this.foundDetail = null;
        this.foundNum = 3;
        this.foundLength = in.getLengthInSource(3);
    }

    private void found(TextParserInput in, RTerminal type, int n) {
        this.foundType = type;
        this.foundFlags = 0;
        this.foundDetail = null;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
    }

    private void found(TextParserInput in, RTerminal type, int flags, int n) {
        this.foundType = type;
        this.foundFlags = flags;
        this.foundDetail = null;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
    }

    private void found(TextParserInput in, RTerminal type, int flags, @Nullable StatusDetail detail, int n) {
        this.foundType = type;
        this.foundFlags = flags;
        this.foundDetail = detail;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
    }

    private void searchNext() {
        TextParserInput in = this.input;
        int c0 = in.get(0);
        switch (c0) {
            case -1: {
                this.foundEOF(in);
                return;
            }
            case 13: {
                if (in.get(1) == 10) {
                    this.foundLinebreak(in, 2);
                    return;
                }
                this.foundLinebreak(in, 1);
                return;
            }
            case 10: {
                this.foundLinebreak(in, 1);
                return;
            }
            case 9: 
            case 32: {
                int n = 1;
                block124: while (true) {
                    switch (in.get(n++)) {
                        case 9: 
                        case 32: {
                            continue block124;
                        }
                    }
                    break;
                }
                this.foundWhitespace(in, n - 1);
                return;
            }
            case 35: {
                if (in.get(1) == 39) {
                    int n = 2;
                    while (true) {
                        switch (in.get(n++)) {
                            case -1: 
                            case 10: 
                            case 13: {
                                this.foundComment(in, RTerminal.ROXYGEN_COMMENT, n - 1);
                                return;
                            }
                        }
                    }
                }
                int n = 1;
                while (true) {
                    switch (in.get(n++)) {
                        case -1: 
                        case 10: 
                        case 13: {
                            this.foundComment(in, RTerminal.COMMENT, n - 1);
                            return;
                        }
                    }
                }
            }
            case 123: {
                this.found1(in, RTerminal.BLOCK_OPEN);
                return;
            }
            case 125: {
                this.found1(in, RTerminal.BLOCK_CLOSE);
                return;
            }
            case 40: {
                this.found1(in, RTerminal.GROUP_OPEN);
                return;
            }
            case 41: {
                this.found1(in, RTerminal.GROUP_CLOSE);
                return;
            }
            case 91: {
                if (in.get(1) == 91) {
                    this.found2(in, RTerminal.SUB_INDEXED_D_OPEN);
                    return;
                }
                this.found1(in, RTerminal.SUB_INDEXED_S_OPEN);
                return;
            }
            case 93: {
                this.found1(in, RTerminal.SUB_INDEXED_CLOSE);
                return;
            }
            case 44: {
                this.found1(in, RTerminal.COMMA);
                return;
            }
            case 59: {
                this.found1(in, RTerminal.SEMICOLON);
                return;
            }
            case 36: {
                this.found1(in, RTerminal.SUB_NAMED_PART);
                return;
            }
            case 64: {
                this.found1(in, RTerminal.SUB_NAMED_SLOT);
                return;
            }
            case 58: {
                switch (in.get(1)) {
                    case 58: {
                        if (in.get(2) == 58) {
                            this.found3(in, RTerminal.NS_GET_INT);
                            return;
                        }
                        this.found2(in, RTerminal.NS_GET);
                        return;
                    }
                    case 61: {
                        if ((this.configFlags & 0x100) != 0) {
                            this.found2(in, RTerminal.COLON_EQUAL);
                            return;
                        }
                        this.found1(in, RTerminal.SEQ);
                        return;
                    }
                }
                this.found1(in, RTerminal.SEQ);
                return;
            }
            case 61: {
                if (in.get(1) == 61) {
                    this.found2(in, RTerminal.REL_EQ);
                    return;
                }
                this.found1(in, RTerminal.EQUAL);
                return;
            }
            case 60: {
                switch (in.get(1)) {
                    case 61: {
                        this.found2(in, RTerminal.REL_LE);
                        return;
                    }
                    case 45: {
                        this.found2(in, RTerminal.ARROW_LEFT_S);
                        return;
                    }
                    case 60: {
                        if (in.get(2) != 45) break;
                        this.found3(in, RTerminal.ARROW_LEFT_D);
                        return;
                    }
                }
                this.found1(in, RTerminal.REL_LT);
                return;
            }
            case 62: {
                if (in.get(1) == 61) {
                    this.found2(in, RTerminal.REL_GE);
                    return;
                }
                this.found1(in, RTerminal.REL_GT);
                return;
            }
            case 33: {
                if (in.get(1) == 61) {
                    this.found2(in, RTerminal.REL_NE);
                    return;
                }
                this.found1(in, RTerminal.NOT);
                return;
            }
            case 38: {
                if (in.get(1) == 38) {
                    this.found2(in, RTerminal.AND_D);
                    return;
                }
                this.found1(in, RTerminal.AND);
                return;
            }
            case 124: {
                switch (in.get(1)) {
                    case 124: {
                        this.found2(in, RTerminal.OR_D);
                        return;
                    }
                    case 62: {
                        this.found2(in, RTerminal.PIPE_RIGHT);
                        return;
                    }
                }
                this.found1(in, RTerminal.OR);
                return;
            }
            case 43: {
                this.found1(in, RTerminal.PLUS);
                return;
            }
            case 45: {
                if (in.get(1) == 62) {
                    if (in.get(2) == 62) {
                        this.found3(in, RTerminal.ARROW_RIGHT_D);
                        return;
                    }
                    this.found2(in, RTerminal.ARROW_RIGHT_S);
                    return;
                }
                this.found1(in, RTerminal.MINUS);
                return;
            }
            case 42: {
                this.found1(in, RTerminal.MULT);
                return;
            }
            case 47: {
                this.found1(in, RTerminal.DIV);
                return;
            }
            case 94: {
                this.found1(in, RTerminal.POWER);
                return;
            }
            case 126: {
                this.found1(in, RTerminal.TILDE);
                return;
            }
            case 37: {
                int n = 1;
                while (true) {
                    switch (in.get(n++)) {
                        case -1: 
                        case 10: 
                        case 13: {
                            this.found(in, RTerminal.SPECIAL, 4194592, n - 1);
                            return;
                        }
                        case 37: {
                            this.found(in, RTerminal.SPECIAL, n);
                            return;
                        }
                    }
                }
            }
            case 92: {
                this.found(in, RTerminal.FUNCTION_B, 1);
                return;
            }
            case 63: {
                this.found1(in, RTerminal.QUESTIONMARK);
                return;
            }
            case 48: {
                if (in.get(1) == 120) {
                    this.readNumberHex(in);
                    return;
                }
                this.readNumberDec(in);
                return;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.readNumberDec(in);
                return;
            }
            case 46: {
                switch (in.get(1)) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.readNumberDecPoint(in, 2);
                        return;
                    }
                }
                int n = this.nIdentifier(in, 1);
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 95: {
                int n = this.nIdentifier(in, 1);
                if (n == 1) {
                    this.found(in, RTerminal.PIPE_PLACEHOLDER, 1);
                    return;
                }
                this.found(in, RTerminal.SYMBOL, 0x400141, RLexer.createDetail(in, 0, 1, "_"), n);
                return;
            }
            case 34: {
                if ((this.configFlags & 0x10) != 0) {
                    int n = 1;
                    block128: while (true) {
                        switch (in.get(n++)) {
                            case -1: {
                                this.found(in, RTerminal.STRING_D, 4194592, n - 1);
                                return;
                            }
                            case 92: {
                                if (in.get(n++) != -1) continue block128;
                                this.found(in, RTerminal.STRING_D, 4194592, n - 1);
                                return;
                            }
                            case 34: {
                                this.found(in, RTerminal.STRING_D, n);
                                return;
                            }
                            case 13: {
                                if (in.get(n++) != 10) {
                                    --n;
                                }
                                this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                                continue block128;
                            }
                            case 10: {
                                this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                                continue block128;
                            }
                        }
                    }
                }
                this.readQuoted(in, RTerminal.STRING_D, '\"');
                return;
            }
            case 39: {
                if ((this.configFlags & 0x10) != 0) {
                    int n = 1;
                    block129: while (true) {
                        switch (in.get(n++)) {
                            case -1: {
                                this.found(in, RTerminal.STRING_S, 4194592, n - 1);
                                return;
                            }
                            case 92: {
                                if (in.get(n++) != -1) continue block129;
                                this.found(in, RTerminal.STRING_S, 4194592, n - 1);
                                return;
                            }
                            case 39: {
                                this.found(in, RTerminal.STRING_S, n);
                                return;
                            }
                            case 13: {
                                if (in.get(n++) != 10) {
                                    --n;
                                }
                                this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                                continue block129;
                            }
                            case 10: {
                                this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                                continue block129;
                            }
                        }
                    }
                }
                this.readQuoted(in, RTerminal.STRING_S, '\'');
                return;
            }
            case 96: {
                if ((this.configFlags & 0x10) != 0) {
                    int n = 1;
                    block130: while (true) {
                        switch (in.get(n++)) {
                            case -1: {
                                this.found(in, RTerminal.SYMBOL_G, 4194592, n - 1);
                                return;
                            }
                            case 92: {
                                if (in.get(n++) != -1) continue block130;
                                this.found(in, RTerminal.SYMBOL_G, 4194592, n - 1);
                                return;
                            }
                            case 96: {
                                this.found(in, RTerminal.SYMBOL_G, n);
                                return;
                            }
                            case 13: {
                                if (in.get(n++) != 10) {
                                    --n;
                                }
                                this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                                continue block130;
                            }
                            case 10: {
                                this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                                continue block130;
                            }
                        }
                    }
                }
                this.readQuoted(in, RTerminal.SYMBOL_G, '`');
                return;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 97: 
            case 99: 
            case 100: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 122: {
                int n = this.nIdentifier(in, 1);
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 70: {
                int n = this.nIdentifier(in, 1);
                if (n == 5 && in.matches(1, C1_FALSE)) {
                    this.found(in, RTerminal.FALSE, 5);
                    return;
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 73: {
                int n = this.nIdentifier(in, 1);
                if (n == 3 && in.matches(1, 'n', 'f')) {
                    this.numValue = Double.POSITIVE_INFINITY;
                    this.found(in, RTerminal.INF, 3);
                    return;
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 78: {
                int n = this.nIdentifier(in, 1);
                switch (n) {
                    case 2: {
                        if (in.get(1) != 65) break;
                        this.found(in, RTerminal.NA, 2);
                        return;
                    }
                    case 3: {
                        if (!in.matches(1, 'a', 'N')) break;
                        this.found(in, RTerminal.NAN, 3);
                        return;
                    }
                    case 4: {
                        if (!in.matches(1, 'U', 'L', 'L')) break;
                        this.found(in, RTerminal.NULL, 4);
                        return;
                    }
                    case 8: {
                        if (!in.matches(1, C1_NA_real_)) break;
                        this.found(in, RTerminal.NA_REAL, 8);
                        return;
                    }
                    case 11: {
                        if (in.matches(1, C1_NA_integer_)) {
                            this.found(in, RTerminal.NA_INT, 11);
                            return;
                        }
                        if (!in.matches(1, C1_NA_complex_)) break;
                        this.found(in, RTerminal.NA_CPLX, 11);
                        return;
                    }
                    case 13: {
                        if (!in.matches(1, C1_NA_character_)) break;
                        this.found(in, RTerminal.NA_CHAR, 13);
                        return;
                    }
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 82: {
                int n = this.nIdentifier(in, 1);
                if (n == 1) {
                    if (in.matches(1, '\"')) {
                        this.readStringR(in, '\"');
                        return;
                    }
                    if (in.matches(1, '\'')) {
                        this.readStringR(in, '\'');
                        return;
                    }
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 84: {
                int n = this.nIdentifier(in, 1);
                if (n == 4 && in.matches(1, 'R', 'U', 'E')) {
                    this.found(in, RTerminal.TRUE, 4);
                    return;
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 98: {
                int n = this.nIdentifier(in, 1);
                if (n == 5 && in.matches(1, C1_break)) {
                    this.found(in, RTerminal.BREAK, 5);
                    return;
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 105: {
                int n = this.nIdentifier(in, 1);
                if (n == 2) {
                    switch (in.get(1)) {
                        case 102: {
                            this.found(in, RTerminal.IF, 2);
                            return;
                        }
                        case 110: {
                            this.found(in, RTerminal.IN, 2);
                            return;
                        }
                    }
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 101: {
                int n = this.nIdentifier(in, 1);
                if (n == 4 && in.matches(1, 'l', 's', 'e')) {
                    this.found(in, RTerminal.ELSE, 4);
                    return;
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 102: {
                int n = this.nIdentifier(in, 1);
                switch (n) {
                    case 3: {
                        if (!in.matches(1, 'o', 'r')) break;
                        this.found(in, RTerminal.FOR, 3);
                        return;
                    }
                    case 8: {
                        if (!in.matches(1, C1_function)) break;
                        this.found(in, RTerminal.FUNCTION, 8);
                        return;
                    }
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 110: {
                int n = this.nIdentifier(in, 1);
                if (n == 4 && in.matches(1, 'e', 'x', 't')) {
                    this.found(in, RTerminal.NEXT, 4);
                    return;
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 114: {
                int n = this.nIdentifier(in, 1);
                switch (n) {
                    case 1: {
                        if (in.matches(1, '\"')) {
                            this.readStringR(in, '\"');
                            return;
                        }
                        if (!in.matches(1, '\'')) break;
                        this.readStringR(in, '\'');
                        return;
                    }
                    case 6: {
                        if (!in.matches(1, C1_repeat)) break;
                        this.found(in, RTerminal.REPEAT, 6);
                        return;
                    }
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 119: {
                int n = this.nIdentifier(in, 1);
                if (n == 5 && in.matches(1, C1_while)) {
                    this.found(in, RTerminal.WHILE, 5);
                    return;
                }
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                break;
            }
            default: {
                if (!Character.isLetterOrDigit(c0)) break;
                int n = this.nIdentifier(in, 1);
                this.found(in, RTerminal.SYMBOL, n);
                return;
            }
        }
        this.found1(in, RTerminal.UNKNOWN);
    }

    private StringBuilder getTextBuilder() {
        StringBuilder textBuilder = this.textBuilder;
        if (textBuilder == null) {
            this.textBuilder = textBuilder = new StringBuilder(64);
        } else {
            textBuilder.setLength(0);
        }
        return textBuilder;
    }

    private void readNumberHex(TextParserInput in) {
        int n = 2;
        switch (in.get(n++)) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                break;
            }
            case 46: {
                switch (in.get(n++)) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: {
                        this.readNumberHexPoint(in, n);
                        return;
                    }
                    case 80: 
                    case 112: {
                        this.readNumberExp(in, n);
                        return;
                    }
                    case 76: {
                        this.found(in, RTerminal.NUM_INT, 4194645, n);
                        return;
                    }
                    case 105: {
                        this.found(in, RTerminal.NUM_CPLX, 4194645, n);
                        return;
                    }
                }
                this.found(in, RTerminal.NUM_NUM, 4194645, n - 1);
                return;
            }
            case 76: {
                this.found(in, RTerminal.NUM_INT, 4194645, n);
                return;
            }
            case 105: {
                this.found(in, RTerminal.NUM_CPLX, 4194645, n);
                return;
            }
            default: {
                this.found(in, RTerminal.NUM_NUM, 4194645, n - 1);
                return;
            }
        }
        block19: while (true) {
            switch (in.get(n++)) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    continue block19;
                }
                case 46: {
                    this.readNumberHexPoint(in, n);
                    return;
                }
                case 80: 
                case 112: {
                    this.readNumberExp(in, n);
                    return;
                }
                case 76: {
                    if (n < 11 || n == 11 && in.get(2) <= 55) {
                        if ((this.configFlags & 0x20) != 0) {
                            this.numValue = this.parseHexIntValue(in, 2, n - 1);
                        }
                        this.found(in, RTerminal.NUM_INT, n);
                        return;
                    }
                    if ((this.configFlags & 0x20) != 0) {
                        this.numValue = Double.parseDouble(String.valueOf(in.getString(0, n - 1)) + "p0");
                    }
                    this.found(in, RTerminal.NUM_NUM, 353, n);
                    return;
                }
                case 105: {
                    if ((this.configFlags & 0x20) != 0) {
                        this.numValue = n < 11 || n == 11 && in.get(2) <= 55 ? (double)this.parseHexIntValue(in, 2, n - 1) : Double.parseDouble(String.valueOf(in.getString(0, n - 1)) + "p0");
                    }
                    this.found(in, RTerminal.NUM_CPLX, n);
                    return;
                }
            }
            break;
        }
        if ((this.configFlags & 0x20) != 0) {
            this.numValue = n < 11 || n == 11 && in.get(2) <= 55 ? (double)this.parseHexIntValue(in, 2, n - 1) : Double.parseDouble(String.valueOf(in.getString(0, n - 1)) + "p0");
        }
        this.found(in, RTerminal.NUM_NUM, n - 1);
    }

    private void readNumberDec(TextParserInput in) {
        int n = 1;
        block7: while (true) {
            switch (in.get(n++)) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block7;
                }
                case 46: {
                    this.readNumberDecPoint(in, n);
                    return;
                }
                case 69: 
                case 101: {
                    this.readNumberExp(in, n);
                    return;
                }
                case 76: {
                    if (n < 11 || n == 11 && RLexer.isLessEqual(in, 0, "2147483647")) {
                        if ((this.configFlags & 0x20) != 0) {
                            this.numValue = this.parseDecIntValue(in, 0, n - 1);
                        }
                        this.found(in, RTerminal.NUM_INT, n);
                        return;
                    }
                    if ((this.configFlags & 0x20) != 0) {
                        this.numValue = Double.parseDouble(in.getString(0, n - 1));
                    }
                    this.found(in, RTerminal.NUM_NUM, 353, n);
                    return;
                }
                case 105: {
                    if ((this.configFlags & 0x20) != 0) {
                        this.numValue = n < 11 ? (double)this.parseDecIntValue(in, 0, n - 1) : Double.parseDouble(in.getString(0, n - 1));
                    }
                    this.found(in, RTerminal.NUM_CPLX, n);
                    return;
                }
            }
            break;
        }
        if ((this.configFlags & 0x20) != 0) {
            this.numValue = n < 11 ? (double)this.parseDecIntValue(in, 0, n - 1) : Double.parseDouble(in.getString(0, n - 1));
        }
        this.found(in, RTerminal.NUM_NUM, n - 1);
    }

    private boolean isValidInt(String s) {
        try {
            double d = this.numValue = Double.parseDouble(s);
            int i = (int)d;
            return d == (double)i;
        }
        catch (NumberFormatException e) {
            this.numValue = Double.NaN;
            return false;
        }
    }

    private void readNumberDecPoint(TextParserInput in, int n) {
        block6: while (true) {
            switch (in.get(n++)) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block6;
                }
                case 69: 
                case 101: {
                    this.readNumberExp(in, n);
                    return;
                }
                case 76: {
                    if (this.isValidInt(in.getString(0, n - 1))) {
                        this.found(in, RTerminal.NUM_INT, 354, n);
                        return;
                    }
                    this.found(in, RTerminal.NUM_NUM, 353, n);
                    return;
                }
                case 105: {
                    if ((this.configFlags & 0x20) != 0) {
                        this.numValue = Double.parseDouble(in.getString(0, n - 1));
                    }
                    this.found(in, RTerminal.NUM_CPLX, n);
                    return;
                }
            }
            break;
        }
        if ((this.configFlags & 0x20) != 0) {
            this.numValue = Double.parseDouble(in.getString(0, n - 1));
        }
        this.found(in, RTerminal.NUM_NUM, n - 1);
    }

    private void readNumberHexPoint(TextParserInput in, int n) {
        block6: while (true) {
            switch (in.get(n++)) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    continue block6;
                }
                case 80: 
                case 112: {
                    this.readNumberExp(in, n);
                    return;
                }
                case 76: {
                    this.found(in, RTerminal.NUM_INT, 4194646, n);
                    return;
                }
                case 105: {
                    this.found(in, RTerminal.NUM_CPLX, 4194646, n);
                    return;
                }
            }
            break;
        }
        this.found(in, RTerminal.NUM_NUM, 4194646, n - 1);
    }

    private void readNumberExp(TextParserInput in, int n) {
        int c = in.get(n++);
        switch (c) {
            case 43: 
            case 45: {
                c = in.get(n++);
                break;
            }
        }
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            case 76: {
                this.found(in, RTerminal.NUM_INT, 4194647, n);
                return;
            }
            case 105: {
                this.found(in, RTerminal.NUM_CPLX, 4194647, n);
                return;
            }
            default: {
                this.found(in, RTerminal.NUM_NUM, 4194647, n - 1);
                return;
            }
        }
        block13: while (true) {
            switch (in.get(n++)) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block13;
                }
                case 76: {
                    if (this.isValidInt(in.getString(0, n - 1))) {
                        this.found(in, RTerminal.NUM_INT, n);
                        return;
                    }
                    this.found(in, RTerminal.NUM_NUM, 353, n);
                    return;
                }
                case 105: {
                    if ((this.configFlags & 0x20) != 0) {
                        this.numValue = Double.parseDouble(in.getString(0, n - 1));
                    }
                    this.found(in, RTerminal.NUM_CPLX, n);
                    return;
                }
            }
            break;
        }
        if ((this.configFlags & 0x20) != 0) {
            this.numValue = Double.parseDouble(in.getString(0, n - 1));
        }
        this.found(in, RTerminal.NUM_NUM, n - 1);
    }

    private int nIdentifier(TextParserInput in, int n) {
        block4: while (true) {
            int next = in.get(n++);
            switch (next) {
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block4;
                }
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 47: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 96: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: {
                    return n - 1;
                }
            }
            if (!Character.isLetterOrDigit(next)) break;
        }
        return n - 1;
    }

    private void readQuoted(TextParserInput in, RTerminal type, char cQuote) {
        StringBuilder text = this.getTextBuilder();
        int n = 1;
        int textOffset = 1;
        block41: while (true) {
            int cn = in.get(n++);
            switch (cn) {
                case -1: {
                    if (textOffset > 1) {
                        in.appendTo(textOffset, n - 1, text);
                        this.textBuilderText = true;
                    } else {
                        this.textBuilderText = false;
                    }
                    this.found(in, type, 4194592, n - 1);
                    return;
                }
                case 92: {
                    switch (in.get(n)) {
                        case -1: {
                            continue block41;
                        }
                        case 34: 
                        case 39: 
                        case 92: 
                        case 96: {
                            in.appendTo(textOffset, n - 1, text);
                            textOffset = n++;
                            continue block41;
                        }
                        case 10: {
                            in.appendTo(textOffset, n - 1, text);
                            textOffset = n++;
                            this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                            continue block41;
                        }
                        case 97: {
                            in.appendTo(textOffset, n - 1, text);
                            text.append('\u0007');
                            textOffset = ++n;
                            continue block41;
                        }
                        case 98: {
                            in.appendTo(textOffset, n - 1, text);
                            text.append('\b');
                            textOffset = ++n;
                            continue block41;
                        }
                        case 102: {
                            in.appendTo(textOffset, n - 1, text);
                            text.append('\f');
                            textOffset = ++n;
                            continue block41;
                        }
                        case 110: {
                            in.appendTo(textOffset, n - 1, text);
                            text.append('\n');
                            textOffset = ++n;
                            continue block41;
                        }
                        case 114: {
                            in.appendTo(textOffset, n - 1, text);
                            text.append('\r');
                            textOffset = ++n;
                            continue block41;
                        }
                        case 116: {
                            in.appendTo(textOffset, n - 1, text);
                            text.append('\t');
                            textOffset = ++n;
                            continue block41;
                        }
                        case 118: {
                            in.appendTo(textOffset, n - 1, text);
                            text.append('\u000b');
                            textOffset = ++n;
                            continue block41;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int digitsStart = n;
                            block42: while (n - digitsStart < 3) {
                                switch (in.get(n)) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: {
                                        ++n;
                                        break;
                                    }
                                    default: {
                                        break block42;
                                    }
                                }
                            }
                            long c = (char)Long.parseLong(in.getString(digitsStart, n), 8);
                            if (c == 0L) {
                                this.readQuoted(in, type, cQuote, n, 4194673, RLexer.createDetail(in, digitsStart - 1, n, null));
                                return;
                            }
                            in.appendTo(textOffset, digitsStart - 1, text);
                            text.append((char)c);
                            textOffset = n;
                            continue block41;
                        }
                        case 120: {
                            int digitsStart = ++n;
                            block43: while (n - digitsStart < 2) {
                                switch (in.get(n)) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 97: 
                                    case 98: 
                                    case 99: 
                                    case 100: 
                                    case 101: 
                                    case 102: {
                                        ++n;
                                        break;
                                    }
                                    default: {
                                        break block43;
                                    }
                                }
                            }
                            if (n == digitsStart) {
                                this.readQuoted(in, type, cQuote, n, 4194677, RLexer.createDetail(in, digitsStart - 2, n, "\\x"));
                                return;
                            }
                            int c = (int)Long.parseLong(in.getString(digitsStart, n), 16);
                            if (c == 0) {
                                this.readQuoted(in, type, cQuote, n, 4194673, RLexer.createDetail(in, digitsStart - 2, n, null));
                                return;
                            }
                            in.appendTo(textOffset, digitsStart - 2, text);
                            text.append((char)c);
                            textOffset = n;
                            continue block41;
                        }
                        case 117: {
                            int digitsStart;
                            if (in.get(n + 1) == 123) {
                                digitsStart = n += 2;
                                block44: while (n - digitsStart < 4) {
                                    switch (in.get(n)) {
                                        case 48: 
                                        case 49: 
                                        case 50: 
                                        case 51: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 55: 
                                        case 56: 
                                        case 57: 
                                        case 65: 
                                        case 66: 
                                        case 67: 
                                        case 68: 
                                        case 69: 
                                        case 70: 
                                        case 97: 
                                        case 98: 
                                        case 99: 
                                        case 100: 
                                        case 101: 
                                        case 102: {
                                            ++n;
                                            break;
                                        }
                                        default: {
                                            break block44;
                                        }
                                    }
                                }
                                if (type == RTerminal.SYMBOL_G) {
                                    if (in.get(n) != 125) {
                                        this.readQuoted(in, type, cQuote, n, 4194675, RLexer.createDetail(in, digitsStart - 3, n, "\\u{xxxx}"));
                                        return;
                                    }
                                    this.readQuoted(in, type, cQuote, n + 1, 4194675, RLexer.createDetail(in, digitsStart - 3, n + 1, "\\u{xxxx}"));
                                    return;
                                }
                                if (in.get(n) != 125) {
                                    this.readQuoted(in, type, cQuote, n, 4194676, RLexer.createDetail(in, digitsStart - 3, n, "\\u{xxxx}"));
                                    return;
                                }
                                if (n == digitsStart) {
                                    this.readQuoted(in, type, cQuote, n + 1, 4194677, RLexer.createDetail(in, digitsStart - 3, n + 1, "\\u{xxxx}"));
                                    return;
                                }
                                int c = (int)Long.parseLong(in.getString(digitsStart, n), 16);
                                if (c == 0) {
                                    this.readQuoted(in, type, cQuote, n + 1, 4194673, RLexer.createDetail(in, digitsStart - 3, n + 1, null));
                                    return;
                                }
                                in.appendTo(textOffset, digitsStart - 3, text);
                                text.append((char)c);
                                textOffset = ++n;
                                continue block41;
                            }
                            digitsStart = ++n;
                            block45: while (n - digitsStart < 4) {
                                switch (in.get(n)) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 97: 
                                    case 98: 
                                    case 99: 
                                    case 100: 
                                    case 101: 
                                    case 102: {
                                        ++n;
                                        break;
                                    }
                                    default: {
                                        break block45;
                                    }
                                }
                            }
                            if (type == RTerminal.SYMBOL_G) {
                                this.readQuoted(in, type, cQuote, n, 4194675, RLexer.createDetail(in, digitsStart - 2, n, "\\uxxxx"));
                                return;
                            }
                            if (n == digitsStart) {
                                this.readQuoted(in, type, cQuote, n, 4194677, RLexer.createDetail(in, digitsStart - 2, n, "\\uxxxx"));
                                return;
                            }
                            int c = (int)Long.parseLong(in.getString(digitsStart, n), 16);
                            if (c == 0) {
                                this.readQuoted(in, type, cQuote, n, 4194673, RLexer.createDetail(in, digitsStart - 2, n, null));
                                return;
                            }
                            in.appendTo(textOffset, digitsStart - 2, text);
                            text.append((char)c);
                            textOffset = n;
                            continue block41;
                        }
                        case 85: {
                            int digitsStart;
                            if (in.get(n + 1) == 123) {
                                digitsStart = n += 2;
                                block46: while (n - digitsStart < 8) {
                                    switch (in.get(n)) {
                                        case 48: 
                                        case 49: 
                                        case 50: 
                                        case 51: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 55: 
                                        case 56: 
                                        case 57: 
                                        case 65: 
                                        case 66: 
                                        case 67: 
                                        case 68: 
                                        case 69: 
                                        case 70: 
                                        case 97: 
                                        case 98: 
                                        case 99: 
                                        case 100: 
                                        case 101: 
                                        case 102: {
                                            ++n;
                                            break;
                                        }
                                        default: {
                                            break block46;
                                        }
                                    }
                                }
                                if (type == RTerminal.SYMBOL_G) {
                                    if (in.get(n) != 125) {
                                        this.readQuoted(in, type, cQuote, n, 4194675, RLexer.createDetail(in, digitsStart - 3, n, "\\U{xxxxxxxx}"));
                                        return;
                                    }
                                    this.readQuoted(in, type, cQuote, n + 1, 4194675, RLexer.createDetail(in, digitsStart - 3, n + 1, "\\U{xxxxxxxx}"));
                                    return;
                                }
                                if (in.get(n) != 125) {
                                    this.readQuoted(in, type, cQuote, n, 4194676, RLexer.createDetail(in, digitsStart - 3, n, "\\U{xxxxxxxx}"));
                                    return;
                                }
                                if (n == digitsStart) {
                                    this.readQuoted(in, type, cQuote, n + 1, 4194677, RLexer.createDetail(in, digitsStart - 3, n + 1, "\\U{xxxxxxxx}"));
                                    return;
                                }
                                int c = (int)Long.parseLong(in.getString(digitsStart, n), 16);
                                if (c == 0) {
                                    this.readQuoted(in, type, cQuote, n + 1, 4194673, RLexer.createDetail(in, digitsStart - 3, n + 1, null));
                                    return;
                                }
                                if (Character.isBmpCodePoint(c)) {
                                    in.appendTo(textOffset, digitsStart - 3, text);
                                    text.append((char)c);
                                    textOffset = ++n;
                                    continue block41;
                                }
                                if (Character.isValidCodePoint(c)) {
                                    in.appendTo(textOffset, digitsStart - 3, text);
                                    text.append(Character.highSurrogate(c));
                                    text.append(Character.lowSurrogate(c));
                                    textOffset = ++n;
                                    continue block41;
                                }
                                this.readQuoted(in, type, cQuote, n + 1, 4194683, RLexer.createDetail(in, digitsStart - 3, n + 1, Chars.formatCodePoint((int)c)));
                                return;
                            }
                            digitsStart = ++n;
                            block47: while (n - digitsStart < 8) {
                                switch (in.get(n)) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 97: 
                                    case 98: 
                                    case 99: 
                                    case 100: 
                                    case 101: 
                                    case 102: {
                                        ++n;
                                        break;
                                    }
                                    default: {
                                        break block47;
                                    }
                                }
                            }
                            if (type == RTerminal.SYMBOL_G) {
                                this.readQuoted(in, type, cQuote, n, 4194675, RLexer.createDetail(in, digitsStart - 2, n, "\\Uxxxxxxxx"));
                                return;
                            }
                            if (n == digitsStart) {
                                this.readQuoted(in, type, cQuote, n, 4194677, RLexer.createDetail(in, digitsStart - 2, n, "\\Uxxxxxxxx"));
                                return;
                            }
                            int c = (int)Long.parseLong(in.getString(digitsStart, n), 16);
                            if (c == 0) {
                                this.readQuoted(in, type, cQuote, n, 4194673, RLexer.createDetail(in, digitsStart - 2, n, null));
                                return;
                            }
                            if (Character.isBmpCodePoint(c)) {
                                in.appendTo(textOffset, digitsStart - 2, text);
                                text.append((char)c);
                                textOffset = n;
                                continue block41;
                            }
                            if (Character.isValidCodePoint(c)) {
                                in.appendTo(textOffset, digitsStart - 2, text);
                                text.append(Character.highSurrogate(c));
                                text.append(Character.lowSurrogate(c));
                                textOffset = n;
                                continue block41;
                            }
                            this.readQuoted(in, type, cQuote, n, 4194683, RLexer.createDetail(in, digitsStart - 2, n, StringUtils.formatCodePoint((int)c)));
                            return;
                        }
                    }
                    this.readQuoted(in, type, cQuote, n, 4194681, RLexer.createDetail(in, n - 1, n + 1, in.getString(n - 1, n + 1)));
                    return;
                }
                case 13: {
                    if (in.get(n++) != 10) {
                        --n;
                    }
                    this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                    continue block41;
                }
                case 10: {
                    this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                    continue block41;
                }
                case 0: {
                    this.readQuoted(in, type, cQuote, n, 4194673, RLexer.createDetail(in, n - 1, n, null));
                    return;
                }
            }
            if (cn == cQuote) break;
        }
        if (textOffset > 1) {
            in.appendTo(textOffset, n - 1, text);
            this.textBuilderText = true;
        } else {
            this.textBuilderText = false;
        }
        this.found(in, type, n);
    }

    private void readQuoted(TextParserInput in, RTerminal type, char cQuote, int n, int statusCode, StatusDetail detail) {
        this.textBuilderText = false;
        block6: while (true) {
            int cn = in.get(n++);
            switch (cn) {
                case -1: {
                    this.found(in, type, 4194592, n - 1);
                    return;
                }
                case 92: {
                    if (in.get(n++) != -1) continue block6;
                    this.found(in, type, 4194592, n - 1);
                    return;
                }
                case 13: {
                    if (in.get(n++) != 10) {
                        --n;
                    }
                    this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                    continue block6;
                }
                case 10: {
                    this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                    continue block6;
                }
            }
            if (cn == cQuote) break;
        }
        this.found(in, type, statusCode, detail, n);
    }

    private void readStringR(TextParserInput in, char cQuote) {
        int nDashes;
        char cClose;
        int status = 0;
        int n = 2;
        block13: while (true) {
            switch (in.get(n++)) {
                case 45: {
                    continue block13;
                }
                case 40: {
                    cClose = ')';
                    nDashes = n - 3;
                    break block13;
                }
                case 91: {
                    cClose = ']';
                    nDashes = n - 3;
                    break block13;
                }
                case 123: {
                    cClose = '}';
                    nDashes = n - 3;
                    break block13;
                }
                default: {
                    this.found(in, RTerminal.STRING_R, 0x400110, n - 1);
                    return;
                }
            }
            break;
        }
        this.textOffset = n;
        block14: while (true) {
            char c = in.get(n++);
            switch (c) {
                case '\uffffffff': {
                    this.found(in, RTerminal.STRING_R, 4194592, RLexer.createDetail(in, 0, n - 1, this.createStringRClosingSequence(cQuote, cClose, nDashes)), n - 1);
                    return;
                }
                case '\r': {
                    if (in.get(n++) != 10) {
                        --n;
                    }
                    this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                    continue block14;
                }
                case '\n': {
                    this.handleNewLine(in.getIndex() + in.getLengthInSource(n));
                    continue block14;
                }
                case '\u0000': {
                    if (status != 0) continue block14;
                    status = 4194673;
                    this.foundDetail = RLexer.createDetail(in, n - 1, n, null);
                    continue block14;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (c != cClose || !(nDashes == 0 ? in.matches(n, cQuote) : in.matchesN(n, '-', nDashes) && in.matches(n + nDashes, cQuote))) continue block14;
                    this.found(in, RTerminal.STRING_R, status, status != 0 ? this.foundDetail : null, n + nDashes + 1);
                    return;
                }
            }
        }
    }

    private String createStringRClosingSequence(char cQuote, char cClose, int nDashes) {
        StringBuilder closingSequence = this.getTextBuilder();
        closingSequence.append(cClose);
        int i = 0;
        while (i < nDashes) {
            closingSequence.append('-');
            ++i;
        }
        closingSequence.append(cQuote);
        return closingSequence.toString();
    }

    protected void handleNewLine(int offset) {
    }

    private int decDigit(int c) {
        return c - 48;
    }

    private int hexDigit(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return c - 48;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return c - 55;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return c - 87;
            }
        }
        throw new IllegalStateException();
    }

    private int parseDecIntValue(TextParserInput in, int i, int n) {
        int result = 0;
        while (i < n) {
            result *= 10;
            result += this.decDigit(in.get(i++));
        }
        return result;
    }

    private int parseHexIntValue(TextParserInput in, int i, int n) {
        int result = 0;
        while (i < n) {
            result *= 16;
            result += this.hexDigit(in.get(i++));
        }
        return result;
    }

    public double getNumValue() {
        return this.numValue;
    }
}

