/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import java.util.List;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperation;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolConfig;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class DocProcessingToolOperationIterator
implements Comparable<DocProcessingToolOperationIterator> {
    public static final byte PRE = 1;
    public static final byte MAIN = 2;
    public static final byte POST = 3;
    private final ImList<DocProcessingToolConfig.StepConfig> steps;
    private int stepIdx;
    private  @Nullable DocProcessingToolConfig.StepConfig stepConfig;
    private byte stepPart;
    private @Nullable List<DocProcessingOperation> stepPartList;
    private int stepPartIdx;
    private @Nullable DocProcessingOperation operation;

    public DocProcessingToolOperationIterator(ImList<DocProcessingToolConfig.StepConfig> steps) {
        this.steps = steps;
        this.reset();
    }

    @Override
    public int compareTo(DocProcessingToolOperationIterator other) {
        int diff = this.stepIdx - other.stepIdx;
        if (diff == 0 && (diff = this.stepPart - other.stepPart) == 0) {
            diff = this.stepPartIdx - other.stepPartIdx;
        }
        return diff;
    }

    public void reset() {
        this.stepIdx = -1;
        this.stepConfig = null;
        this.stepPart = (byte)-1;
        this.stepPartList = null;
        this.stepPartIdx = -1;
        this.operation = null;
    }

    public void reset(DocProcessingToolOperationIterator other) {
        this.stepIdx = other.stepIdx;
        this.stepConfig = other.stepConfig;
        this.stepPart = other.stepPart;
        this.stepPartList = other.stepPartList;
        this.stepPartIdx = other.stepPartIdx;
        this.operation = other.operation;
    }

    public boolean hasNext() {
        if (this.stepIdx < 0) {
            return this.nextStep();
        }
        return this.operation != null;
    }

    public boolean next() {
        if (this.stepIdx < 0) {
            return this.nextStep();
        }
        if (this.stepIdx == Integer.MAX_VALUE) {
            return false;
        }
        this.operation = null;
        return this.nextOperation() || this.nextPart() || this.nextStep();
    }

    private boolean nextStep() {
        while (++this.stepIdx < this.steps.size()) {
            DocProcessingToolConfig.StepConfig stepConfig = (DocProcessingToolConfig.StepConfig)this.steps.get(this.stepIdx);
            if (!stepConfig.isRun()) continue;
            this.stepConfig = stepConfig;
            if (!this.nextPart()) continue;
            return true;
        }
        this.stepIdx = Integer.MAX_VALUE;
        this.stepConfig = null;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean nextPart() {
        DocProcessingToolConfig.StepConfig stepConfig = this.stepConfig;
        if (stepConfig == null) {
            return false;
        }
        block6: while (true) {
            this.stepPart = (byte)(this.stepPart + 1);
            switch (this.stepPart) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    this.stepPartList = stepConfig.getPre();
                    if (!this.nextOperation()) continue block6;
                    return true;
                }
                case 2: {
                    this.operation = stepConfig.getOperation();
                    if (this.operation == null) continue block6;
                    return true;
                }
                case 3: {
                    this.stepPartList = stepConfig.getPost();
                    if (this.nextOperation()) return true;
                    continue block6;
                }
            }
            break;
        }
        this.stepPart = (byte)-1;
        return false;
    }

    private boolean nextOperation() {
        List<DocProcessingOperation> stepPartList = this.stepPartList;
        if (stepPartList == null) {
            return false;
        }
        if (++this.stepPartIdx < stepPartList.size()) {
            this.operation = stepPartList.get(this.stepPartIdx);
            return true;
        }
        this.stepPartIdx = -1;
        this.stepPartList = null;
        return false;
    }

    public int getStepIdx() {
        return this.stepIdx;
    }

    public  @Nullable DocProcessingToolConfig.StepConfig getStepConfig() {
        return this.stepConfig;
    }

    public byte getStepPart() {
        return this.stepPart;
    }

    public DocProcessingOperation getOperation() {
        return this.operation;
    }
}

