/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.BasicEditorOutlinePage;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementDelta;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.LTKInputData;
import org.eclipse.statet.ltk.ui.ModelElementInputListener;
import org.eclipse.statet.ltk.ui.SelectionWithElementInfoListener;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAssociated;
import org.eclipse.statet.ltk.ui.util.ExtModelContentProvider;
import org.eclipse.statet.ltk.ui.util.ExtModelLabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

@NonNullByDefault
public abstract class SourceEditor1OutlinePage
extends BasicEditorOutlinePage
implements IContentOutlinePage,
IAdaptable,
SourceEditorAssociated,
IShowInSource,
IShowInTargetList,
IShowInTarget,
IPostSelectionProvider,
ModelElementInputListener<LtkModelElement<?>> {
    private final SourceEditor1 editor;
    private final String modelTypeId;
    private ExtModelContentProvider contentProvider;
    private @Nullable SourceModelStamp currentModelStamp;
    private @Nullable LtkModelElement<?> inputUnit;
    private SyncWithEditorAction syncWithEditorAction;

    public SourceEditor1OutlinePage(SourceEditor1 editor, String modelTypeId, String contextMenuId) {
        super(contextMenuId);
        this.editor = (SourceEditor1)ObjectUtils.nonNullAssert((Object)editor);
        this.modelTypeId = (String)ObjectUtils.nonNullAssert((Object)modelTypeId);
    }

    public SourceEditor1 getEditor() {
        return this.editor;
    }

    public String getModelTypeId() {
        return this.modelTypeId;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    protected boolean isUpToDate(SourceModelStamp stamp) {
        SourceModelStamp current = this.currentModelStamp;
        return current != null && current.equals(stamp);
    }

    protected @Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> getContentFilter() {
        return null;
    }

    protected @Nullable TreeViewer getViewer() {
        return (TreeViewer)super.getViewer();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.editor.getModelInputProvider().addListener(this);
        this.getViewer().setInput(this.inputUnit);
    }

    protected void configureViewer(TreeViewer viewer) {
        this.contentProvider = this.createContentProvider();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
    }

    protected ExtModelContentProvider createContentProvider() {
        return new ExtModelContentProvider(new PageOutlineContent());
    }

    protected ILabelProvider createLabelProvider() {
        return new ExtModelLabelProvider(this.getModelTypeId());
    }

    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        super.initActions(serviceLocator, handlers);
        this.syncWithEditorAction = new SyncWithEditorAction();
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, this.editor.getAction(ITextEditorActionConstants.UNDO));
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, this.editor.getAction(ITextEditorActionConstants.REDO));
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", this.editor.getAction(ITextEditorActionConstants.NEXT));
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", this.editor.getAction(ITextEditorActionConstants.PREVIOUS));
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)this.syncWithEditorAction);
        IContextService contextService = (IContextService)ObjectUtils.nonNullAssert((Object)((IContextService)serviceLocator.getService(IContextService.class)));
        contextService.activateContext("org.eclipse.statet.ltk.contexts.EditSource1MenuSet");
    }

    protected void contextMenuAboutToShow(IMenuManager m) {
        Separator additions = new Separator("additions");
        m.add((IContributionItem)additions);
    }

    @Override
    public void elementChanged(@Nullable LtkModelElement<?> element) {
        this.inputUnit = element;
        this.currentModelStamp = null;
        TreeViewer viewer = this.getViewer();
        if (viewer != null && UIAccess.isOkToUse((Control)viewer.getControl())) {
            viewer.setInput(this.inputUnit);
        }
    }

    @Override
    public void elementInitialInfo(@Nullable LtkModelElement<?> element) {
        this.elementUpdatedInfo(element, (LtkModelElementDelta)null);
    }

    @Override
    public void elementUpdatedInfo(final @Nullable LtkModelElement<?> element, @Nullable LtkModelElementDelta delta) {
        if (element != this.inputUnit || element == null && this.inputUnit == null) {
            return;
        }
        Display display = UIAccess.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer viewer = SourceEditor1OutlinePage.this.getViewer();
                if (element != SourceEditor1OutlinePage.this.inputUnit || viewer == null || !UIAccess.isOkToUse((Control)viewer.getControl()) || SourceEditor1OutlinePage.this.isUpToDate(SourceEditor1OutlinePage.this.contentProvider.getStamp(element))) {
                    return;
                }
                SourceEditor1OutlinePage.this.beginIgnoreSelection();
                try {
                    viewer.refresh(true);
                }
                finally {
                    SourceEditor1OutlinePage.this.endIgnoreSelection(false);
                }
            }
        });
    }

    protected @Nullable SourceUnitModelInfo getModelInfo(Object input) {
        if (input instanceof SourceUnit) {
            return ((SourceUnit)input).getModelInfo(this.getModelTypeId(), 0, null);
        }
        return null;
    }

    public void dispose() {
        this.editor.getModelInputProvider().removeListener(this);
        this.editor.handleOutlinePageClosed();
        super.dispose();
    }

    protected void selectInEditor(ISelection selection) {
        this.editor.setSelection(selection, this.syncWithEditorAction);
    }

    protected void select(@Nullable SourceStructElement<?, ?> element) {
        TreeViewer viewer = this.getViewer();
        if (viewer != null && UIAccess.isOkToUse((Control)viewer.getControl())) {
            this.beginIgnoreSelection();
            try {
                LtkModelElementFilter<? super SourceStructElement<?, ?>> filter = this.getContentFilter();
                Object selectedElement = null;
                IStructuredSelection currentSelection = (IStructuredSelection)viewer.getSelection();
                if (currentSelection.size() == 1) {
                    selectedElement = currentSelection.getFirstElement();
                }
                while (element != null && (element.getElementType() & 0xFF0) != 528) {
                    SourceStructElement parent;
                    if (selectedElement != null && element.equals(selectedElement)) {
                        return;
                    }
                    if (filter == null || filter.include(element)) {
                        selectedElement = null;
                        viewer.setSelection((ISelection)new StructuredSelection(element), true);
                        if (!viewer.getSelection().isEmpty()) {
                            return;
                        }
                    }
                    if (!((parent = element.getSourceParent()) instanceof SourceStructElement)) break;
                    element = parent;
                }
                if (!viewer.getSelection().isEmpty()) {
                    viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
            finally {
                this.endIgnoreSelection(true);
            }
        }
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext((Object)this.editor.getEditorInput(), null);
    }

    public @NonNull String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
    }

    /*
     * WARNING - void declaration
     */
    public boolean show(ShowInContext context) {
        ISelection iSelection;
        LtkModelElement<?> inputUnit = this.inputUnit;
        ISelection selection = context.getSelection();
        if (inputUnit != null && (iSelection = selection) instanceof LTKInputData) {
            void data;
            LTKInputData lTKInputData = (LTKInputData)iSelection;
            LTKInputData cfr_ignored_0 = (LTKInputData)iSelection;
            data.update();
            if (inputUnit.equals(data.getInputElement())) {
                this.select(data.getModelSelection());
                return true;
            }
        }
        return false;
    }

    @Override
    public SourceEditor getSourceEditor() {
        return this.editor;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == SourceEditorAssociated.class) {
            return (T)this;
        }
        if (adapterType == IEncodingSupport.class) {
            return (T)this.editor.getAdapter(IEncodingSupport.class);
        }
        if (adapterType == IContentType.class) {
            return (T)this.editor.getContentType();
        }
        return null;
    }

    public class AstContentProvider
    extends ExtModelContentProvider {
        public AstContentProvider() {
            super(new PageOutlineContent());
        }

        @Override
        public @Nullable SourceModelStamp getStamp(Object inputElement) {
            AstInfo ast;
            if (inputElement instanceof SourceUnit && (ast = ((SourceUnit)inputElement).getAstInfo(SourceEditor1OutlinePage.this.getModelTypeId(), false, null)) != null) {
                return ast.getStamp();
            }
            return null;
        }

        @Override
        public @NonNull Object[] getElements(Object inputElement) {
            AstInfo ast;
            if (inputElement instanceof SourceUnit && (ast = ((SourceUnit)inputElement).getAstInfo(SourceEditor1OutlinePage.this.getModelTypeId(), false, null)) != null) {
                SourceEditor1OutlinePage.this.currentModelStamp = ast.getStamp();
                return new Object[]{ast.getRoot()};
            }
            return new Object[0];
        }
    }

    protected class PageOutlineContent
    implements ExtModelContentProvider.ModelContent {
        @Override
        public @Nullable SourceUnitModelInfo getModelInfo(Object input) {
            return SourceEditor1OutlinePage.this.getModelInfo(input);
        }

        @Override
        public @Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> getContentFilter() {
            return SourceEditor1OutlinePage.this.getContentFilter();
        }
    }

    private class SyncWithEditorAction
    extends ToggleAction
    implements SelectionWithElementInfoListener {
        public SyncWithEditorAction() {
            super("sync.editor", true, 0);
            this.setText(EditingMessages.SyncWithEditor_label);
            this.setImageDescriptor(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/synchronized"));
        }

        @Override
        protected void configure(boolean on) {
            if (on) {
                SourceEditor1OutlinePage.this.editor.addPostSelectionWithElementInfoListener(this);
            } else {
                SourceEditor1OutlinePage.this.editor.removePostSelectionWithElementInfoListener(this);
            }
        }

        @Override
        public void inputChanged() {
        }

        @Override
        public void stateChanged(final LTKInputData state) {
            if (!state.isStillValid()) {
                return;
            }
            SourceUnitModelInfo inputInfo = state.getInputInfo();
            if (inputInfo == null || !SourceEditor1OutlinePage.this.isUpToDate(inputInfo.getStamp())) {
                SourceEditor1OutlinePage.this.elementUpdatedInfo(state.getInputElement(), (LtkModelElementDelta)null);
            }
            UIAccess.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (state.isStillValid() && SyncWithEditorAction.this.isChecked()) {
                        SourceEditor1OutlinePage.this.select(state.getModelSelection());
                    }
                }
            });
        }
    }

    @Deprecated
    protected abstract class ToggleAction
    extends Action {
        private final String settingsKey;
        private final int time;

        public ToggleAction(String checkSettingsKey, boolean checkSettingsDefault, int expensive) {
            assert (checkSettingsKey != null);
            this.settingsKey = checkSettingsKey;
            this.time = expensive;
            IDialogSettings settings = SourceEditor1OutlinePage.this.getDialogSettings();
            boolean on = settings.get(this.settingsKey) == null ? checkSettingsDefault : SourceEditor1OutlinePage.this.getDialogSettings().getBoolean(this.settingsKey);
            this.setChecked(on);
            this.configure(on);
        }

        protected void init() {
        }

        public void run() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    boolean on = ToggleAction.this.isChecked();
                    ToggleAction.this.configure(on);
                    SourceEditor1OutlinePage.this.getDialogSettings().put(ToggleAction.this.settingsKey, on);
                }
            };
            if (this.time == 0) {
                runnable.run();
            } else {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
            }
        }

        protected abstract void configure(boolean var1);
    }
}

