/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.text.core.CharPairMatcher;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.IEditorStatusLine;

@NonNullByDefault
public class GotoMatchingBracketHandler
extends AbstractHandler {
    private final CharPairMatcher pairMatcher;
    private final SourceEditor sourceEditor;

    public GotoMatchingBracketHandler(CharPairMatcher pairMatcher, SourceEditor editor) {
        assert (editor != null);
        this.sourceEditor = editor;
        this.pairMatcher = (CharPairMatcher)ObjectUtils.nonNullAssert((Object)pairMatcher);
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        this.gotoMatchingBracket();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void gotoMatchingBracket() {
        SourceViewer sourceViewer = this.sourceEditor.getViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        ITextSelection selection = (ITextSelection)sourceViewer.getSelectionProvider().getSelection();
        int offset = selection.getOffset();
        int selectionLength = selection.getLength();
        IRegion region = selectionLength <= 1 ? this.pairMatcher.match(document, offset, selection.getLength() == 0) : null;
        String message = null;
        if (region == null) {
            message = EditingMessages.GotoMatchingBracketAction_error_InvalidSelection;
        } else if (region.getLength() < 2) {
            if (region.getLength() >= 0) {
                return;
            }
            message = EditingMessages.GotoMatchingBracketAction_error_NoMatchingBracket;
        }
        if (message != null) {
            IEditorStatusLine statusLine = (IEditorStatusLine)this.sourceEditor.getAdapter(IEditorStatusLine.class);
            if (statusLine != null) {
                statusLine.setMessage(true, message, null);
            }
            Display.getCurrent().beep();
            return;
        }
        int targetOffset = this.pairMatcher.getAnchor() == 0 ? region.getOffset() + 1 : region.getOffset() + region.getLength() - 1;
        boolean visible = false;
        SourceViewer sourceViewer2 = sourceViewer;
        if (sourceViewer2 instanceof ITextViewerExtension5) {
            void extension;
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)sourceViewer2;
            ITextViewerExtension5 cfr_ignored_0 = (ITextViewerExtension5)sourceViewer2;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            IEditorStatusLine statusLine = (IEditorStatusLine)this.sourceEditor.getAdapter(IEditorStatusLine.class);
            if (statusLine != null) {
                statusLine.setMessage(true, EditingMessages.GotoMatchingBracketAction_error_BracketOutsideSelectedElement, null);
            }
            Display.getCurrent().beep();
            return;
        }
        sourceViewer.setSelectedRange(targetOffset, 0);
        sourceViewer.revealRange(targetOffset, 0);
    }
}

