/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tea.library.build.internal.Activator;
import org.eclipse.tea.library.build.model.ManifestHolder;
import org.eclipse.tea.library.build.model.ParameterValue;
import org.osgi.framework.Version;

public abstract class BundleData {
    private final String bundleName;
    protected final File bundleDir;
    protected final boolean hasSource;
    protected final File jarFile;
    protected final ManifestHolder manifest;
    static final String[] EMPTY_STRINGS = new String[0];

    protected BundleData(String projectName, File bundleDir, boolean hasSource, File jarFile) {
        this.bundleDir = bundleDir;
        this.hasSource = hasSource;
        this.jarFile = jarFile;
        this.manifest = jarFile != null ? BundleData.readManifestFromJar(jarFile) : (bundleDir.isDirectory() ? BundleData.readManifestFromDirectory(bundleDir) : null);
        if (this.manifest != null) {
            ParameterValue symName = this.manifest.getSymbolicName();
            if (symName != null) {
                this.bundleName = symName.getValue();
                if (projectName != null && !this.bundleName.equals(projectName)) {
                    Activator.log(2, "Missmatch of names: projectName=" + projectName + "  bundleName=" + this.bundleName, null);
                }
            } else {
                this.bundleName = projectName;
            }
        } else {
            this.bundleName = projectName;
        }
    }

    public boolean isMetadataOK() {
        return this.manifest != null;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public final File getBundleDir() {
        return this.bundleDir;
    }

    public final boolean hasSource() {
        return this.hasSource;
    }

    public final File getJarFile() {
        return this.jarFile;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(\"" + this.getBundleName() + "\")";
    }

    public final boolean writeManifest() {
        File manifestFile = this.getManifestFile();
        if (manifestFile == null) {
            return false;
        }
        try {
            this.manifest.write(manifestFile);
            return true;
        }
        catch (Exception ex) {
            throw new IllegalStateException("cannot write " + manifestFile, ex);
        }
    }

    public final File getManifestFile() {
        if (this.manifest == null || !this.hasSource || this.bundleDir == null) {
            return null;
        }
        return new File(this.bundleDir, "META-INF/MANIFEST.MF");
    }

    public abstract String getBundleVersion();

    public final Version getVersion() {
        return Version.parseVersion((String)this.getBundleVersion());
    }

    public abstract void setBundleVersion(String var1);

    protected static ManifestHolder readManifestFromDirectory(File bundleDir) {
        ManifestHolder manifestHolder;
        File manifestFile = new File(bundleDir, "META-INF/MANIFEST.MF");
        if (!manifestFile.isFile()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(manifestFile);
        try {
            Manifest mf = new Manifest(fis);
            manifestHolder = ManifestHolder.fromManifest(mf, manifestFile);
        }
        catch (Throwable throwable) {
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new IllegalStateException("cannot read " + manifestFile, ex);
            }
        }
        fis.close();
        return manifestHolder;
    }

    protected static ManifestHolder readManifestFromJar(File jarFile) {
        ManifestHolder manifestHolder;
        JarFile jar = new JarFile(jarFile);
        try {
            Manifest mf = jar.getManifest();
            manifestHolder = ManifestHolder.fromManifest(mf, null);
        }
        catch (Throwable throwable) {
            try {
                jar.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new IllegalStateException("cannot read " + jarFile, ex);
            }
        }
        jar.close();
        return manifestHolder;
    }

    protected static Properties readBuildPropertiesFromDirectory(File bundleDir) {
        Properties properties;
        File propFile = new File(bundleDir, "build.properties");
        if (!propFile.isFile()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(propFile);
        try {
            Properties result = new Properties();
            result.load(fis);
            properties = result;
        }
        catch (Throwable throwable) {
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new IllegalStateException("cannot read " + propFile, ex);
            }
        }
        fis.close();
        return properties;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static Properties readBuildPropertiesFromJar(File jarFile) {
        try (JarFile jar = new JarFile(jarFile);){
            Properties properties;
            ZipEntry ze = jar.getEntry("build.properties");
            if (ze == null) {
                return null;
            }
            InputStream is = jar.getInputStream(ze);
            try {
                Properties result = new Properties();
                result.load(is);
                is.close();
                properties = result;
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
            return properties;
        }
        catch (Exception ex) {
            throw new IllegalStateException("cannot read " + jarFile, ex);
        }
    }

    protected static String[] splitList(Attributes attributes, String name) {
        String value = attributes.getValue(name);
        return BundleData.splitList(value);
    }

    protected static String[] splitList(Properties props, String name) {
        String value = props.getProperty(name);
        return BundleData.splitList(value);
    }

    private static String[] splitList(String value) {
        if (value == null) {
            return EMPTY_STRINGS;
        }
        ArrayList<String> parts = new ArrayList<String>();
        int len = value.length();
        char[] chars = value.toCharArray();
        int i1 = 0;
        int i2 = 1;
        block0: while (i2 < len) {
            char c = chars[i2];
            if (c == ',') {
                BundleData.addPart(parts, value.substring(i1, i2).trim());
                i1 = i2 + 1;
                i2 = i1 + 1;
                continue;
            }
            if (c == '\"') {
                ++i2;
                while (i2 < len) {
                    c = chars[i2];
                    ++i2;
                    if (c == '\"') continue block0;
                }
                continue;
            }
            ++i2;
        }
        if (i1 < len) {
            BundleData.addPart(parts, value.substring(i1).trim());
        }
        return parts.toArray(new String[parts.size()]);
    }

    private static void addPart(List<String> parts, String v) {
        if (v.isEmpty() || v.equals(",")) {
            return;
        }
        parts.add(v);
    }

    protected static String[] mergeLists(String[] a, String[] b) {
        if (a.length < 1) {
            return b;
        }
        if (b.length < 1) {
            return a;
        }
        String[] result = new String[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    protected static Map<String, List<String>> splitMap(Properties props, String prefix) {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String fullKey = entry.getKey().toString();
            if (!fullKey.startsWith(prefix)) continue;
            String itemName = fullKey.substring(prefix.length());
            result.put(itemName, Arrays.asList(BundleData.splitList(entry.getValue().toString())));
        }
        return result;
    }

    public abstract IProject getProject();

    public final void refreshProject() {
        IProject project = this.getProject();
        if (project != null && project.exists() && project.isOpen()) {
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public void addDependency(String pluginName, boolean optional) {
        this.manifest.addDependency(pluginName, optional);
    }
}

