/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.util;

import java.util.Collection;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.chain.TeaBuildProjectElement;
import org.eclipse.tea.library.build.config.TeaBuildConfig;
import org.eclipse.tea.library.build.model.WorkspaceData;

public class TeaBuildUtil {
    private static final MultiStatus DEF_STATUS = new MultiStatus("org.eclipse.tea.library.build", 4, "", null);

    public static void tryCompile(Collection<IProject> projects) {
        IBuildConfiguration[] toBuild = (IBuildConfiguration[])projects.stream().map(TeaBuildUtil::getActiveConfigSafe).toArray(IBuildConfiguration[]::new);
        try {
            ResourcesPlugin.getWorkspace().build(toBuild, 6, false, null);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static IBuildConfiguration getActiveConfigSafe(IProject project) {
        try {
            return project.getActiveBuildConfig();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static IStatus tryCompile(TaskingLog log, TaskProgressTracker tracker, TeaBuildProjectElement element, TeaBuildConfig config) {
        IProject project = element.getProject();
        boolean isBinary = WorkspaceData.isBinaryProject(project);
        String logTxt = String.valueOf(isBinary ? "    binProject" : "compileProject") + ": " + element.getName();
        Exception compilerException = null;
        MultiStatus status = DEF_STATUS;
        int pass = 0;
        while ((long)pass < config.compileRetries) {
            if (tracker.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                if (pass == 0) {
                    log.info(logTxt);
                    project.build(6, null);
                } else {
                    if (isBinary) break;
                    log.info(String.valueOf(logTxt) + ": recompile " + Integer.toString(pass));
                    project.close(null);
                    project.open(null);
                    project.refreshLocal(2, null);
                    project.build(15, null);
                    project.build(6, null);
                }
                compilerException = null;
                status = TeaBuildUtil.getStatus(element);
                if (status.getSeverity() <= 2) break;
                if (pass == 0 && status.getSeverity() > 2) {
                    log.info(String.valueOf(logTxt) + ": fast recompile (" + status + ")");
                    project.build(6, null);
                    status = TeaBuildUtil.getStatus(element);
                    if (status.getSeverity() > 2) {
                        IStatus[] iStatusArray = status.getChildren();
                        int n = iStatusArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStatus s = iStatusArray[n2];
                            if (s.getSeverity() > 2) {
                                log.debug(s.getMessage());
                            }
                            ++n2;
                        }
                    }
                }
            }
            catch (Exception e) {
                compilerException = e;
                status = new MultiStatus("org.eclipse.tea.library.build", 4, "Exception during build of " + element.getName(), (Throwable)e);
                log.info(String.valueOf(logTxt) + ": got exception: " + e.toString());
            }
            ++pass;
        }
        if (compilerException != null) {
            return new Status(4, "org.eclipse.tea.library.build", String.valueOf(logTxt) + ": project can't be compiled", (Throwable)compilerException);
        }
        return status;
    }

    public static MultiStatus getStatus(TeaBuildProjectElement element) {
        MultiStatus status = new MultiStatus("org.eclipse.tea.library.build", 0, element.getName(), null);
        element.getStatus().forEach(arg_0 -> ((MultiStatus)status).add(arg_0));
        return status;
    }
}

