/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.TaskingEngine;
import org.eclipse.tea.core.internal.TaskingConfigurationInitializer;
import org.eclipse.tea.core.internal.TaskingConfigurationStore;
import org.eclipse.tea.core.internal.TaskingEngineActivator;
import org.eclipse.tea.core.services.TaskChain;
import org.osgi.framework.BundleContext;

public class TaskingInjectionHelper {
    public static final String CTX_TASK_CHAIN = "org.eclipse.tea.core.taskchain";
    public static final String CTX_CONFIG = "org.eclipse.tea.core.configuration";
    public static final String CTX_HEADLESS = "org.eclipse.tea.core.headless";
    public static final String CTX_OUTPUT = "org.eclipse.tea.core.output";
    public static final String CTX_TASK = "org.eclipse.tea.core.task";
    public static final String CTX_PREPARED_TASKS = "org.eclipse.tea.core.prepared_tasks";
    public static final String CTX_TASK_CONTEXTS = "org.eclipse.tea.core.prepared_task_contexts";
    public static final String CTX_TASK_WORK_AMOUNT = "org.eclipse.tea.core.task_work";

    public static IEclipseContext getRootContext() {
        return EclipseContextFactory.getServiceContext((BundleContext)TaskingEngineActivator.getContext());
    }

    public static TaskingEngine createNewEngine(TaskingConfigurationStore store) {
        IEclipseContext engineContext = TaskingInjectionHelper.createConfiguredContext(store);
        return (TaskingEngine)ContextInjectionFactory.make(TaskingEngine.class, (IEclipseContext)engineContext);
    }

    public static IEclipseContext findExecutionContext(IEclipseContext any) {
        if (any.getLocal(TaskExecutionContext.class) != null) {
            return any;
        }
        if (any.getParent() == null || any.getParent().equals(TaskingInjectionHelper.getRootContext())) {
            System.err.println("cannot find execution context, using " + any);
            return any;
        }
        return TaskingInjectionHelper.findExecutionContext(any.getParent());
    }

    public static IEclipseContext findContextWith(IEclipseContext ctx, Class<?> key) {
        if (ctx.getLocal(key) != null) {
            return ctx;
        }
        if (ctx.getParent() == null) {
            return null;
        }
        return TaskingInjectionHelper.findContextWith(ctx.getParent(), key);
    }

    public static void wipe(IEclipseContext context, Class<?> toRemove) {
        if (context == null) {
            return;
        }
        context.remove(toRemove);
        TaskingInjectionHelper.wipe(context.getParent(), toRemove);
    }

    public static IEclipseContext createConfiguredContext(TaskingConfigurationStore store) {
        IEclipseContext context = TaskingInjectionHelper.getRootContext().createChild("Engine with " + store.toString());
        context.set(TaskingConfigurationStore.class, (Object)store);
        TaskingInjectionHelper.reConfigureContext(context);
        return context;
    }

    public static void reConfigureContext(IEclipseContext child) {
        IEclipseContext context = TaskingInjectionHelper.findContextWith(child, TaskingConfigurationStore.class);
        if (context == null) {
            throw new IllegalStateException("Cannot find " + TaskingConfigurationStore.class.getName() + " in context hierarchy.");
        }
        TaskingConfigurationInitializer init = (TaskingConfigurationInitializer)ContextInjectionFactory.make(TaskingConfigurationInitializer.class, (IEclipseContext)context);
        ContextInjectionFactory.invoke((Object)init, Execute.class, (IEclipseContext)context);
    }

    public static TaskExecutionContext createNewChainContext(TaskingEngine engine, String chainName, IProgressMonitor monitor) {
        IEclipseContext chainContext = engine.getContext().createChild(chainName);
        chainContext.set(CTX_TASK_CHAIN, (Object)chainName);
        chainContext.set(IProgressMonitor.class, (Object)monitor);
        return (TaskExecutionContext)ContextInjectionFactory.make(TaskExecutionContext.class, (IEclipseContext)chainContext);
    }

    public static TaskExecutionContext createNewChainContext(TaskingEngine engine, TaskChain chain, IProgressMonitor monitor) {
        return TaskingInjectionHelper.createNewChainContext(engine.getContext(), chain, monitor);
    }

    static TaskExecutionContext createNewChainContext(IEclipseContext parent, TaskChain chain, IProgressMonitor monitor) {
        IEclipseContext chainContext = parent.createChild(chain.getClass().getName());
        chainContext.set(TaskChain.class, (Object)chain);
        chainContext.set(IProgressMonitor.class, (Object)monitor);
        return (TaskExecutionContext)ContextInjectionFactory.make(TaskExecutionContext.class, (IEclipseContext)chainContext);
    }

    public static boolean isHeadless(IEclipseContext context) {
        Boolean headless = (Boolean)context.get(CTX_HEADLESS);
        if (headless == null) {
            headless = Boolean.FALSE;
        }
        return headless;
    }
}

