/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.ease;

import java.io.OutputStream;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.ui.PlatformUI;

public class EaseScriptTask {
    private final String script;

    public EaseScriptTask(String script) {
        this.script = script;
    }

    @Execute
    public void runIt(TaskingLog log) throws Throwable {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        IRepositoryService repoService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
        log.info("Waiting for script locations to load");
        repoService.update(true);
        while (repoService.getScripts().isEmpty()) {
            Thread.sleep(100L);
        }
        Thread.sleep(500L);
        log.info("...loaded");
        IScript s = repoService.getScript(this.script);
        if (s == null) {
            throw new RuntimeException("no script named " + this.script);
        }
        ScriptType scriptType = scriptService.getScriptType(s.getLocation());
        IScriptEngine engine = scriptService.getEngine(scriptType.getName()).createEngine();
        engine.setErrorStream((OutputStream)log.error());
        engine.setOutputStream((OutputStream)log.info());
        engine.setCloseStreamsOnTerminate(false);
        ScriptResult result = engine.execute(s.getResource());
        result.get();
    }

    public String toString() {
        return "EASE: " + this.script;
    }
}

