/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ie;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.actf.model.dom.dombycom.DomByCom;
import org.eclipse.actf.model.dom.dombycom.IElementEx;
import org.eclipse.actf.model.dom.html.HTMLParserFactory;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.internal.ui.editors.ie.BrowserIE_Plugin;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserIEComposite;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserIEScrollManager;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserStyleInfoImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserToolbar;
import org.eclipse.actf.model.internal.ui.editors.ie.events.BeforeNavigate2Parameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.BrowserEventListener;
import org.eclipse.actf.model.internal.ui.editors.ie.events.DocumentCompleteParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.INewWiondow2EventListener;
import org.eclipse.actf.model.internal.ui.editors.ie.events.IWindowClosedEventListener;
import org.eclipse.actf.model.internal.ui.editors.ie.events.NavigateComplete2Parameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.NavigateErrorParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.NewWindow2Parameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.ProgressChangeParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.StatusTextChangeParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.TitleChangeParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.events.WindowClosingParameters;
import org.eclipse.actf.model.internal.ui.editors.ie.win32.RegistryUtilIE;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.IModelServiceScrollManager;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.model.ui.ModelServiceSizeInfo;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserStyleInfo;
import org.eclipse.actf.model.ui.editor.browser.WebBrowserEventUtil;
import org.eclipse.actf.model.ui.util.ScrollBarSizeUtil;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebBrowserIEImpl
implements IWebBrowserACTF,
BrowserEventListener {
    private WebBrowserToolbar toolbar;
    private WebBrowserIEComposite browserComposite;
    private boolean _inNavigation = false;
    private boolean _inReload = false;
    private boolean _inStop = false;
    private boolean _inJavascript = false;
    private boolean _urlExist;
    private int _navigateErrorCode;
    private IModelServiceHolder _holder = null;
    private boolean onloadPopupBlock = true;
    private IModelServiceScrollManager scrollManager;
    private DomByCom domByCom;
    private INewWiondow2EventListener newWindow2EventListener = null;
    private IWindowClosedEventListener windowClosedEventListener = null;
    private String errorUrl = null;
    private int tmpErrorCode = 0;

    public WebBrowserIEImpl(IModelServiceHolder iModelServiceHolder, Composite composite, String string) {
        this._holder = iModelServiceHolder;
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        composite2.setSize(0, 0);
        composite2.redraw();
        composite2.setVisible(false);
        composite2.setLayoutData((Object)new GridData(0, 0));
        Browser browser = new Browser(composite2, 0);
        browser.setVisible(false);
        this.toolbar = new WebBrowserToolbar(this, composite, 0);
        this.browserComposite = new WebBrowserIEComposite(composite, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.verticalSpacing = 0;
        gridLayout2.horizontalSpacing = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        this.browserComposite.setLayout((Layout)gridLayout2);
        this.browserComposite.setLayoutData(new GridData(1808));
        if (string == null) {
            string = "about:blank";
        }
        this.toolbar.setAddressTextString(string);
        this.setDisableScriptDebugger(true);
        this.browserComposite.addBrowserEventListener(this);
        this.scrollManager = new WebBrowserIEScrollManager(this);
        this.domByCom = new DomByCom((long)this.getBrowserAddress());
        this.navigate(string);
    }

    public void setFocusAddressText(boolean bl) {
        this.toolbar.setFocusToAddressText(bl);
    }

    public void showAddressText(boolean bl) {
        this.toolbar.showAddressText(bl);
    }

    public void navigate(String string) {
        this.toolbar.setAddressTextString(string);
        this.errorUrl = null;
        this._urlExist = true;
        this._navigateErrorCode = 200;
        this.browserComposite.navigate(string);
    }

    public void goBackward() {
        this.errorUrl = null;
        this.browserComposite.goBack();
    }

    public void goForward() {
        this.errorUrl = null;
        this.browserComposite.goForward();
    }

    public void navigateStop() {
        if (this._inNavigation || this._inReload) {
            this._inStop = true;
            this._inNavigation = false;
            this._inReload = false;
            this._inJavascript = false;
        }
        this.errorUrl = null;
        this.browserComposite.stop();
    }

    public void navigateRefresh() {
        if (!this._inReload) {
            this._inReload = true;
            this._inJavascript = false;
            WebBrowserEventUtil.refreshStart((IWebBrowserACTF)this);
        }
        this.errorUrl = null;
        this.browserComposite.refresh();
    }

    public ModelServiceSizeInfo getBrowserSize(boolean bl) {
        int[] nArray;
        int[] nArray2 = new int[]{1, 1, 1, 1};
        int n = this.browserComposite.getWidth() - 4;
        int n2 = this.browserComposite.getHeight() - 4;
        int n3 = ScrollBarSizeUtil.getVerticalBarWidth();
        nArray2[0] = n - n3;
        nArray2[1] = n2;
        nArray2[2] = n - n3;
        nArray2[3] = n2;
        if (bl && (nArray = this.browserComposite.getWholeSize()).length == 2 && nArray[0] > -1 && nArray[1] > -1) {
            nArray2[2] = nArray[0];
            nArray2[3] = nArray[1];
            if (nArray[0] > nArray2[0]) {
                nArray2[1] = nArray2[1] - n3;
            }
        }
        return new ModelServiceSizeInfo(nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
    }

    public int getReadyState() {
        return this.browserComposite.getReadyState();
    }

    public boolean isReady() {
        return this.getReadyState() == 4;
    }

    public String getURL() {
        return this.browserComposite.getLocationURL();
    }

    public String getLocationName() {
        return this.browserComposite.getLocationName();
    }

    public boolean isUrlExists() {
        return this._urlExist;
    }

    public int getNavigateErrorCode() {
        return this._navigateErrorCode;
    }

    public IModelServiceScrollManager getScrollManager() {
        return this.scrollManager;
    }

    public void scrollY(int n) {
        this.browserComposite.scroll(0, n, 0);
    }

    public void scrollTo(int n, int n2) {
        this.browserComposite.scroll(n, n2, 1);
    }

    public void setHlinkStop(boolean bl) {
    }

    public void setWebBrowserSilent(boolean bl) {
        this.browserComposite.setSilent(bl);
    }

    public void setDisableScriptDebugger(boolean bl) {
        this.browserComposite.setDisableScriptDebugger(bl);
    }

    public void setDisplayImage(boolean bl) {
    }

    public boolean isDisableScriptDebugger() {
        return this.browserComposite.getDisableScriptDebugger();
    }

    public void setFontSize(int n) {
        this.browserComposite.setFontSize(n);
    }

    public int getFontSize() {
        return this.browserComposite.getFontSize();
    }

    public void highlightElementById(String string) {
    }

    public void hightlightElementByAttribute(String string, String string2) {
    }

    public void clearHighlight() {
    }

    RGB getAnchorColor() {
        String string = RegistryUtilIE.getIERegistryString("Anchor Color");
        return this.getRGB(string);
    }

    RGB getVisitedAnchorColor() {
        String string = RegistryUtilIE.getIERegistryString("Anchor Color Visited");
        return this.getRGB(string);
    }

    private RGB getRGB(String string) {
        if (string != null) {
            try {
                String[] stringArray = string.split(",");
                return new RGB(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public int getBrowserAddress() {
        return this.browserComposite.getBrowserAddress();
    }

    public String[] getSupportMIMETypes() {
        return MIMETYPES_HTML;
    }

    public String[] getSupportExtensions() {
        return EXTS_HTML;
    }

    public void open(String string) {
        this.navigate(string);
    }

    public void open(File file) {
        if (file != null) {
            this.navigate(file.getAbsolutePath());
        }
    }

    public Document getDocument() {
        try {
            File file = BrowserIE_Plugin.getDefault().createTempFile("actf", "html");
            this.saveOriginalDocument(file.getAbsolutePath());
            IHTMLParser iHTMLParser = HTMLParserFactory.createHTMLParser();
            iHTMLParser.parse((InputStream)new FileInputStream(file));
            file.delete();
            return iHTMLParser.getDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Document getLiveDocument() {
        return this.domByCom.getDocument();
    }

    public Composite getTargetComposite() {
        return this.browserComposite;
    }

    public File saveDocumentAsHTMLFile(String string) {
        boolean bl;
        if (string != null && (bl = this.browserComposite.saveLiveDom(string))) {
            return new File(string);
        }
        return null;
    }

    public File saveOriginalDocument(String string) {
        if (string != null) {
            if ("about:blank".equals(this.getURL())) {
                try {
                    FileWriter fileWriter = new FileWriter(string);
                    fileWriter.write("<html></html>");
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (Exception exception) {
                    return null;
                }
                return new File(string);
            }
            boolean bl = this.browserComposite.save(string);
            if (bl) {
                return new File(string);
            }
        }
        return null;
    }

    public void jumpToNode(Node node) {
    }

    public String getCurrentMIMEType() {
        return MIMETYPES_HTML[0];
    }

    public void beforeNavigate2(BeforeNavigate2Parameters beforeNavigate2Parameters) {
        String string = beforeNavigate2Parameters.getUrl();
        DebugPrintUtil.debugPrintln((Object)("BN: " + string + " " + beforeNavigate2Parameters.getTargetFrameName()));
        if (!this._inReload) {
            if (!string.startsWith("javascript")) {
                this._inJavascript = false;
                this._inNavigation = true;
                this._inReload = false;
            } else {
                this._inJavascript = true;
                this._inNavigation = false;
                this._inReload = false;
            }
        }
        WebBrowserEventUtil.beforeNavigate((IWebBrowserACTF)this, (String)string, (String)beforeNavigate2Parameters.getTargetFrameName(), (boolean)this._inNavigation);
    }

    public void documentComplete(DocumentCompleteParameters documentCompleteParameters) {
        if (documentCompleteParameters.isTopWindow()) {
            if (this.errorUrl != null && this.errorUrl.equals(documentCompleteParameters.getUrl())) {
                this._navigateErrorCode = this.tmpErrorCode;
                this._urlExist = false;
                this._inNavigation = false;
            }
            WebBrowserEventUtil.rootDocumentComplete((IWebBrowserACTF)this);
            this._inNavigation = false;
            this._inJavascript = false;
            this._inReload = false;
            this.errorUrl = null;
        }
    }

    public void navigateComplete2(NavigateComplete2Parameters navigateComplete2Parameters) {
        WebBrowserEventUtil.navigateComplete((IWebBrowserACTF)this, (String)navigateComplete2Parameters.getUrl());
        this.toolbar.setAddressTextString(this.browserComposite.getLocationURL());
        DebugPrintUtil.debugPrintln((Object)"NavigateComplete2");
    }

    public void navigateError(NavigateErrorParameters navigateErrorParameters) {
        String string = navigateErrorParameters.getUrl();
        this.tmpErrorCode = navigateErrorParameters.getStatusCode();
        DebugPrintUtil.debugPrintln((Object)("Navigate Error. URL:" + string + " Status Code:" + this.tmpErrorCode + " " + this.browserComposite.getLocationURL()));
        if (this.browserComposite.getLocationURL().equals(string)) {
            this._navigateErrorCode = this.tmpErrorCode;
            this._urlExist = false;
            this._inNavigation = false;
        } else {
            this.errorUrl = string;
        }
    }

    public void newWindow2(NewWindow2Parameters newWindow2Parameters) {
        if (this._inNavigation && this.onloadPopupBlock) {
            newWindow2Parameters.setCancel(true);
        } else if (this.newWindow2EventListener != null) {
            this.newWindow2EventListener.newWindow2(newWindow2Parameters);
        }
    }

    public void progressChange(ProgressChangeParameters progressChangeParameters) {
        int n = progressChangeParameters.getProgress();
        int n2 = progressChangeParameters.getProgressMax();
        WebBrowserEventUtil.progressChange((IWebBrowserACTF)this, (int)n, (int)n2);
        DebugPrintUtil.debugPrintln((Object)("Stop: " + this._inStop + " Reload: " + this._inReload + " inJavaScript: " + this._inJavascript + " navigation: " + this._inNavigation));
        if (this._inStop) {
            if (n == 0 && n2 == 0) {
                this._inStop = false;
                DebugPrintUtil.debugPrintln((Object)"stop fin");
                WebBrowserEventUtil.navigateStop((IWebBrowserACTF)this);
            }
        } else if (this._inReload) {
            if (n == 0 && n2 == 0) {
                this._inReload = false;
                DebugPrintUtil.debugPrintln((Object)"reload fin");
                WebBrowserEventUtil.refreshComplete((IWebBrowserACTF)this);
            }
        } else if (this._inJavascript) {
            if (n == -1 && n2 == -1) {
                this._inJavascript = false;
                DebugPrintUtil.debugPrintln((Object)"javascript fin");
            }
        } else if (!(this._inNavigation || n == 0 && n2 == 0)) {
            this._inReload = true;
            DebugPrintUtil.debugPrintln((Object)"reload");
            WebBrowserEventUtil.refreshStart((IWebBrowserACTF)this);
        }
    }

    public void statusTextChange(StatusTextChangeParameters statusTextChangeParameters) {
    }

    public void titleChange(TitleChangeParameters titleChangeParameters) {
        try {
            String string = titleChangeParameters.getText();
            WebBrowserEventUtil.titleChange((IWebBrowserACTF)this, (String)string);
            DebugPrintUtil.debugPrintln((Object)"TitleChange");
            if (!(this._inNavigation || this._inStop || this._inReload)) {
                this._inReload = true;
                this._inJavascript = false;
                DebugPrintUtil.debugPrintln((Object)"reload");
                WebBrowserEventUtil.refreshStart((IWebBrowserACTF)this);
            }
            this._holder.setEditorTitle(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void windowClosing(WindowClosingParameters windowClosingParameters) {
    }

    public void windowClosed() {
        if (this.windowClosedEventListener != null) {
            this.windowClosedEventListener.windowClosed();
        }
    }

    public Object getAttribute(String string) {
        return null;
    }

    public String getID() {
        return String.valueOf(WebBrowserIEImpl.class.getName()) + ":" + this;
    }

    public String getTitle() {
        return this.getLocationName();
    }

    public void setNewWindow2EventListener(INewWiondow2EventListener iNewWiondow2EventListener) {
        this.newWindow2EventListener = iNewWiondow2EventListener;
    }

    public void setWindowClosedEventListener(IWindowClosedEventListener iWindowClosedEventListener) {
        this.windowClosedEventListener = iWindowClosedEventListener;
    }

    public ImagePositionInfo[] getAllImagePosition() {
        NodeList nodeList = this.getLiveDocument().getElementsByTagName("img");
        ArrayList<ImagePositionInfo> arrayList = new ArrayList<ImagePositionInfo>();
        int n = 0;
        while (n < nodeList.getLength()) {
            try {
                IElementEx iElementEx = (IElementEx)nodeList.item(n);
                arrayList.add(new ImagePositionInfo(iElementEx.getLocation(), iElementEx.getAttribute("src"), (Element)iElementEx));
            }
            catch (Exception exception) {}
            ++n;
        }
        ImagePositionInfo[] imagePositionInfoArray = new ImagePositionInfo[arrayList.size()];
        arrayList.toArray(imagePositionInfoArray);
        return imagePositionInfoArray;
    }

    public IModelServiceHolder getModelServiceHolder() {
        return this._holder;
    }

    public IWebBrowserStyleInfo getStyleInfo() {
        return new WebBrowserStyleInfoImpl(this);
    }

    public boolean clearInterval(int n) {
        return this.browserComposite.clearInterval(n);
    }

    public boolean clearTimeout(int n) {
        return this.browserComposite.clearTimeout(n);
    }

    public int setInterval(String string, int n) {
        return this.browserComposite.setInterval(string, n);
    }

    public int setTimeout(String string, int n) {
        return this.browserComposite.setTimeout(string, n);
    }
}

