/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ooo;

import org.eclipse.actf.model.internal.ui.editors.ooo.OOoEditorPlugin;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.util.ModelServiceMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class OOoEditorToolbar
extends Composite {
    private Text _addressText;
    private boolean _isFocusOnText;
    private IModelService modelService;

    public OOoEditorToolbar(IModelService iModelService, Composite composite, int n, boolean bl) {
        super(composite, n);
        this.modelService = iModelService;
        this.setLayoutData(new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 1;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        this.initLayout(bl);
    }

    private void initLayout(boolean bl) {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(" " + ModelServiceMessages.WebBrowser_Address);
        label.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.stateMask == 65536 && (traverseEvent.character == 'd' || traverseEvent.character == 'D')) {
                    OOoEditorToolbar.this._addressText.setFocus();
                    OOoEditorToolbar.this._addressText.selectAll();
                }
            }
        });
        this._addressText = new Text((Composite)this, 2052);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this._addressText.setLayoutData((Object)gridData);
        this._addressText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                OOoEditorToolbar.this._isFocusOnText = false;
            }

            public void focusGained(FocusEvent focusEvent) {
                OOoEditorToolbar.this._addressText.selectAll();
            }
        });
        this._addressText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (!OOoEditorToolbar.this._isFocusOnText) {
                    OOoEditorToolbar.this._addressText.selectAll();
                    OOoEditorToolbar.this._isFocusOnText = true;
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                OOoEditorToolbar.this._addressText.selectAll();
            }
        });
        this._addressText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\r') {
                    OOoEditorToolbar.this.modelService.open(OOoEditorToolbar.this._addressText.getText());
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        ToolBar toolBar = new ToolBar((Composite)this, 131072);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        Action action = new Action(ModelServiceMessages.WebBrowser_Go, OOoEditorPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.model.ui", (String)"icons/browser/go.png")){

            public void run() {
                if (OOoEditorToolbar.this.modelService != null && OOoEditorToolbar.this._addressText != null) {
                    OOoEditorToolbar.this.modelService.open(OOoEditorToolbar.this._addressText.getText());
                }
            }
        };
        action.setToolTipText(ModelServiceMessages.WebBrowser_Go_tp);
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)action);
        actionContributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolBarManager.add((IContributionItem)actionContributionItem);
        toolBarManager.update(true);
    }

    public Text getAddressText() {
        return this._addressText;
    }
}

