/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.eval.guideline;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.IGuidelineItem;
import org.eclipse.actf.visualization.eval.ITechniquesItem;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.actf.visualization.internal.eval.EvaluationItemImpl;
import org.eclipse.actf.visualization.internal.eval.guideline.MetricsItem;
import org.eclipse.actf.visualization.internal.eval.guideline.MetricsNameComparator;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckItemReader
extends DefaultHandler {
    private static final String CHECKER_CONFIG = "checker-config";
    private static final String CHECK_ITEM = "checkitem";
    private static final String GUIDELINE = "guideline";
    private static final String GITEM = "gItem";
    private static final String MITEM = "mItem";
    private static final String DESC = "desc";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String METRICS = "metrics";
    private static final String SCORE = "score";
    private static final String DESCRIPTION = "description";
    private static final String TECHNIQUS = "techniques";
    private static final short IN_DEFAULT = 0;
    private static final short IN_GUIDELINE = 1;
    private static final short IN_METRICS = 2;
    private static final short IN_DESCRIPTION = 3;
    private HashMap<String, IEvaluationItem> checkItemMap = new HashMap();
    private Stack<Short> statusStack = new Stack();
    private String curValue = "";
    private EvaluationItemImpl curItem = new EvaluationItemImpl("", "");
    private short status = (short)-1;
    private boolean succeed = false;
    private GuidelineHolder guidelineHolder;
    private Vector<IGuidelineItem> guidelineV = new Vector();
    private Vector<ITechniquesItem[]> techniquesV = new Vector();
    private IGuidelineData[] guidelines = new IGuidelineData[0];
    private Set<String> metricsSet = new TreeSet<String>(new MetricsNameComparator());
    private Vector<MetricsItem> metricsV = new Vector();

    public static CheckItemReader parse(InputStream inputStream, GuidelineHolder guidelineHolder) {
        CheckItemReader checkItemReader = new CheckItemReader(guidelineHolder);
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)checkItemReader);
        }
        catch (Exception exception) {}
        return checkItemReader;
    }

    public CheckItemReader(GuidelineHolder guidelineHolder) {
        this.guidelineHolder = guidelineHolder;
        this.guidelines = guidelineHolder.getGuidelineData();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (n2 > 0) {
            this.curValue = String.valueOf(this.curValue) + new String(cArray, n, n2);
        }
    }

    @Override
    public void endDocument() {
        this.succeed = true;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (!(string3.equals(GITEM) || string3.equals(MITEM) || string3.equals(DESC))) {
            if (string3.equals(CHECK_ITEM)) {
                this.checkItemMap.put(this.curItem.getId(), this.curItem);
                if (!this.statusStack.isEmpty()) {
                    this.status = this.statusStack.pop();
                }
            } else if (string3.equals(GUIDELINE)) {
                this.curItem.setGuidelines(this.guidelineV.toArray(new IGuidelineItem[this.guidelineV.size()]));
                this.curItem.setTechniques((ITechniquesItem[][])this.techniquesV.toArray((T[])new ITechniquesItem[this.techniquesV.size()][]));
                if (!this.statusStack.isEmpty()) {
                    this.status = this.statusStack.pop();
                }
            } else if (string3.equals(METRICS)) {
                MetricsItem[] metricsItemArray = new MetricsItem[this.metricsV.size()];
                this.metricsV.toArray(metricsItemArray);
                this.curItem.setMetrics(metricsItemArray);
                if (!this.statusStack.isEmpty()) {
                    this.status = this.statusStack.pop();
                }
            } else if (string3.equals(DESCRIPTION)) {
                if (!this.statusStack.isEmpty()) {
                    this.status = this.statusStack.pop();
                }
            } else if (!string3.equals(CHECKER_CONFIG)) {
                DebugPrintUtil.devOrDebugPrintln((Object)("unknown element(end): " + string3));
            }
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.curValue = "";
        if (string3.equals(GITEM)) {
            IGuidelineItem iGuidelineItem = this.guidelineHolder.getGuidelineItem(this.getValue(NAME, attributes, true), this.getValue(ID, attributes, true));
            if (iGuidelineItem != null) {
                this.guidelineV.add(iGuidelineItem);
                String string4 = attributes.getValue(TECHNIQUS);
                if (string4 != null) {
                    Object object;
                    Object object2 = null;
                    IGuidelineData[] iGuidelineDataArray = this.guidelines;
                    int n = this.guidelines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object = iGuidelineDataArray[n2];
                        if (object.getGuidelineName().equals(iGuidelineItem.getGuidelineName())) {
                            object2 = object;
                            break;
                        }
                        ++n2;
                    }
                    object = string4.split(",");
                    Vector<ITechniquesItem> vector = new Vector<ITechniquesItem>();
                    Object object3 = object;
                    int n3 = ((Object)object3).length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object4 = object3[n4];
                        ITechniquesItem iTechniquesItem = object2.getTequniquesItem(((String)object4).trim());
                        if (iTechniquesItem != null) {
                            vector.add(iTechniquesItem);
                        }
                        ++n4;
                    }
                    this.techniquesV.add(vector.toArray(new ITechniquesItem[vector.size()]));
                } else {
                    this.techniquesV.add(new ITechniquesItem[0]);
                }
            }
        } else if (string3.equals(MITEM)) {
            String string5 = this.getValue(NAME, attributes, true);
            String string6 = this.getValue(SCORE, attributes, true);
            if (string5.length() > 0) {
                this.metricsSet.add(string5);
                this.metricsV.add(new MetricsItem(string5, string6));
            }
        } else if (string3.equals(CHECK_ITEM)) {
            this.curItem = new EvaluationItemImpl(this.getValue(ID, attributes), this.getValue(TYPE, attributes));
            this.statusStack.push(new Short(this.status));
            this.status = 0;
        } else if (string3.equals(GUIDELINE)) {
            this.guidelineV = new Vector();
            this.techniquesV = new Vector();
            this.statusStack.push(new Short(this.status));
            this.status = 1;
        } else if (string3.equals(METRICS)) {
            this.metricsV = new Vector();
            this.statusStack.push(new Short(this.status));
            this.status = (short)2;
        } else if (string3.equals(DESCRIPTION)) {
            this.statusStack.push(new Short(this.status));
            this.status = (short)3;
        } else {
            string3.equals(CHECKER_CONFIG);
        }
    }

    private String getValue(String string, Attributes attributes) {
        return this.getValue(string, attributes, false);
    }

    private String getValue(String string, Attributes attributes, boolean bl) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            string2 = "";
        }
        if (bl) {
            return string2.trim();
        }
        return string2;
    }

    public boolean isSucceed() {
        return this.succeed;
    }

    public HashMap<String, IEvaluationItem> getCheckItemMap() {
        return this.checkItemMap;
    }

    public Set<String> getMetricsSet() {
        return this.metricsSet;
    }
}

