/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.actf.util.httpproxy.core.IClientConnection;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.BifurcatedOutputStream;
import org.eclipse.actf.util.internal.httpproxy.core.ClientConnectionListener;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPRequestMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPRequestReader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseInMemoryMessage;
import org.eclipse.actf.util.internal.httpproxy.core.RequestDispatcher;
import org.eclipse.actf.util.internal.httpproxy.core.ServerConnection;
import org.eclipse.actf.util.internal.httpproxy.core.SocketTimeoutRetryOutputStream;

public abstract class ClientConnection
implements Runnable,
IClientConnection {
    private static final Logger LOGGER = Logger.getLogger(ClientConnection.class);
    private final ClientConnectionListener clientConnectionListener;
    private final int fQueueSize;
    private long fKeepAlive;
    private Socket fClientSocket;
    private InputStream fClientIn;
    private BufferedOutputStream fClientOut;
    private HTTPRequestReader fReader;
    private RequestDispatcher fDispatcher;
    private long fLastReadTime = 0L;
    private long fMessageSerial = 0L;
    private boolean isHandlingRequest;
    private String connectionName;

    protected void setConnectionName(String string) {
        this.connectionName = string;
    }

    protected int getQueueSize() {
        return this.fQueueSize;
    }

    protected ClientConnection(ClientConnectionListener clientConnectionListener, int n) {
        this.clientConnectionListener = clientConnectionListener;
        this.fQueueSize = n;
    }

    public void resetConnection() {
        try {
            if (this.fClientSocket != null) {
                if (this.fClientIn != null) {
                    this.fClientIn.close();
                }
                if (this.fClientOut != null) {
                    this.fClientOut.close();
                }
                if (!this.fClientSocket.isClosed()) {
                    this.fClientSocket.setSoLinger(true, 0);
                    this.fClientSocket.close();
                }
                this.fClientSocket = null;
            }
        }
        catch (IOException iOException) {
            this.WARNING("Failed to shut down a client output connection (IOException): " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    public String close() {
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("Shutdown a client socket: lastReadTime=" + this.fLastReadTime);
        }
        if (this.fDispatcher != null) {
            this.fDispatcher.close();
        }
        if (this.fClientSocket != null) {
            try {
                this.fClientSocket.shutdownInput();
                if (this.fClientIn != null) {
                    this.fClientIn.close();
                }
            }
            catch (IOException iOException) {
                this.WARNING("Failed to close a client connection (IOException): " + iOException.getMessage());
            }
        }
        String string = this.connectionName;
        this.connectionName = null;
        this.fClientSocket = null;
        this.fClientOut = null;
        this.fReader = null;
        this.fDispatcher = null;
        this.clientConnectionListener.connectionClosed(this);
        return string;
    }

    protected void initInternal(Socket socket, long l, int n, RequestDispatcher requestDispatcher) throws IOException {
        this.fClientSocket = socket;
        this.fClientSocket.setSoTimeout(n);
        this.fClientIn = socket.getInputStream();
        this.fClientOut = new BufferedOutputStream(new SocketTimeoutRetryOutputStream(socket.getOutputStream()));
        this.fKeepAlive = l;
        this.fReader = requestDispatcher.createHTTPRequestReader(this.fClientIn);
        this.isHandlingRequest = false;
        this.fDispatcher = requestDispatcher;
        this.fDispatcher.start();
        this.DEBUG("Initialized");
    }

    protected HTTPRequestMessage createHTTPRequestMessage(long l) {
        return new HTTPRequestMessage(l);
    }

    public Socket getClientSocket() {
        return this.fClientSocket;
    }

    public int getCurrentServerGroupIndex() {
        return this.clientConnectionListener.getCurrentServerGroupIndex();
    }

    public synchronized boolean isHandlingRequest() {
        return this.isHandlingRequest;
    }

    private synchronized void setHandlingRequest(boolean bl) {
        this.isHandlingRequest = bl;
        if (!this.isHandlingRequest) {
            this.notify();
        }
    }

    private synchronized void waitHandlingRequestFinish() throws InterruptedException {
        while (this.isHandlingRequest) {
            this.wait();
        }
    }

    protected void requestReceived(IHTTPRequestMessage iHTTPRequestMessage) {
    }

    public void sendResponse(long l, IHTTPResponseMessage iHTTPResponseMessage, boolean bl) throws InterruptedException, IOException, TimeoutException {
        if (this.fClientOut == null) {
            return;
        }
        if (!this.isHandlingRequest()) {
            System.err.println("*****INVALID STATE: response=" + iHTTPResponseMessage);
            System.exit(-1);
            return;
        }
        try {
            StringBuffer stringBuffer;
            if (LOGGER.isDebugEnabled()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("Send a response to the client: serial=").append(iHTTPResponseMessage.getSerial());
                stringBuffer.append(", tid=").append(iHTTPResponseMessage.getTid());
                this.DEBUG(stringBuffer.toString());
            }
            if (LOGGER.isDebugEnabled()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("Response arrived: tid=").append(iHTTPResponseMessage.getTid());
                stringBuffer.append(", msgSerial=").append(iHTTPResponseMessage.getSerial());
                stringBuffer.append("\n_______________________________________________________\n");
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    BifurcatedOutputStream bifurcatedOutputStream = new BifurcatedOutputStream(this.fClientOut, byteArrayOutputStream);
                    iHTTPResponseMessage.write(l, bifurcatedOutputStream);
                    byteArrayOutputStream.close();
                    stringBuffer.append(byteArrayOutputStream.toString());
                }
                catch (Exception exception) {}
                stringBuffer.append("\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
                this.DEBUG(stringBuffer.toString());
            } else {
                iHTTPResponseMessage.write(l, this.fClientOut);
            }
            this.fClientOut.flush();
            if (iHTTPResponseMessage.isConnectionToBeClosed()) {
                this.fClientSocket.shutdownOutput();
                throw new InterruptedException("This connection is no longer available.");
            }
        }
        finally {
            assert (this.isHandlingRequest());
            if (bl) {
                this.setHandlingRequest(false);
            }
        }
    }

    public void sendResponse(long l, IHTTPResponseMessage iHTTPResponseMessage) throws InterruptedException, TimeoutException, IOException {
        this.sendResponse(l, iHTTPResponseMessage, true);
    }

    public void sendResponse(IHTTPResponseMessage iHTTPResponseMessage) throws InterruptedException, IOException {
        try {
            this.sendResponse(0L, iHTTPResponseMessage);
        }
        catch (TimeoutException timeoutException) {
            throw new IOException("Timeout: " + timeoutException.getMessage());
        }
    }

    public void allowTunnel(IHTTPRequestMessage iHTTPRequestMessage, ServerConnection serverConnection, long l) throws InterruptedException, TimeoutException, IOException {
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("CONNECT to " + serverConnection.toString());
        }
        try {
            this.sendResponse(l, new HTTPResponseInMemoryMessage(iHTTPRequestMessage.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "200".getBytes(), "OK".getBytes(), IHTTPResponseMessage.EMPTY_BODY), false);
            TunnelThread tunnelThread = new TunnelThread(this.fClientIn, serverConnection.getOutputStream());
            TunnelThread tunnelThread2 = new TunnelThread(serverConnection.getInputStream(), this.fClientOut);
            this.DEBUG("Tunnel is started.");
            tunnelThread.start();
            tunnelThread2.start();
            tunnelThread.waitExit();
            tunnelThread2.waitExit();
            this.DEBUG("Tunnel is finished.");
        }
        finally {
            this.setHandlingRequest(false);
        }
    }

    public void rejectTunnel(IHTTPRequestMessage iHTTPRequestMessage, long l) throws InterruptedException, TimeoutException, IOException {
        this.sendResponse(l, new HTTPResponseInMemoryMessage(iHTTPRequestMessage.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "405".getBytes(), "Method Not Allowed".getBytes(), IHTTPResponseMessage.EMPTY_BODY));
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 10[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void DEBUG(String string, String string2) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append(": ");
            stringBuffer.append(string2);
            LOGGER.debug(stringBuffer.toString());
        }
    }

    private final void DEBUG(String string) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.connectionName).append(": ");
            stringBuffer.append(string);
            LOGGER.debug(stringBuffer.toString());
        }
    }

    private final void WARNING(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.connectionName).append(": ");
        stringBuffer.append(string);
        LOGGER.warning(stringBuffer.toString());
    }

    private class TunnelThread
    extends Thread {
        private byte[] buffer;
        private static final int DEFUALT_TUNNEL_BUFFER_SIZE = 1024;
        private InputStream is;
        private OutputStream os;
        private boolean exited;

        private synchronized void exit() {
            this.exited = true;
            this.notifyAll();
        }

        public synchronized void waitExit() {
            while (true) {
                try {
                    do {
                        this.wait();
                    } while (!this.exited);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public void run() {
            try {
                try {
                    int n;
                    while ((n = this.is.available()) >= 0) {
                        if (n > this.buffer.length) {
                            this.buffer = new byte[n];
                        }
                        if ((n = this.is.read(this.buffer)) >= 0) {
                            if (LOGGER.isDebugEnabled()) {
                                ClientConnection.this.DEBUG("----TUNNEL--->\n" + (n > 0 ? new String(this.buffer, 0, n) : "") + "\n----TUNNEL--->\n");
                            }
                            this.os.write(this.buffer, 0, n);
                            this.os.flush();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (Throwable throwable) {
                try {
                    this.is.close();
                    this.os.close();
                }
                catch (IOException iOException) {}
                this.exit();
                throw throwable;
            }
            try {
                this.is.close();
                this.os.close();
            }
            catch (IOException iOException) {}
            this.exit();
        }

        TunnelThread(InputStream inputStream, OutputStream outputStream) {
            this.is = inputStream;
            this.os = outputStream;
            this.buffer = new byte[1024];
            this.exited = false;
        }
    }
}

