/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy.ui.actions;

import org.eclipse.actf.model.flash.proxy.FlashCacheUtil;
import org.eclipse.actf.model.flash.proxy.internal.WSTR;
import org.eclipse.actf.model.flash.proxy.internal.WinInet;
import org.eclipse.actf.model.internal.flash.proxy.Messages;
import org.eclipse.actf.ui.util.ProgressContribution;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class DeleteCacheAction
implements IWorkbenchWindowActionDelegate {
    private static final int BUFFER_SIZE = 32768;
    private IWorkbenchWindow window;
    private static final String NEVER_DELETE = "|gif|jpg|jpeg|png|bmp|ico|pdf|txt|text|doc|xls|ppt|htm|html|shtml|jsp|asp|php|hta|htc|ashx|xml|css|js|vb|vbs|vbx|au|avi|mp3|aif|aiff|asf|asx|wm|wmv|wma|mid|exe|cab|zip|flv|";
    private boolean background = false;
    private ProgressContribution pc;
    private IStatusLineManager manager;

    public DeleteCacheAction() {
        this(false);
    }

    public DeleteCacheAction(boolean bl) {
        this.background = bl;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.window = iWorkbenchWindow;
    }

    public void run(IAction iAction) {
        try {
            FlashCacheUtil.cacheChecked = true;
            if (this.background) {
                this.initProgress();
                new Thread(new Runnable(){

                    public void run() {
                        DeleteCacheAction.this.deleteCacheEntries();
                        DeleteCacheAction.this.endProgress();
                    }
                }).start();
            } else if (this.window != null) {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.window.getShell());
                progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) {
                        int n = DeleteCacheAction.this.countCacheEntries();
                        iProgressMonitor.beginTask(Messages.proxy_deleting_cache, n);
                        DeleteCacheAction.this.deleteCacheEntries(iProgressMonitor, n);
                        iProgressMonitor.done();
                    }
                });
            } else {
                this.deleteCacheEntries();
            }
        }
        catch (Exception exception) {}
    }

    private void initProgress() {
        try {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DeleteCacheAction.this.getProgressContribution();
                    if (DeleteCacheAction.this.pc != null && DeleteCacheAction.this.manager != null) {
                        DeleteCacheAction.this.pc.setVisible(true);
                        DeleteCacheAction.this.pc.setText(Messages.DeleteCacheAction_0);
                        DeleteCacheAction.this.manager.update(true);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getProgressContribution() {
        String string = "actf.progress";
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IViewPart iViewPart = iWorkbenchWindow.getActivePage().getViewReferences()[0].getView(false);
        IViewSite iViewSite = iViewPart.getViewSite();
        IActionBars iActionBars = iViewSite.getActionBars();
        this.manager = iActionBars.getStatusLineManager();
        this.pc = (ProgressContribution)this.manager.find(string);
    }

    private void endProgress() {
        try {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (DeleteCacheAction.this.pc != null && DeleteCacheAction.this.manager != null) {
                        DeleteCacheAction.this.pc.setVisible(false);
                        DeleteCacheAction.this.manager.update(true);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void dispose() {
    }

    private int countCacheEntries() {
        int n = 1;
        int n2 = MemoryUtil.GlobalAlloc((int)32768);
        try {
            int[] nArray = new int[]{32768};
            MemoryUtil.MoveMemory((int)n2, (int[])nArray, (int)4);
            int n3 = WinInet.FindFirstUrlCacheEntryW(0, n2, nArray);
            if (n3 != 0) {
                do {
                    int[] nArray2 = new int[20];
                    MemoryUtil.MoveMemory((int[])nArray2, (int)n2, (int)(4 * nArray2.length));
                    if ((nArray2[3] & 0x300000) == 0) {
                        int n4;
                        String string = new WSTR(nArray2[2]).getString();
                        boolean bl = false;
                        if (string.indexOf(63) < 0 && -1 != (n4 = string.lastIndexOf(46))) {
                            String string2 = string.substring(n4 + 1).toLowerCase();
                            boolean bl2 = bl = -1 != NEVER_DELETE.indexOf("|" + string2 + "|");
                        }
                        if (!bl) {
                            ++n;
                        }
                    }
                    nArray[0] = 32768;
                } while (WinInet.FindNextUrlCacheEntryW(n3, n2, nArray));
                WinInet.FindCloseUrlCache(n3);
            }
        }
        finally {
            MemoryUtil.GlobalFree((int)n2);
        }
        return n;
    }

    private void deleteCacheEntries() {
        this.deleteCacheEntries(null, 0);
    }

    private void deleteCacheEntries(IProgressMonitor iProgressMonitor, int n) {
        int n2 = 0;
        int n3 = MemoryUtil.GlobalAlloc((int)32768);
        try {
            int[] nArray = new int[]{32768};
            MemoryUtil.MoveMemory((int)n3, (int[])nArray, (int)4);
            int n4 = WinInet.FindFirstUrlCacheEntryW(0, n3, nArray);
            if (n4 != 0) {
                while (iProgressMonitor == null || !iProgressMonitor.isCanceled()) {
                    int[] nArray2 = new int[20];
                    MemoryUtil.MoveMemory((int[])nArray2, (int)n3, (int)(4 * nArray2.length));
                    if ((nArray2[3] & 0x300000) == 0) {
                        int n5;
                        String string = new WSTR(nArray2[2]).getString();
                        boolean bl = false;
                        if (string.indexOf(63) < 0 && -1 != (n5 = string.lastIndexOf(46))) {
                            String string2 = string.substring(n5 + 1).toLowerCase();
                            boolean bl2 = bl = -1 != NEVER_DELETE.indexOf("|" + string2 + "|");
                        }
                        if (!bl) {
                            WSTR wSTR = new WSTR(nArray2[1]);
                            ++n2;
                            if (iProgressMonitor != null) {
                                iProgressMonitor.subTask(wSTR.getString());
                                iProgressMonitor.worked(1);
                            }
                            WinInet.DeleteUrlCacheEntryW(wSTR.getAddress());
                            if (this.background && n > 0) {
                                this.changeProgress(n2 * 100 / n);
                            }
                        }
                    }
                    nArray[0] = 32768;
                    if (!WinInet.FindNextUrlCacheEntryW(n4, n3, nArray)) break;
                }
                WinInet.FindCloseUrlCache(n4);
            }
        }
        finally {
            MemoryUtil.GlobalFree((int)n3);
        }
    }

    private void changeProgress(final int n) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (DeleteCacheAction.this.pc != null && DeleteCacheAction.this.manager != null) {
                    DeleteCacheAction.this.pc.setValue(n);
                    DeleteCacheAction.this.manager.update(true);
                }
            }
        });
    }
}

