/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.util.converter.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.ContentBaseElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.ODFElementImpl;
import org.eclipse.actf.model.dom.odf.content.IEditable;
import org.eclipse.actf.model.dom.odf.draw.FrameElement;
import org.eclipse.actf.model.dom.odf.draw.ImageElement;
import org.eclipse.actf.model.dom.odf.draw.PageElement;
import org.eclipse.actf.model.dom.odf.draw.TextBoxElement;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.office.PresentationElement;
import org.eclipse.actf.model.dom.odf.office.SpreadSheetElement;
import org.eclipse.actf.model.dom.odf.office.TextElement;
import org.eclipse.actf.model.dom.odf.presentation.NotesElement;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.style.DefaultStyleElement;
import org.eclipse.actf.model.dom.odf.style.FontFaceElement;
import org.eclipse.actf.model.dom.odf.style.GraphicPropertiesElement;
import org.eclipse.actf.model.dom.odf.style.ParagraphPropertiesElement;
import org.eclipse.actf.model.dom.odf.style.StyleElement;
import org.eclipse.actf.model.dom.odf.style.TableCellPropertiesElement;
import org.eclipse.actf.model.dom.odf.style.TableColumnPropertiesElement;
import org.eclipse.actf.model.dom.odf.style.TablePropertiesElement;
import org.eclipse.actf.model.dom.odf.style.TextPropertiesElement;
import org.eclipse.actf.model.dom.odf.table.TableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableColumnElement;
import org.eclipse.actf.model.dom.odf.table.TableColumnsElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.table.TableHeaderRowsElement;
import org.eclipse.actf.model.dom.odf.table.TableRowElement;
import org.eclipse.actf.model.dom.odf.text.AElement;
import org.eclipse.actf.model.dom.odf.text.ChangeElement;
import org.eclipse.actf.model.dom.odf.text.ChangeEndElement;
import org.eclipse.actf.model.dom.odf.text.ChangeStartElement;
import org.eclipse.actf.model.dom.odf.text.HElement;
import org.eclipse.actf.model.dom.odf.text.ListElement;
import org.eclipse.actf.model.dom.odf.text.ListItemElement;
import org.eclipse.actf.model.dom.odf.text.ListLevelStyleBulletElement;
import org.eclipse.actf.model.dom.odf.text.ListLevelStyleNumberElement;
import org.eclipse.actf.model.dom.odf.text.ListStyleElement;
import org.eclipse.actf.model.dom.odf.text.PElement;
import org.eclipse.actf.model.dom.odf.text.SElement;
import org.eclipse.actf.model.dom.odf.text.SequenceElement;
import org.eclipse.actf.model.dom.odf.text.SpanElement;
import org.eclipse.actf.model.dom.odf.text.TabElement;
import org.eclipse.actf.model.dom.odf.util.converter.ODFConverter;
import org.eclipse.actf.model.dom.odf.util.converter.impl.TextExtractorImpl;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLConverter
implements ODFConverter {
    private static final String HTML_ENCODING = "UTF8";
    private static final String ODF_CSS_FILE = "ODF.css";
    private static final String HTML_HEADER = "<html><head><META http-equiv='Content-Type' content='text/html; charset=UTF-8'/><meta content='text/html; charset=UTF-8' http-equiv='Content-type'/><title></title><link rel='stylesheet' type='text/css' href='ODF.css'/></head>";
    private double odfVersion = -1.0;
    private ODFElement curElem = null;
    private TextExtractorImpl textExtractor = new TextExtractorImpl();
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:style:1.0' and local-name()='default-style']");
    private static final Object EXP2 = xpathService.compile(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:style:1.0' and local-name()='style']");
    private static final Object EXP3 = xpathService.compile(".//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='list-style']");

    public void setDocument(ODFDocument oDFDocument) {
        this.curElem = (ODFElement)oDFDocument.getDocumentElement();
        this.textExtractor.setDocument(oDFDocument, this);
    }

    public void setOdfVersion(double d) {
        this.odfVersion = d;
        this.textExtractor.setOdfVersion(d);
    }

    private String getHTMLTagName(ODFElement oDFElement) {
        Object object;
        if (oDFElement instanceof ImageElement) {
            return "img";
        }
        if (oDFElement instanceof HElement) {
            int n = ((HElement)oDFElement).getAttrTextOutlineLevel();
            if (n > 6) {
                n = 6;
            }
            return "h" + n;
        }
        if (oDFElement instanceof ListElement) {
            object = ((ListElement)oDFElement).getListLevelStyleElement();
            if (object != null) {
                if (object instanceof ListLevelStyleBulletElement) {
                    return "ul";
                }
                if (object instanceof ListLevelStyleNumberElement) {
                    return "ol";
                }
            }
        } else if (oDFElement instanceof TableCellElement) {
            Node node = oDFElement.getParentNode();
            Node node2 = null;
            if (node != null) {
                node2 = node.getParentNode();
            }
            if (node != null && node instanceof TableRowElement && node2 != null && node2 instanceof TableHeaderRowsElement) {
                return "th";
            }
            return "td";
        }
        object = null;
        if (oDFElement instanceof PElement) {
            object = "p";
        }
        if (oDFElement instanceof AElement) {
            object = "a";
        }
        if (oDFElement instanceof SpanElement) {
            object = "span";
        }
        if (oDFElement instanceof TabElement) {
            object = "span";
        }
        if (oDFElement instanceof SequenceElement) {
            object = "span";
        }
        if (oDFElement instanceof SElement) {
            object = "span";
        }
        if (oDFElement instanceof ListItemElement) {
            object = "li";
        }
        if (oDFElement instanceof TableElement) {
            object = "table";
        }
        if (oDFElement instanceof TableHeaderRowsElement) {
            object = "thead";
        }
        if (oDFElement instanceof TableRowElement) {
            object = "tr";
        }
        if (oDFElement instanceof TableColumnsElement) {
            object = "colgroup";
        }
        if (oDFElement instanceof TableColumnElement) {
            object = "col";
        }
        if (oDFElement instanceof ChangeElement) {
            object = "span";
        }
        if (oDFElement instanceof ChangeStartElement) {
            object = "span";
        }
        if (oDFElement instanceof ChangeEndElement) {
            object = "span";
        }
        if (object == null) {
            object = "div";
        }
        return object;
    }

    private String getStyleClassName(ODFElement oDFElement) {
        String string = null;
        if (oDFElement instanceof ListElement) {
            ListElement listElement = ((ListElement)oDFElement).getTopLevelListElement();
            long l = ((ListElement)oDFElement).getListLevel();
            string = String.valueOf(listElement.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name")) + l;
        } else {
            NamedNodeMap namedNodeMap = oDFElement.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Node node = namedNodeMap.item(n);
                if ("style-name".equals(node.getLocalName())) {
                    string = string == null ? new String() : String.valueOf(string) + " ";
                    string = String.valueOf(string) + node.getNodeValue();
                }
                ++n;
            }
        }
        return string;
    }

    public boolean extractContent(Writer writer, File file, ODFElement oDFElement, boolean bl) {
        String string = this.getHTMLTagName(oDFElement);
        if (string != null) {
            String string2;
            try {
                writer.write("<" + string + " " + "odf-tagname" + "='" + oDFElement.getTagName() + "' id='" + oDFElement.getAttribute("actf-odf-content-id") + "' name='" + oDFElement.getAttribute("actf-odf-content-id") + "' " + "actf-odf-content-id" + "='" + oDFElement.getAttribute("actf-odf-content-id") + "'");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (bl && (string2 = this.getStyleClassName(oDFElement)) != null) {
                try {
                    writer.write(" class='" + string2 + "'");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (oDFElement instanceof ImageElement) {
                string2 = ((ImageElement)oDFElement).getAttrXlinkHref();
                if (!(string2.startsWith("http://") || string2.startsWith("https://") || string2.startsWith("file://") || string2.startsWith("chrome://"))) {
                    this.textExtractor.extractEmbedFile(oDFElement, file, string2);
                }
                try {
                    writer.write(" src='" + string2 + "'");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                ODFElement oDFElement2 = null;
                oDFElement2 = this.odfVersion != -1.0 ? ((ImageElement)oDFElement).getShortDescElement(this.odfVersion) : ((ImageElement)oDFElement).getShortDescElement();
                if (oDFElement2 != null) {
                    String string3 = (String)((IEditable)((Object)oDFElement2)).getValue();
                    if (string3 != null) {
                        try {
                            writer.write(" alt='" + string3 + "'");
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                } else {
                    FrameElement frameElement = ((ImageElement)oDFElement).getFrameElement();
                    if (frameElement != null) {
                        String string4;
                        String string5;
                        TextBoxElement textBoxElement = null;
                        textBoxElement = this.odfVersion != -1.0 ? frameElement.getBoundCaptionTextBoxElement(this.odfVersion) : frameElement.getBoundCaptionTextBoxElement();
                        if (textBoxElement != null && (string5 = textBoxElement.getTextContent()) != null) {
                            try {
                                writer.write(" alt=''");
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        if ((string5 = frameElement.getAttrSvgWidth()) == null) {
                            string5 = "auto";
                        }
                        if ((string4 = frameElement.getAttrSvgHeight()) == null) {
                            string4 = "auto";
                        }
                        try {
                            writer.write(" style='width:" + string5 + ";height:" + string4 + ";'");
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            } else if (oDFElement instanceof AElement) {
                string2 = ((AElement)oDFElement).getType();
                if ("simple".equals(string2)) {
                    String string6 = ((AElement)oDFElement).getHref();
                    if (string6.startsWith("#")) {
                        ODFElement oDFElement3 = ((AElement)oDFElement).getHrefElement();
                        if (oDFElement3 != null) {
                            try {
                                writer.write(" href='#" + oDFElement3.getAttribute("actf-odf-content-id") + "'");
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    } else {
                        try {
                            writer.write(" href='" + string6 + "'");
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            } else if (oDFElement instanceof TableColumnElement) {
                int n = ((TableColumnElement)oDFElement).getAttrTableNumberColumnsRepeated();
                if (n > 1) {
                    try {
                        writer.write(">");
                        writer.write("</" + string + ">\n");
                        int n2 = 1;
                        while (n2 < n) {
                            writer.write("<" + string + "/>\n");
                            ++n2;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return false;
                }
            } else if (oDFElement instanceof TableCellElement) {
                int n;
                int n3 = ((TableCellElement)oDFElement).getAttrTableNumberColumnsSpanned();
                if (n3 > 1) {
                    try {
                        writer.write(" colspan='" + n3 + "'");
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if ((n = ((TableCellElement)oDFElement).getAttrTableNumberColumnsRepeated()) > 1) {
                    try {
                        writer.write(">");
                        writer.write("</" + string + ">\n");
                        int n4 = 1;
                        while (n4 < n) {
                            writer.write("<" + string + "/>\n");
                            ++n4;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return false;
                }
            }
            try {
                writer.write(">");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        boolean bl2 = this.textExtractor.extractContent(writer, file, oDFElement, bl);
        if (string != null) {
            try {
                writer.write("</" + string + ">\n");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl2;
    }

    private void convertTextDoc(PrintWriter printWriter, File file, TextElement textElement, boolean bl) {
        Iterator<ITextElementContainer> iterator = textElement.getChildIterator();
        while (iterator.hasNext()) {
            ODFElement oDFElement = iterator.next();
            this.extractContent(printWriter, file, oDFElement, bl);
        }
    }

    private void convertSpreadsheetDoc(PrintWriter printWriter, File file, SpreadSheetElement spreadSheetElement, boolean bl) {
        int n = 0;
        while ((long)n < spreadSheetElement.getTableSize()) {
            TableElement tableElement = spreadSheetElement.getTable(n);
            printWriter.write("<h1>" + tableElement.getAttrTableName() + "</h1>");
            this.extractContent(printWriter, file, tableElement, bl);
            ++n;
        }
    }

    private void convertPresentationDoc(PrintWriter printWriter, File file, PresentationElement presentationElement, boolean bl) {
        int n = 0;
        while ((long)n < presentationElement.getPageSize()) {
            PageElement pageElement = presentationElement.getPage(n);
            printWriter.write("<div odf-tagname='" + pageElement.getTagName() + "' id='" + pageElement.getAttribute("actf-odf-content-id") + "' name='" + pageElement.getAttribute("actf-odf-content-id") + "' " + "actf-odf-content-id" + "='" + pageElement.getAttribute("actf-odf-content-id") + "'><h1>Page " + (n + 1) + "</h1>");
            List<ODFElement> list = pageElement.getChildNodesInNavOrder();
            int n2 = 0;
            while (n2 < list.size()) {
                Node node = list.get(n2);
                if (node instanceof ODFElement && !(node instanceof NotesElement)) {
                    this.extractContent(printWriter, file, (ODFElement)node, bl);
                }
                ++n2;
            }
            NotesElement notesElement = pageElement.getPresentationNotesElement();
            if (notesElement != null) {
                printWriter.write("<h2>Notes of Page " + (n + 1) + "</h2>");
                this.extractContent(printWriter, file, notesElement, bl);
            }
            printWriter.write("</div>");
            ++n;
        }
    }

    private void convertDocument(PrintWriter printWriter, File file, boolean bl) {
        if (this.curElem == null) {
            return;
        }
        Element element = this.curElem.getOwnerDocument().getDocumentElement();
        if (element instanceof DocumentContentElement) {
            printWriter.write(HTML_HEADER);
            printWriter.write("<body>");
            BodyElement bodyElement = ((DocumentContentElement)element).getBodyElement();
            ContentBaseElement contentBaseElement = bodyElement.getContent();
            ODFConstants.ContentType contentType = contentBaseElement.getContentType();
            if (contentType.equals((Object)ODFConstants.ContentType.WRITE) && contentBaseElement instanceof TextElement) {
                this.convertTextDoc(printWriter, file, (TextElement)contentBaseElement, bl);
            } else if (contentType.equals((Object)ODFConstants.ContentType.SPREADSHEET) && contentBaseElement instanceof SpreadSheetElement) {
                this.convertSpreadsheetDoc(printWriter, file, (SpreadSheetElement)contentBaseElement, bl);
            } else if (contentType.equals((Object)ODFConstants.ContentType.PRESENTATION) && contentBaseElement instanceof PresentationElement) {
                this.convertPresentationDoc(printWriter, file, (PresentationElement)contentBaseElement, bl);
            } else {
                new ODFException("invalid content element").printStackTrace();
            }
            printWriter.write("</body></html>");
        } else {
            new ODFException("invalid odf document").printStackTrace();
        }
    }

    private void writeCssValueByTextPropertiesElement(PrintWriter printWriter, StyleElement styleElement) {
        NodeList nodeList = styleElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-properties");
        int n = 0;
        while (n < nodeList.getLength()) {
            String[] stringArray;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            Object object;
            TextPropertiesElement textPropertiesElement = (TextPropertiesElement)nodeList.item(n);
            String string7 = textPropertiesElement.getAttrStyleFontName();
            if (string7 != null) {
                object = ((ODFElementImpl)((Object)styleElement)).findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-face", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", string7);
                if (object == null) {
                    object = ((ODFElementImpl)((Object)styleElement)).findElementByAttrValueFromStyleDoc("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-face", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", string7);
                }
                if (object != null) {
                    string6 = ((FontFaceElement)object).getAttrSvgFontFamily();
                    printWriter.write("font-family:" + string6 + ";");
                }
            }
            if ((object = textPropertiesElement.getAttrFormatFontSize()) != null) {
                printWriter.write("font-size:" + (String)object + ";");
            }
            if ((string6 = textPropertiesElement.getAttrFormatColor()) != null) {
                printWriter.write("color:" + string6 + ";");
            }
            if ((string5 = textPropertiesElement.getAttrFormatBackgroundColor()) != null) {
                printWriter.write("background-color:" + string5 + ";");
            }
            if ((string4 = textPropertiesElement.getAttrFormatFontWeight()) != null && string4.equals("bold")) {
                printWriter.write("font-weight:bold;");
            }
            if ((string3 = textPropertiesElement.getAttrFormatFontStyle()) != null && string3.equals("italic")) {
                printWriter.write("font-style:italic;");
            }
            if ((string2 = textPropertiesElement.getAttrStyleTextUnderlineStyle()) != null && string2.equals("solid")) {
                printWriter.write("text-decoration:underline;");
            }
            if ((string = textPropertiesElement.getAttrStyleTextPosition()) != null && (stringArray = string.split(" ")).length == 2) {
                if (stringArray[0].equals("super")) {
                    printWriter.write("vertical-align:super;");
                } else if (stringArray[0].equals("sub")) {
                    printWriter.write("vertical-align:sub;");
                }
                printWriter.write("font-size:" + stringArray[1] + ";");
            }
            ++n;
        }
    }

    private void writeCssValueByParagraphPropertiesElement(PrintWriter printWriter, StyleElement styleElement) {
        NodeList nodeList = styleElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "paragraph-properties");
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            ParagraphPropertiesElement paragraphPropertiesElement = (ParagraphPropertiesElement)nodeList.item(n);
            String string7 = paragraphPropertiesElement.getAttrFormatBackgroundColor();
            if (string7 != null) {
                printWriter.write("background-color:" + string7 + ";");
            }
            if ((string6 = paragraphPropertiesElement.getAttrFormatTextAlign()) != null) {
                printWriter.write("text-align:" + string6 + ";");
            }
            if ((string5 = paragraphPropertiesElement.getAttrStyleVerticalAlign()) != null) {
                printWriter.write("vertical-align:" + string5 + ";");
            }
            if ((string4 = paragraphPropertiesElement.getAttrFormatMarginLeft()) != null) {
                printWriter.write("margin-left:" + string4 + ";");
            }
            if ((string3 = paragraphPropertiesElement.getAttrFormatMarginRight()) != null) {
                printWriter.write("margin-right:" + string3 + ";");
            }
            if ((string2 = paragraphPropertiesElement.getAttrFormatMarginTop()) != null) {
                printWriter.write("margin-top:" + string2 + ";");
            }
            if ((string = paragraphPropertiesElement.getAttrFormatMarginBottom()) != null) {
                printWriter.write("margin-bottom:" + string + ";");
            }
            ++n;
        }
    }

    private void writeCssValueByGraphicPropertiesElement(PrintWriter printWriter, StyleElement styleElement) {
        NodeList nodeList = styleElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "graphic-properties");
        int n = 0;
        while (n < nodeList.getLength()) {
            GraphicPropertiesElement graphicPropertiesElement = (GraphicPropertiesElement)nodeList.item(n);
            String string = graphicPropertiesElement.getAttrStyleHorizontalPos();
            if (string != null) {
                if (string.equals("left")) {
                    printWriter.write("text-align:left;");
                } else if (string.equals("center")) {
                    printWriter.write("text-align:center;");
                } else if (string.equals("right")) {
                    printWriter.write("text-align:right;");
                }
            }
            ++n;
        }
    }

    private void writeCssValueByTablePropertiesElement(PrintWriter printWriter, StyleElement styleElement) {
        NodeList nodeList = styleElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-properties");
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            TablePropertiesElement tablePropertiesElement = (TablePropertiesElement)nodeList.item(n);
            String string2 = tablePropertiesElement.getAttrStyleWidth();
            if (string2 != null) {
                printWriter.write("width:" + string2 + ";");
            }
            if ((string = tablePropertiesElement.getAttrTableBorderModel()) != null) {
                if (string.equals("collapsing")) {
                    printWriter.write("border-collapse:collapse;");
                } else if (string.equals("separating")) {
                    printWriter.write("border-collapse:separate;");
                }
            }
            ++n;
        }
    }

    private void writeCssValueByTableColumnPropertiesElement(PrintWriter printWriter, StyleElement styleElement) {
        NodeList nodeList = styleElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-column-properties");
        int n = 0;
        while (n < nodeList.getLength()) {
            TableColumnPropertiesElement tableColumnPropertiesElement = (TableColumnPropertiesElement)nodeList.item(n);
            String string = tableColumnPropertiesElement.getAttrStyleColumnWidth();
            if (string != null) {
                printWriter.write("width:" + string + ";");
            }
            ++n;
        }
    }

    private void writeCssValueByTableCellPropertiesElement(PrintWriter printWriter, StyleElement styleElement) {
        NodeList nodeList = styleElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-cell-properties");
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            TableCellPropertiesElement tableCellPropertiesElement = (TableCellPropertiesElement)nodeList.item(n);
            String string7 = tableCellPropertiesElement.getAttrFormatBorder();
            if (string7 != null) {
                printWriter.write("border:" + string7 + ";");
            }
            if ((string6 = tableCellPropertiesElement.getAttrFormatBorderLeft()) != null) {
                printWriter.write("border-left:" + string6 + ";");
            }
            if ((string5 = tableCellPropertiesElement.getAttrFormatBorderRight()) != null) {
                printWriter.write("border-right:" + string5 + ";");
            }
            if ((string4 = tableCellPropertiesElement.getAttrFormatBorderTop()) != null) {
                printWriter.write("border-top:" + string4 + ";");
            }
            if ((string3 = tableCellPropertiesElement.getAttrFormatBorderBottom()) != null) {
                printWriter.write("border-bottom:" + string3 + ";");
            }
            if ((string2 = tableCellPropertiesElement.getAttrFormatBackgroundColor()) != null) {
                printWriter.write("background-color:" + string2 + ";");
            }
            if ((string = tableCellPropertiesElement.getAttrFormatPadding()) != null) {
                printWriter.write("padding:" + string + ";");
            }
            ++n;
        }
    }

    private void writeCssValueByStyleStyleElement(PrintWriter printWriter, StyleElement styleElement) {
        String string = styleElement.getAttrStyleParentStyleName();
        if (string != null) {
            ODFElement oDFElement = ((ODFElementImpl)((Object)styleElement)).findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", string);
            if (oDFElement == null) {
                oDFElement = ((ODFElementImpl)((Object)styleElement)).findElementByAttrValueFromStyleDoc("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", string);
            }
            if (oDFElement != null) {
                this.writeCssValueByStyleStyleElement(printWriter, (StyleElement)oDFElement);
            }
        }
        this.writeCssValueByTextPropertiesElement(printWriter, styleElement);
        this.writeCssValueByParagraphPropertiesElement(printWriter, styleElement);
        this.writeCssValueByGraphicPropertiesElement(printWriter, styleElement);
        this.writeCssValueByTablePropertiesElement(printWriter, styleElement);
        this.writeCssValueByTableColumnPropertiesElement(printWriter, styleElement);
        this.writeCssValueByTableCellPropertiesElement(printWriter, styleElement);
    }

    private void writeCssByStyleDefaultStyleElement(PrintWriter printWriter, ODFDocument oDFDocument) {
        Element element = oDFDocument.getDocumentElement();
        NodeList nodeList = xpathService.evalForNodeList(EXP1, (Node)element);
        int n = 0;
        while (n < nodeList.getLength()) {
            DefaultStyleElement defaultStyleElement = (DefaultStyleElement)nodeList.item(n);
            String string = defaultStyleElement.getAttrStyleFamily();
            if (string != null) {
                if (string.equals("paragraph")) {
                    printWriter.write("p {");
                } else if (string.equals("table")) {
                    printWriter.write("table {");
                } else if (string.equals("table-row")) {
                    printWriter.write("tr {");
                } else {
                    printWriter.write("." + string + " {");
                }
                this.writeCssValueByStyleStyleElement(printWriter, defaultStyleElement);
                printWriter.write("}\n");
            }
            ++n;
        }
    }

    private void writeCssByStyleStyleElement(PrintWriter printWriter, ODFDocument oDFDocument) {
        Element element = oDFDocument.getDocumentElement();
        NodeList nodeList = xpathService.evalForNodeList(EXP2, (Node)element);
        int n = 0;
        while (n < nodeList.getLength()) {
            StyleElement styleElement = (StyleElement)nodeList.item(n);
            String string = styleElement.getName();
            string = string.replaceAll("\\.", "\\\\\\.");
            printWriter.write("." + string + " {");
            this.writeCssValueByStyleStyleElement(printWriter, styleElement);
            printWriter.write("}\n");
            ++n;
        }
    }

    private void writeCssByListStyleElement(PrintWriter printWriter, ODFDocument oDFDocument) {
        Element element = oDFDocument.getDocumentElement();
        NodeList nodeList = xpathService.evalForNodeList(EXP3, (Node)element);
        int n = 0;
        while (n < nodeList.getLength()) {
            ListStyleElement listStyleElement = (ListStyleElement)nodeList.item(n);
            String string = listStyleElement.getName();
            string = string.replaceAll("\\.", "\\\\\\.");
            NodeList nodeList2 = listStyleElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "list-level-style-number");
            int n2 = 0;
            while (n2 < nodeList2.getLength()) {
                ListLevelStyleNumberElement listLevelStyleNumberElement = (ListLevelStyleNumberElement)nodeList2.item(n2);
                printWriter.write("." + string + listLevelStyleNumberElement.getAttrLevel() + " {");
                String string2 = listLevelStyleNumberElement.getAttrNumFormat();
                if (string2.equals("1")) {
                    printWriter.write("list-style-type:decimal;");
                } else if (string2.equals("i")) {
                    printWriter.write("list-style-type:lower-roman;");
                } else if (string2.equals("I")) {
                    printWriter.write("list-style-type:upper-roman;");
                } else if (string2.equals("a")) {
                    printWriter.write("list-style-type:lower-alpha;");
                } else if (string2.equals("A")) {
                    printWriter.write("list-style-type:upper-alpha;");
                }
                printWriter.write("}\n");
                ++n2;
            }
            ++n;
        }
    }

    private void writeCssFile(String string) {
        File file = new File(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, HTML_ENCODING);
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            ODFDocument oDFDocument = ((ODFDocument)this.curElem.getOwnerDocument()).getStyleDocument();
            this.writeCssByStyleDefaultStyleElement(printWriter, oDFDocument);
            this.writeCssByStyleStyleElement(printWriter, oDFDocument);
            ODFDocument oDFDocument2 = (ODFDocument)this.curElem.getOwnerDocument();
            this.writeCssByStyleStyleElement(printWriter, (ODFDocument)this.curElem.getOwnerDocument());
            this.writeCssByListStyleElement(printWriter, oDFDocument2);
            printWriter.flush();
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void convertDocument(String string, boolean bl) {
        Object object;
        File file = new File(string);
        String string2 = file.getParent();
        File file2 = new File(string2);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (bl) {
            object = String.valueOf(string2) + System.getProperty("file.separator") + ODF_CSS_FILE;
            this.writeCssFile((String)object);
        }
        try {
            object = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, HTML_ENCODING);
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            this.convertDocument(printWriter, file2, bl);
            printWriter.flush();
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }
}

