/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class BrowserFavoritesExtension {
    private static final String EXTENSION_NAME = "browserFavorites";
    private static final String FAVORITES = "favorites";
    private static final String ATTR_PREF_FILE = "prefFile";
    private static BrowserFavoritesExtension[] extensions;
    private static URL[] prefFileURLs;
    private URL prefFileUrl = null;

    static {
        prefFileURLs = null;
    }

    public static URL[] getBrowserFavoritesPrefFileURLs() {
        if (prefFileURLs != null) {
            return prefFileURLs;
        }
        BrowserFavoritesExtension[] browserFavoritesExtensionArray = BrowserFavoritesExtension.getExtensions();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (browserFavoritesExtensionArray != null) {
            int n = 0;
            while (n < browserFavoritesExtensionArray.length) {
                URL uRL = browserFavoritesExtensionArray[n].getPrefFileURL();
                if (uRL != null) {
                    arrayList.add(uRL);
                }
                ++n;
            }
        }
        prefFileURLs = new URL[arrayList.size()];
        arrayList.toArray(prefFileURLs);
        return prefFileURLs;
    }

    private static BrowserFavoritesExtension[] getExtensions() {
        if (extensions != null) {
            return extensions;
        }
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.model.ui", EXTENSION_NAME).getExtensions();
        DebugPrintUtil.devOrDebugPrintln((Object)(String.valueOf(BrowserFavoritesExtension.class.getName()) + ":" + iExtensionArray.length));
        ArrayList<BrowserFavoritesExtension> arrayList = new ArrayList<BrowserFavoritesExtension>();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                BrowserFavoritesExtension browserFavoritesExtension = BrowserFavoritesExtension.parseExtension(iConfigurationElementArray[n2]);
                if (browserFavoritesExtension != null) {
                    arrayList.add(browserFavoritesExtension);
                }
                ++n2;
            }
            ++n;
        }
        extensions = arrayList.toArray(new BrowserFavoritesExtension[arrayList.size()]);
        return extensions;
    }

    private static BrowserFavoritesExtension parseExtension(IConfigurationElement iConfigurationElement) {
        if (!iConfigurationElement.getName().equals(FAVORITES)) {
            return null;
        }
        try {
            return new BrowserFavoritesExtension(iConfigurationElement);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private BrowserFavoritesExtension(IConfigurationElement iConfigurationElement) {
        try {
            IContributor iContributor = iConfigurationElement.getContributor();
            String string = iConfigurationElement.getAttribute(ATTR_PREF_FILE);
            this.prefFileUrl = FileLocator.resolve((URL)Platform.getBundle((String)iContributor.getName()).getEntry(string));
        }
        catch (Exception exception) {
            DebugPrintUtil.devOrDebugPrintStackTrace((Exception)exception);
        }
    }

    private URL getPrefFileURL() {
        return this.prefFileUrl;
    }
}

