/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and Others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Tatsuya ISHIHARA - initial API and implementation
 *******************************************************************************/
package org.eclipse.actf.model.dom.odf.draw;

/**
 * DrawConstants defines the constant values used by drawing namespace of ODF DOM API
 */
@SuppressWarnings("nls")
public final class DrawConstants {
	static public final String DRAW_NAMESPACE_URI = "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0";

	static public final String ELEMENT_PAGE = "page";

	static public final String ELEMENT_FRAME = "frame";

	static public final String ELEMENT_OBJECT = "object";

	static public final String ELEMENT_OBJECT_OLE = "object-ole";

	static public final String ELEMENT_IMAGE = "image";

	static public final String ELEMENT_GRADIENT = "gradient";

	static public final String ELEMENT_HATCH = "hatch";

	static public final String ELEMENT_FILL_IMAGE = "fill-image";

	static public final String ELEMENT_OPACITY = "opacity";

	static public final String ELEMENT_STROKE_DASH = "stroke-dash";

	static public final String ELEMENT_IMAGE_MAP = "image-map";

	static public final String ELEMENT_AREA_CIRCLE = "area-circle";

	static public final String ELEMENT_AREA_POLYGON = "area-polygon";

	static public final String ELEMENT_AREA_RECTANGLE = "area-rectangle";

	static public final String ELEMENT_RECT = "rect";

	static public final String ELEMENT_LINE = "line";

	static public final String ELEMENT_POLYLINE = "polyline";

	static public final String ELEMENT_POLYGON = "polygon";

	static public final String ELEMENT_REGULAR_POLYGON = "regular-polygon";

	static public final String ELEMENT_PATH = "path";

	static public final String ELEMENT_CIRCLE = "circle";

	static public final String ELEMENT_ELLIPSE = "ellipse";

	static public final String ELEMENT_G = "g";

	static public final String ELEMENT_PAGE_THUMBNAIL = "page-thumbnail";

	static public final String ELEMENT_MEASURE = "measure";

	static public final String ELEMENT_CAPTION = "caption";

	static public final String ELEMENT_CONNECTOR = "connector";

	static public final String ELEMENT_CONTROL = "control";

	static public final String ELEMENT_CUSTOM_SHAPE = "custom-shape";

	static public final String ELEMENT_TEXT_BOX = "text-box";

	static public final String ATTR_Z_INDEX = "z-index";

	static public final String ATTR_NOTIFY_ON_UPDATE_OF_RANGES = "notify-on-update-of-ranges";

	static public final String ATTR_STROKE = "stroke";

	static public final String ATTR_STROKE_DASH = "stroke-dash";

	static public final String ATTR_MARKER_START_WIDTH = "marker-start-width";

	static public final String ATTR_MARKER_END_WIDTH = "marker-end-width";

	static public final String ATTR_OPACITY = "opacity";

	static public final String ATTR_OPACITY_NAME = "opacity-name";

	static public final String ATTR_FILL = "fill";

	static public final String ATTR_FILL_COLOR = "fill-color";

	static public final String ATTR_FILL_GRADIENT_NAME = "fill-gradient-name";

	static public final String ATTR_GRADIENT_STEP_COUNT = "gradient-step-count";

	static public final String ATTR_FILL_IMAGE_NAME = "fill-image-name";

	static public final String ATTR_FILL_IMAGE_WIDTH = "fill-image-width";

	static public final String ATTR_FILL_IMAGE_HEIGHT = "fill-image-height";

	static public final String ATTR_FILL_IMAGE_REF_POINT_X = "fill-image-ref-point-x";

	static public final String ATTR_FILL_IMAGE_REF_POINT_Y = "fill-image-ref-point-y";

	static public final String ATTR_FILL_IMAGE_REF_POINT = "fill-image-ref-point";

	static public final String ATTR_TILE_REPEAT_OFFSET = "tile-repeat-offset";

	static public final String ATTR_NAME = "name";

	static public final String ATTR_ID = "id";

	static public final String ATTR_DISPLAY_NAME = "display-name";

	static public final String ATTR_STYLE = "style";

	static public final String ATTR_STYLE_NAME = "style-name";

	static public final String ATTR_MASTER_PAGE_NAME = "master-page-name";

	static public final String ATTR_START_COLOR = "start-color";

	static public final String ATTR_END_COLOR = "end-color";

	static public final String ATTR_START_INTENSITY = "start-intensity";

	static public final String ATTR_END_INTENSITY = "end-intensity";

	static public final String ATTR_ANGLE = "angle";

	static public final String ATTR_BORDER = "border";

	static public final String ATTR_COLOR = "color";

	static public final String ATTR_DISTANCE = "distance";

	static public final String ATTR_ROTATION = "rotation";

	static public final String ATTR_START = "start";

	static public final String ATTR_END = "end";

	static public final String ATTR_DOTS1 = "dots1";

	static public final String ATTR_DOTS1_LENGTH = "dots1-length";

	static public final String ATTR_DOTS2 = "dots2";

	static public final String ATTR_DOTS2_LENGTH = "dots2-length";

	static public final String ATTR_CX = "cx";

	static public final String ATTR_CY = "cy";

	static public final String ATTR_BACKGROUND_SIZE = "background-size";

	static public final String ATTR_CONTROL = "control";

	static public final String ATTR_CAPTION_ID = "caption-id";

	static public final String ATTR_NAV_ORDER = "nav-order";
}