/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.util.Map;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.blind.TextCheckResult;
import org.eclipse.actf.visualization.engines.blind.TextChecker;
import org.eclipse.actf.visualization.engines.blind.html.VisualizeEngine;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.html.BlindProblem;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImgChecker {
    private static final String SRC = "src";
    private static final String ALT = "alt";
    private VisualizeMapDataImpl mapData;
    private Map<String, Element> mapMap;
    private TextChecker textChecker;
    private Vector<IProblemItem> problemV;
    private String baseUrl;
    private boolean[] checkItems;

    public ImgChecker(VisualizeMapDataImpl visualizeMapDataImpl, Map<String, Element> map, TextChecker textChecker, Vector<IProblemItem> vector, String string, boolean[] blArray) {
        this.mapData = visualizeMapDataImpl;
        this.mapMap = map;
        this.textChecker = textChecker;
        this.problemV = vector;
        this.baseUrl = string;
        this.checkItems = blArray;
    }

    public boolean checkAndReplaceImg(Element element, Document document, boolean bl) {
        Element element2 = null;
        NodeList nodeList = null;
        String string = element.getAttribute("usemap");
        if (string.length() > 0 && (element2 = this.mapMap.get(string.substring(1))) != null) {
            nodeList = element2.getElementsByTagName("area");
        }
        String string2 = this.checkAlt(element);
        if (bl) {
            Node node = element.getParentNode();
            Element element3 = document.createElement("span");
            element3.setAttribute("width", element.getAttribute("width"));
            element3.setAttribute("height", element.getAttribute("height"));
            element3.setAttribute("id", element.getAttribute("id"));
            element3.setAttribute("style", element.getAttribute("style"));
            boolean bl2 = true;
            VisualizationNodeInfo visualizationNodeInfo = this.mapData.getNodeInfo(element);
            if (visualizationNodeInfo != null) {
                bl2 = !visualizationNodeInfo.isInvisible();
            }
            element.removeAttribute("id");
            if (string2.length() > 0 && bl2) {
                element3.appendChild(document.createTextNode(string2));
            }
            node.insertBefore(element3, element);
            if (nodeList != null) {
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Object object;
                    Element element4 = document.createElement("span");
                    element4.setAttribute("style", element.getAttribute("style"));
                    element3.appendChild(element4);
                    Element element5 = (Element)nodeList.item(n2);
                    BlindProblem blindProblem = null;
                    Integer n3 = null;
                    element4.setAttribute("id", String.valueOf(element5.getAttribute("id")) + "-span");
                    if (!element5.hasAttribute(ALT)) {
                        if (element5.hasAttribute("href")) {
                            blindProblem = new BlindProblem(2, "map name=\"" + element2.getAttribute("name") + "\", href=\"" + element5.getAttribute("href") + "\".");
                            blindProblem.setTargetNode(this.mapData.getOrigNode(element5));
                        }
                    } else {
                        object = element5.getAttribute(ALT);
                        TextCheckResult textCheckResult = this.textChecker.checkAlt((String)object);
                        if (textCheckResult.equals((Object)TextCheckResult.SPACE_SEPARATED) || textCheckResult.equals((Object)TextCheckResult.SPACE_SEPARATED_JP)) {
                            blindProblem = new BlindProblem(31, (String)object);
                        }
                        if (blindProblem != null) {
                            blindProblem.setTargetNode(this.mapData.getOrigNode(element5));
                        }
                        element4.appendChild(document.createTextNode("[" + (String)object + ".] "));
                    }
                    if (blindProblem != null) {
                        n3 = this.mapData.getIdOfNode(element);
                        if (n3 != null) {
                            blindProblem.setNode(element5, n3);
                        } else {
                            blindProblem.setNode(element5);
                        }
                        this.problemV.add(blindProblem);
                        n3 = this.mapData.getIdOfNode(element5);
                        if (this.checkItems[blindProblem.getSubType()]) {
                            object = document.createElement("img");
                            object.setAttribute(ALT, "error icon");
                            object.setAttribute("title", blindProblem.getDescription());
                            if (n3 != null) {
                                object.setAttribute("onmouseover", "updateBaloon('id" + n3 + "');");
                            }
                            object.setAttribute(SRC, String.valueOf(this.baseUrl) + "img/" + VisualizeEngine.ERROR_ICON_NAME);
                            element4.appendChild((Node)object);
                        }
                    }
                    ++n2;
                }
            }
            this.mapData.addReplacedNodeMapping(element, element3);
            node.removeChild(element);
        }
        return true;
    }

    private String checkAlt(Element element) {
        Object object;
        boolean bl = false;
        String string = "";
        BlindProblem blindProblem = null;
        if (!element.hasAttribute(ALT)) {
            blindProblem = new BlindProblem(0, element.getAttribute(SRC));
            bl = true;
        } else {
            string = element.getAttribute(ALT);
            if (string.length() > 0) {
                object = this.textChecker.checkAlt(string, element.getAttribute(SRC));
                if (object.equals((Object)TextCheckResult.NG_WORD) || object.equals((Object)TextCheckResult.IMG_EXT)) {
                    blindProblem = new BlindProblem(27, string);
                } else if (object.equals((Object)TextCheckResult.SPACE_SEPARATED_JP)) {
                    blindProblem = new BlindProblem(29, string);
                } else if (object.equals((Object)TextCheckResult.SPACE_SEPARATED)) {
                    blindProblem = new BlindProblem(34, string);
                } else if (object.equals((Object)TextCheckResult.BLANK_NBSP)) {
                    blindProblem = new BlindProblem(38, string);
                } else if (!object.equals((Object)TextCheckResult.OK)) {
                    blindProblem = new BlindProblem(27, string);
                }
            }
        }
        if (blindProblem != null) {
            blindProblem.setTargetNode(this.mapData.getOrigNode(element));
            object = this.mapData.getIdOfNode(element);
            if (object != null) {
                blindProblem.setNode(element, object.intValue());
            } else {
                blindProblem.setNode(element);
            }
            this.problemV.add(blindProblem);
        }
        object = null;
        VisualizationNodeInfo visualizationNodeInfo = this.mapData.getNodeInfo(element);
        object = visualizationNodeInfo != null && visualizationNodeInfo.getPacket() != null ? visualizationNodeInfo.getPacket().getText() : (bl ? "" : string);
        return object;
    }

    private boolean isIgnoredByAT(Element element) {
        String string = element.getAttribute(ALT);
        return element.hasAttribute(ALT) && string.matches("[ \\u00A0]*");
    }
}

