/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.ui.scripteditor;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.EventManager;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.TimerEvent;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ScriptEditorTimerUtil
implements Runnable,
IUNIT {
    private static ScriptEditorTimerUtil ownInst = null;
    private static ScheduledExecutorService schedulerSynchronizeTimeLine = null;
    private static ScheduledFuture<?> futureSynchronizeTimeLine = null;
    private static EventManager eventManager = null;
    public static final int TL_SYNC_TIME_BASE = 10;
    private static Display display = null;

    public static synchronized ScriptEditorTimerUtil getInstance() {
        if (display == null) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        if (ownInst == null && display != null) {
            ownInst = new ScriptEditorTimerUtil();
            eventManager = EventManager.getInstance();
            schedulerSynchronizeTimeLine = Executors.newSingleThreadScheduledExecutor();
            futureSynchronizeTimeLine = schedulerSynchronizeTimeLine.scheduleAtFixedRate(ownInst, 0L, 10L, TimeUnit.MILLISECONDS);
            return ownInst;
        }
        return ownInst;
    }

    private ScriptEditorTimerUtil() {
        PlatformUIUtil.getActiveWindow().getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ScriptEditorTimerUtil.this.dispose();
            }
        });
    }

    @Override
    public void run() {
        try {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (eventManager != null) {
                        eventManager.fireTimerEvent(new TimerEvent(this));
                    }
                }
            });
        }
        catch (Exception e) {
            System.out.println("SynchronizeTimeLineTimer::run() : Exception = " + e);
        }
    }

    private void dispose() {
        if (futureSynchronizeTimeLine != null) {
            futureSynchronizeTimeLine.cancel(true);
            schedulerSynchronizeTimeLine.shutdownNow();
            futureSynchronizeTimeLine = null;
        }
        eventManager = null;
        ownInst = null;
    }
}

