/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.scripteditor.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.actf.ai.internal.ui.scripteditor.XMLFileMessageBox;
import org.eclipse.actf.ai.scripteditor.util.ResourceUtil;
import org.eclipse.actf.ai.scripteditor.util.TTMLUtil;
import org.eclipse.actf.ai.scripteditor.util.WebBrowserFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ExportHTMLAction
implements IWorkbenchWindowActionDelegate {
    private static final String[] NAMES = new String[]{"HTML (*.HTML)"};
    private static final String[] EXTENSIONS = new String[]{"*.html"};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportHTML(String filepath, String adFilename, boolean warnOverwrite) {
        String url;
        PrintWriter writer;
        block22: {
            block21: {
                XMLFileMessageBox warningExistFile;
                int ret;
                writer = null;
                File file = new File(filepath);
                if (!warnOverwrite || !file.exists() || (ret = (warningExistFile = new XMLFileMessageBox(2, filepath)).open()) == 64) break block21;
                if (writer == null) return;
                try {
                    writer.flush();
                    writer.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filepath), "UTF-8"));
            url = WebBrowserFactory.getInstance().getVideoURL();
            if (url != null) break block22;
            if (writer == null) return;
            try {
                writer.flush();
                writer.close();
                return;
            }
            catch (Exception exception) {}
            return;
        }
        try {
            try {
                int index1 = url.lastIndexOf(".");
                int index2 = url.lastIndexOf("/");
                int index3 = url.lastIndexOf("\\");
                if (index1 > 0 && index2 > 0 && index2 < index1 || index3 > 0 && index3 < index1) {
                    url = url.substring(0, index1);
                }
                if (url.startsWith("http")) {
                    if (index1 > 0 && index2 > 7 && index2 < index1) {
                        url = url.substring(0, index1);
                    }
                } else {
                    if (index1 > 0 && index2 > 0 && index2 < index1 || index3 > 0 && index3 < index1) {
                        url = url.substring(0, index1);
                    }
                    url = "file://" + url;
                }
                writer.println("<!DOCTYPE html>");
                writer.println("<html lang=\"en\">");
                writer.println("<head>");
                writer.println("<meta content=\"text/html; charset=utf-8\" http-equiv=content-type>");
                writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                writer.println("");
                writer.println("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=EmulateIE7; IE=EmulateIE9\">");
                writer.println("");
                writer.println("<title>Audio Description Template</title>");
                writer.println("");
                writer.println("<!-- HTML5 movie header start -->");
                writer.println("    <!--[if lt IE 9]>");
                writer.println("    <link rel=\"stylesheet\" href=\"resource/vd-player-ie.css\">");
                writer.println("    <script src=\"resource/vd-compat-ie.js\" defer></script>");
                writer.println("    <![endif]-->");
                writer.println("    <link rel=\"stylesheet\" href=\"resource/vd-player.css\">");
                writer.println("    <script src=\"resource/vd-compat.js\" defer></script>");
                writer.println("    <script src=\"resource/vd-player-en.js\" defer></script>");
                writer.println("<!-- HTML5 movie header end -->");
                writer.println("");
                writer.println("</head>");
                writer.println("<body>");
                writer.println("<div>");
                writer.println("");
                writer.println("<!-- HTML5 movie main start-->");
                writer.println("    <video width=\"320\" height=\"240\">");
                writer.println("        <source type=\"video/ogg\" src=\"" + url + ".ogv\">");
                writer.println("        <source type=\"video/mp4\" src=\"" + url + ".mp4\">");
                writer.println("        <source type=\"video/x-ms-wmv\" src=\"" + url + ".wmv\">");
                writer.println("        <track kind=\"metadata\" data-kind=\"descriptions\" src=\"" + adFilename + "\" srclang=\"en\" label=\"Audio Description\" default>");
                writer.println("    </video>");
                writer.println("<!-- HTML5 movie main end-->");
                writer.println("");
                writer.println("</div>");
                writer.println("</body>");
                writer.println("</html>");
            }
            catch (IOException e) {
                e.printStackTrace();
                if (writer == null) return;
                try {
                    writer.flush();
                    writer.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            if (writer == null) throw throwable;
            try {
                writer.flush();
                writer.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        if (writer == null) return;
        try {
            writer.flush();
            writer.close();
            return;
        }
        catch (Exception exception) {}
    }

    public void run(IAction action) {
        FileDialog saveDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        saveDialog.setFilterNames(NAMES);
        saveDialog.setFilterExtensions(EXTENSIONS);
        saveDialog.setFileName("audio_description_template.html");
        String saveFilepath = saveDialog.open();
        if (saveFilepath != null) {
            int last = saveFilepath.lastIndexOf(".html");
            String preRecordedFilepath = last > 0 ? String.valueOf(saveFilepath.substring(0, last)) + "_p.html" : String.valueOf(saveFilepath) + "_p.html";
            int index = saveFilepath.lastIndexOf(File.separator);
            String dirName = saveFilepath.substring(0, index + 1);
            String fileName = last > 0 ? saveFilepath.substring(index + 1, last) : saveFilepath.substring(index + 1);
            this.exportHTML(saveFilepath, String.valueOf(fileName) + "_ad.xml", true);
            this.exportHTML(preRecordedFilepath, String.valueOf(fileName) + "_ad_p.xml", false);
            File resourceDir = new File(String.valueOf(dirName) + "resource");
            resourceDir.mkdir();
            ResourceUtil.saveResources(String.valueOf(dirName) + "resource" + File.separator);
            File adFilesDir = new File(String.valueOf(dirName) + "ad_files");
            adFilesDir.mkdir();
            String adFilepath = String.valueOf(dirName) + fileName + "_ad.xml";
            TTMLUtil.exportTTML(adFilepath, false);
            adFilepath = String.valueOf(dirName) + fileName + "_ad_p.xml";
            TTMLUtil.exportTTMLandWAV(adFilepath, String.valueOf(dirName) + "ad_files" + File.separator, fileName, null, false);
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

