/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class SocketTimeoutRetryInputStream
extends FilterInputStream {
    public static int read(InputStream is) throws IOException {
        while (true) {
            try {
                return is.read();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public static int read(InputStream is, byte[] buf, int offset, int length) throws IOException {
        while (true) {
            try {
                return is.read(buf, offset, length);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public static int read(InputStream is, byte[] buf) throws IOException {
        while (true) {
            try {
                return is.read(buf);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public int available() throws IOException {
        while (true) {
            try {
                return this.in.available();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public void close() throws IOException {
        while (true) {
            try {
                this.in.close();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        return SocketTimeoutRetryInputStream.read(this.in);
    }

    public int read(byte[] buf) throws IOException {
        return SocketTimeoutRetryInputStream.read(this.in, buf);
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        return SocketTimeoutRetryInputStream.read(this.in, buf, offset, len);
    }

    public void reset() throws IOException {
        while (true) {
            try {
                this.in.reset();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public long skip(long n) throws IOException {
        while (true) {
            try {
                return this.in.skip(n);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    SocketTimeoutRetryInputStream(InputStream is) {
        super(is);
    }
}

