/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.flash;

import org.eclipse.actf.model.dom.dombycom.INodeExSound;
import org.eclipse.actf.model.flash.IASBridge;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashConst;

class FlashSoundImpl
implements INodeExSound,
IFlashConst {
    private int volBeforeMuted = -1;
    private final IASBridge player;
    private final IASNode target;

    FlashSoundImpl(IASNode node) {
        this.target = node;
        this.player = node.getPlayer();
    }

    public boolean muteMedia(boolean flag) {
        if (flag) {
            if (this.volBeforeMuted < 0) {
                this.volBeforeMuted = this.getVolume();
                return this.setVolume(0);
            }
        } else if (this.volBeforeMuted >= 0) {
            boolean success = this.setVolume(this.volBeforeMuted);
            this.volBeforeMuted = -1;
            return success;
        }
        return true;
    }

    public int getVolume() {
        Object o = this.player.callMethod(this.target, "getVolume");
        if (o instanceof Double) {
            return ((Double)o).intValue() * 10;
        }
        if (o instanceof Integer) {
            return (Integer)o * 10;
        }
        return -1;
    }

    public boolean setVolume(int val) {
        this.player.callMethod(this.target, "setVolume", new Object[]{val /= 10});
        return true;
    }

    public boolean getMuteState() {
        return this.volBeforeMuted >= 0;
    }
}

