/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.ui.scripteditor;

import java.util.ArrayList;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.EventManager;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEventListener;
import org.eclipse.actf.ai.scripteditor.data.ScriptData;
import org.eclipse.actf.ai.ui.scripteditor.views.EditPanelView;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ai.ui.scripteditor.views.TimeLineView;
import org.eclipse.actf.examples.scripteditor.Activator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ScriptAudioComposite
extends Composite
implements IUNIT,
SyncTimeEventListener {
    private static ScriptAudioComposite ownInst = null;
    private ScriptData instScriptData = null;
    private int currentTimeLineLocation = 0;
    private boolean statusMouseDragged = false;
    private boolean execDataConvMouseDragged = false;
    private int startTimeMouseDragged = -1;
    private String strAudioMouseDragged = null;
    private int startXMouseDragged = 0;
    private int previousXMouseDragged = 0;
    private int deltaMouseDragged = 0;
    private Label dragAudioLabel;
    private Label labelBorderTimeLine;
    private TimeLineView instParentView;
    private ArrayList<AudioLabelInfo> audioLabelInfo;
    private ArrayList<Integer> audioStartTimeList;
    private ArrayList<Label> audioLabelList;
    private Composite parentInst = null;
    private int minXDragTimeLine = 0;
    private int maxXDragTimeLine = 0;
    private int currentWidthTimeLine = 0;
    private long timePushMouseLButton = 0L;
    private boolean currentDragStatus = false;
    private boolean editMode = false;
    private boolean stat_duplicate_label = true;
    private EventManager eventManager = null;

    public ScriptAudioComposite(Composite parent) {
        super(parent, 2048);
        this.parentInst = parent;
        ownInst = this;
        this.initializeComposite(parent);
        this.instParentView = TimeLineView.getInstance();
        this.instScriptData = ScriptData.getInstance();
        this.eventManager = EventManager.getInstance();
        this.eventManager.addSyncTimeEventListener(this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ScriptAudioComposite.this.eventManager.removeSyncTimeEventListener(ownInst);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScriptAudioComposite getInstance(Composite parent) {
        if (ownInst != null) return ownInst;
        Class<ScriptAudioComposite> clazz = ScriptAudioComposite.class;
        synchronized (ScriptAudioComposite.class) {
            if (ownInst != null) return ownInst;
            ownInst = new ScriptAudioComposite(parent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ownInst;
        }
    }

    public static ScriptAudioComposite getInstance() {
        return ownInst;
    }

    private void initializeComposite(Composite parent) {
        try {
            this.audioLabelInfo = new ArrayList();
            this.audioStartTimeList = new ArrayList();
            this.audioLabelList = new ArrayList();
            this.labelBorderTimeLine = new Label((Composite)ownInst, 0);
            this.labelBorderTimeLine.setBackground(this.getDisplay().getSystemColor(9));
            this.setLocationBorderTimeLine(0);
            this.dragAudioLabel = new Label((Composite)ownInst, 128);
            this.setVisibleDragAudioLabel(false);
        }
        catch (Exception ef) {
            System.out.println("Exception : Front processer=" + ef);
        }
    }

    private void setVisibleDragAudioLabel(boolean stat) {
        this.dragAudioLabel.setVisible(stat);
    }

    public void clearAudioLabel() {
        int i = 0;
        while (i < this.audioStartTimeList.size()) {
            this.audioLabelList.get(i).dispose();
            ++i;
        }
        this.audioLabelInfo.clear();
        this.audioStartTimeList.clear();
        this.audioLabelList.clear();
    }

    private int searchScriptData(int startTime) {
        int index = this.audioStartTimeList.indexOf(startTime);
        return index;
    }

    private int indexScriptData(int startTime) {
        int index = -1;
        if (this.audioStartTimeList.isEmpty()) {
            index = 0;
        } else {
            int i = 0;
            while (i < this.audioStartTimeList.size()) {
                if (startTime < this.audioStartTimeList.get(i)) break;
                ++i;
            }
            index = i;
        }
        return index;
    }

    private void setLocationBorderTimeLine(int x) {
        int sx = x - 1;
        if (sx < 0) {
            sx = 0;
        }
        FormData labelBorderLData = new FormData();
        labelBorderLData.width = 2;
        labelBorderLData.top = new FormAttachment(0, 1000, 0);
        labelBorderLData.left = new FormAttachment(0, 1000, sx);
        labelBorderLData.bottom = new FormAttachment(1000, 1000, 0);
        this.labelBorderTimeLine.setLayoutData((Object)labelBorderLData);
        this.labelBorderTimeLine.setLocation(sx, 0);
    }

    public void refreshScriptAudio() {
        this.clearAudioLabel();
        int len = this.instScriptData.getLengthScriptList();
        if (len > 0) {
            int startTime = 0;
            int endTime = 0;
            int i = 0;
            while (i < len) {
                startTime = this.instScriptData.getScriptStartTime(i);
                String strAudio = this.instScriptData.getScriptData(i);
                boolean extended = this.instScriptData.getExtendExtended(i);
                int index = this.instScriptData.getIndexWavList(startTime);
                endTime = index >= 0 && this.instScriptData.getEnableWavList(index) ? this.instScriptData.getEndTimeWavList(index) : this.instScriptData.getScriptEndTime(i);
                this.putAudioLabel(i, startTime, endTime, strAudio, extended);
                ++i;
            }
        }
    }

    public void synchronizeTimeLine(int nowTime) {
        int x = (nowTime - this.currentTimeLineLocation * 300000) / 20;
        this.setLocationBorderTimeLine(x);
    }

    public void refreshTimeLine(int nowCnt) {
        this.currentTimeLineLocation = nowCnt;
        this.refreshScriptAudio();
    }

    private void createMouseDragLabel(int startTime, int endTime, String strAudio) {
        int sX = (startTime - this.currentTimeLineLocation * 300000) / 20;
        int eX = (endTime - this.currentTimeLineLocation * 300000) / 20;
        int sY = 18;
        int size = eX - sX;
        int index = this.audioStartTimeList.indexOf(startTime);
        if (index >= 0) {
            Rectangle parentRect = this.audioLabelList.get(index).getBounds();
            sY = parentRect.y - 8 + 18;
        }
        if (size < 5) {
            size = 5;
            eX = sX + size;
        }
        this.dragAudioLabel.addMouseTrackListener((MouseTrackListener)new LabelMouseCursorTrackAdapter());
        this.dragAudioLabel.setToolTipText(this.makeToolTipInfo(startTime, endTime, strAudio));
        this.dragAudioLabel.setBounds(sX, sY, size, 8);
        this.dragAudioLabel.setBackground(this.getDisplay().getSystemColor(7));
        this.setVisibleDragAudioLabel(true);
    }

    private int moveMouseDragLabel(int startTime, int endTime, int deltaX, String strAudio) {
        int newDeltaX = deltaX;
        int newStartTime = startTime + deltaX * 20;
        int newEndTime = endTime + deltaX * 20;
        Rectangle nowRect = this.dragAudioLabel.getBounds();
        int sX = (newStartTime - this.currentTimeLineLocation * 300000) / 20;
        int eX = (newEndTime - this.currentTimeLineLocation * 300000) / 20;
        int sY = nowRect.y;
        int size = eX - sX;
        if (size < 5) {
            size = 5;
            eX = sX + size;
        }
        if (newStartTime < 0) {
            newStartTime = 0;
            newEndTime = size * 20;
            newDeltaX = -1 * (startTime / 20);
            sX = newStartTime / 20;
            eX = newEndTime / 20;
        }
        this.dragAudioLabel.setBounds(sX, sY, size, 8);
        String newText = new String(this.makeToolTipInfo(newStartTime, newEndTime, strAudio));
        Label parentLabel = this.audioLabelList.get(this.audioStartTimeList.indexOf(this.startTimeMouseDragged));
        parentLabel.setToolTipText(newText);
        return newDeltaX;
    }

    private void createAudioLabel(int index, int parentIndex, int startTime, int endTime, String strAudio, boolean extended, int color) {
        int intdev = this.currentTimeLineLocation * 300000;
        int sX = (startTime - intdev) / 20;
        int eX = (endTime - intdev) / 20;
        int sY = 8;
        int size = eX - sX;
        Color col = this.getDisplay().getSystemColor(color);
        if (size < 5) {
            size = 5;
            eX = sX + size;
        }
        Label newAudio = new Label((Composite)ownInst, 2048);
        this.audioLabelList.add(index, newAudio);
        if (this.getStatDuplicateLabel() && color == 3) {
            int line = this.getOwnLineAudioLabel(index);
            sY += line * 18;
        }
        FormData newAudioLData = new FormData();
        newAudioLData.width = size;
        newAudioLData.height = 16;
        newAudioLData.top = new FormAttachment(0, 1000, sY);
        newAudioLData.left = new FormAttachment(0, 1000, sX);
        newAudio.setLayoutData((Object)newAudioLData);
        newAudio.setBounds(sX, sY, size, 16);
        newAudio.setBackground(col);
        newAudio.setForeground(this.getDisplay().getSystemColor(1));
        newAudio.setToolTipText(this.makeToolTipInfo(startTime, endTime, strAudio));
        int wavIndex = this.instScriptData.getIndexWavList(startTime);
        if (extended) {
            if (wavIndex >= 0 && this.instScriptData.getEnableWavList(wavIndex)) {
                Image imgWavOn = Activator.getImageDescriptor("/icons/wave_bar_ex.gif").createImage();
                newAudio.setImage(imgWavOn);
            } else {
                newAudio.setText(" Extended ");
            }
        } else if (wavIndex >= 0 && this.instScriptData.getEnableWavList(wavIndex)) {
            Image imgWavOn = Activator.getImageDescriptor("/icons/wave_bar.gif").createImage();
            newAudio.setImage(imgWavOn);
        } else {
            newAudio.setText("");
        }
        newAudio.addMouseListener((MouseListener)new AudioLabelMouseAdapter(startTime));
        newAudio.addMouseMoveListener((MouseMoveListener)new AudioLabelMouseMoveListener(startTime));
        newAudio.addMouseTrackListener((MouseTrackListener)new LabelMouseCursorTrackAdapter());
    }

    private void updateAudioLabel(int index, int startTime, int endTime, String strAudio, boolean extended, int color) {
        int intdev = this.currentTimeLineLocation * 300000;
        int sX = (startTime - intdev) / 20;
        int eX = (endTime - intdev) / 20;
        int sY = 8;
        int size = eX - sX;
        Color col = this.getDisplay().getSystemColor(color);
        if (size < 5) {
            size = 5;
            eX = sX + size;
        }
        Label targetLabel = this.audioLabelList.get(index);
        if (this.getStatDuplicateLabel() && color == 3) {
            int line = this.getOwnLineAudioLabel(index);
            sY += line * 18;
        }
        int wavIndex = this.instScriptData.getIndexWavList(startTime);
        if (extended) {
            if (wavIndex >= 0 && this.instScriptData.getEnableWavList(wavIndex)) {
                Image imgWavOn = Activator.getImageDescriptor("/icons/wave_bar_ex.gif").createImage();
                targetLabel.setImage(imgWavOn);
            } else {
                targetLabel.setText(" Extended ");
            }
        } else if (wavIndex >= 0 && this.instScriptData.getEnableWavList(wavIndex)) {
            Image imgWavOn = Activator.getImageDescriptor("/icons/wave_bar.gif").createImage();
            targetLabel.setImage(imgWavOn);
        } else {
            targetLabel.setText("");
        }
        targetLabel.setBounds(sX, sY, size, 16);
        targetLabel.setBackground(col);
        targetLabel.setToolTipText(this.makeToolTipInfo(startTime, endTime, strAudio));
    }

    private int getOwnLineAudioLabel(int index) {
        int line = 0;
        if (index > 0 && this.getStatDuplicateLabel() && this.audioLabelInfo.get(index).getColor() == 3) {
            int startTime = this.audioLabelInfo.get(index).getStartTime();
            int i = index - 1;
            while (i >= 0) {
                int previousEndTime = this.audioLabelInfo.get(i).getEndTime();
                if (startTime >= previousEndTime) break;
                ++line;
                startTime = this.audioLabelInfo.get(i).getStartTime();
                --i;
            }
        }
        return line;
    }

    public void redrawAudioLabelAll() {
        int maxLine = 0;
        Integer[] collisions = this.getCollisionsTimeLine();
        if (collisions != null && collisions.length > 0) {
            int i = 0;
            while (i < collisions.length) {
                int tempColor = this.audioLabelInfo.get(collisions[i]).getColor();
                Label tempLabel = this.audioLabelList.get(collisions[i]);
                Color newColor = this.getDisplay().getSystemColor(tempColor);
                if (tempColor == 3) {
                    int previousEndTime;
                    int ownStartTime;
                    boolean extended = this.audioLabelInfo.get(collisions[i]).getExtended();
                    if (extended) {
                        if (collisions[i] < this.instScriptData.getLengthScriptList() - 1) {
                            int nextStartTime;
                            int ownEndTime = this.audioLabelInfo.get(collisions[i]).getEndTime();
                            int n = nextStartTime = this.audioLabelInfo.size() <= collisions[i] + 1 ? -1 : this.audioLabelInfo.get(collisions[i] + 1).getStartTime();
                            if (ownEndTime > nextStartTime) {
                                if (collisions[i] > 0) {
                                    extended = this.audioLabelInfo.get(collisions[i] - 1).getExtended();
                                    if (extended) {
                                        int ownStartTime2 = this.audioLabelInfo.get(collisions[i]).getStartTime();
                                        int previousEndTime2 = this.audioLabelInfo.get(collisions[i] - 1).getEndTime();
                                        if (previousEndTime2 > ownStartTime2) {
                                            newColor = this.getDisplay().getSystemColor(9);
                                        }
                                    }
                                } else {
                                    newColor = this.getDisplay().getSystemColor(9);
                                }
                            }
                        } else if (collisions[i] > 0 && (extended = this.audioLabelInfo.get(collisions[i] - 1).getExtended())) {
                            ownStartTime = this.audioLabelInfo.get(collisions[i]).getStartTime();
                            previousEndTime = this.audioLabelInfo.get(collisions[i] - 1).getEndTime();
                            if (previousEndTime > ownStartTime) {
                                newColor = this.getDisplay().getSystemColor(9);
                            }
                        }
                    } else if (collisions[i] > 0) {
                        ownStartTime = this.audioLabelInfo.get(collisions[i]).getStartTime();
                        previousEndTime = this.audioLabelInfo.get(collisions[i] - 1).getEndTime();
                        extended = this.audioLabelInfo.get(collisions[i] - 1).getExtended();
                        if (extended && previousEndTime > ownStartTime) {
                            if (collisions[i] < this.instScriptData.getLengthScriptList() - 1) {
                                int nextStartTime;
                                int ownEndTime = this.audioLabelInfo.get(collisions[i]).getEndTime();
                                int n = nextStartTime = this.audioLabelInfo.size() <= collisions[i] + 1 ? -1 : this.audioLabelInfo.get(collisions[i] + 1).getStartTime();
                                if (ownEndTime <= nextStartTime) {
                                    newColor = this.getDisplay().getSystemColor(5);
                                }
                            } else {
                                newColor = this.getDisplay().getSystemColor(5);
                            }
                        }
                    }
                }
                tempLabel.setBackground(newColor);
                Rectangle nowRect = tempLabel.getBounds();
                int line = this.getOwnLineAudioLabel(collisions[i]) % 3;
                nowRect.y = 8 + line * 18;
                tempLabel.setBounds(nowRect);
                if (maxLine < line) {
                    maxLine = line;
                }
                ++i;
            }
            ++maxLine;
            this.instParentView.reqGetCurrentLineAudioLabel();
        }
    }

    private int pickupColorAudioLabel(int startTime, int endTime, boolean extended) {
        int newCol = 5;
        if (this.isCollisionTimeLine(startTime, endTime)) {
            newCol = 3;
        } else if (extended) {
            newCol = 9;
        }
        return newCol;
    }

    private boolean isCollisionTimeLine(int startTime, int endTime) {
        int index;
        boolean result = false;
        int wrkStartTime = 0;
        int wrkEndTime = 0;
        if (!this.audioStartTimeList.isEmpty() && (index = this.audioStartTimeList.indexOf(startTime)) >= 0) {
            if (index > 0 && startTime < (wrkEndTime = this.audioLabelInfo.get(index - 1).getEndTime())) {
                result = true;
            }
            if (index < this.audioStartTimeList.size() - 1 && endTime > (wrkStartTime = this.audioStartTimeList.get(index + 1).intValue())) {
                result = true;
            }
        }
        return result;
    }

    private Integer[] getCollisionsTimeLine() {
        Integer[] result = null;
        ArrayList<Integer> collisions = new ArrayList<Integer>();
        if (!this.audioStartTimeList.isEmpty()) {
            int max = this.audioStartTimeList.size();
            int i = 0;
            while (i < max) {
                boolean extended;
                int endTime;
                AudioLabelInfo tempList = this.audioLabelInfo.get(i);
                int startTime = tempList.getStartTime();
                int newCol = this.pickupColorAudioLabel(startTime, endTime = tempList.getEndTime(), extended = tempList.getExtended());
                if (newCol != tempList.getColor() || newCol == 3) {
                    tempList.setColor(newCol);
                    this.audioLabelInfo.set(i, tempList);
                    collisions.add(i);
                }
                ++i;
            }
        }
        if (collisions != null) {
            result = new Integer[collisions.size()];
            int i = 0;
            while (i < collisions.size()) {
                result[i] = (Integer)collisions.get(i);
                ++i;
            }
        }
        collisions.clear();
        collisions = null;
        return result;
    }

    private String makeToolTipInfo(int startTime, int endTime, String strAudio) {
        String result = null;
        String strStartTime = null;
        String strEndTime = null;
        String strTrimAudio = null;
        strStartTime = this.makeFormatMMSSMS(startTime);
        strEndTime = this.makeFormatMMSSMS(endTime);
        strTrimAudio = this.trimString(strAudio, '\r');
        boolean enableWav = false;
        int index = this.instScriptData.getIndexWavList(startTime);
        if (index >= 0) {
            enableWav = this.instScriptData.getEnableWavList(index);
        }
        result = "Start Time \uff1a " + strStartTime + "\n" + "  End Time \uff1a " + strEndTime + "\n";
        result = enableWav ? String.valueOf(result) + "  WAV File \uff1a " + this.instScriptData.getFileNameWavList(index).toString() : String.valueOf(result) + "Desctiption\uff1a " + strTrimAudio;
        return result;
    }

    private String trimString(String targetString, char TrimData) {
        StringBuffer tempString = new StringBuffer(256);
        int i = 0;
        while (i < targetString.length()) {
            if (TrimData != targetString.charAt(i)) {
                tempString.append(targetString.charAt(i));
            }
            ++i;
        }
        return tempString.toString();
    }

    public boolean getStatDuplicateLabel() {
        return this.stat_duplicate_label;
    }

    public void setStatDuplicateLabel(boolean newStat) {
        this.stat_duplicate_label = newStat;
    }

    public boolean putAudioLabel(int index, int startTime, int endTime, String strAudio, boolean extended) {
        boolean result = true;
        int idx = -1;
        idx = this.searchScriptData(startTime);
        if (idx >= 0) {
            this.audioStartTimeList.set(idx, startTime);
            AudioLabelInfo tempList = this.audioLabelInfo.get(idx);
            tempList.setIndex(index);
            tempList.setStartTime(startTime);
            tempList.setEndTime(endTime);
            tempList.setStrAudioLabel(strAudio);
            tempList.setExtended(extended);
            int newCol = this.pickupColorAudioLabel(startTime, endTime, extended);
            tempList.setColor(newCol);
            this.audioLabelInfo.set(idx, tempList);
            this.updateAudioLabel(index, startTime, endTime, strAudio, extended, newCol);
            this.redrawAudioLabelAll();
        } else {
            idx = this.indexScriptData(startTime);
            if (idx >= 0) {
                int newCol = this.pickupColorAudioLabel(startTime, endTime, extended);
                this.audioStartTimeList.add(idx, startTime);
                AudioLabelInfo tempList = new AudioLabelInfo(index, startTime, endTime, strAudio, extended, newCol);
                this.audioLabelInfo.add(idx, tempList);
                this.createAudioLabel(idx, index, startTime, endTime, strAudio, extended, newCol);
                this.redrawAudioLabelAll();
            } else {
                result = false;
            }
        }
        return result;
    }

    public void deleteAudioLabel(int startTime) {
        int i = 0;
        while (i < this.audioStartTimeList.size()) {
            if (startTime == this.audioStartTimeList.get(i)) {
                this.audioLabelList.get(i).dispose();
                this.audioStartTimeList.remove(i);
                this.audioLabelInfo.remove(i);
                this.audioLabelList.remove(i);
            }
            ++i;
        }
    }

    private String makeFormatMMSSMS(int totalSec) {
        String formTime = new String();
        if (totalSec <= 0) {
            formTime = "00:00.00";
        } else {
            Integer mm = totalSec / 1000 / 60;
            Integer ss = totalSec / 1000 % 60;
            Integer ms = totalSec % 1000;
            formTime = "";
            if (mm < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + mm.toString();
            formTime = String.valueOf(formTime) + ":";
            if (ss < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + ss.toString();
            formTime = String.valueOf(formTime) + ".";
            Integer ms100 = ms / 10;
            formTime = ms100 < 10 ? String.valueOf(formTime) + "0" + ms100.toString() : String.valueOf(formTime) + ms100.toString();
        }
        return formTime;
    }

    private void precheckMouseDraggedEvent(MouseEvent e) {
        this.timePushMouseLButton = e.time;
        this.currentDragStatus = true;
        this.editMode = false;
    }

    private void startMouseDraggedEvent(MouseEvent e, int startTime) {
        this.statusMouseDragged = true;
        this.startTimeMouseDragged = startTime;
        AudioLabelInfo tempInfo = this.audioLabelInfo.get(this.audioStartTimeList.indexOf(startTime));
        int endTime = tempInfo.getEndTime();
        this.strAudioMouseDragged = tempInfo.getStrAudioLabel();
        this.previousXMouseDragged = this.startXMouseDragged = e.x;
        this.deltaMouseDragged = 0;
        this.createMouseDragLabel(this.startTimeMouseDragged, endTime, this.strAudioMouseDragged);
        int startTimeEditPanel = EditPanelView.getInstance().getInstanceTabEditPanel().getStarTimeEditPanel();
        if (startTime == startTimeEditPanel) {
            this.editMode = true;
        }
    }

    private void moveMouseDraggedEvent(MouseEvent e) {
        Rectangle pos = this.dragAudioLabel.getBounds();
        int startPosBlueLabel = pos.x;
        int endPosBlueLabel = pos.x + pos.width;
        int nowEndTime = (this.instParentView.getMaxTimeLine() - this.currentTimeLineLocation * 300000) / 20;
        if (endPosBlueLabel > nowEndTime) {
            pos.x = this.maxXDragTimeLine - pos.width;
            this.dragAudioLabel.setBounds(pos);
            return;
        }
        this.deltaMouseDragged += e.x - this.previousXMouseDragged;
        AudioLabelInfo tempInfo = this.audioLabelInfo.get(this.audioStartTimeList.indexOf(this.startTimeMouseDragged));
        int endTime = tempInfo.getEndTime();
        int newDeltaX = this.moveMouseDragLabel(this.startTimeMouseDragged, endTime, this.deltaMouseDragged, this.strAudioMouseDragged);
        if (newDeltaX != this.deltaMouseDragged) {
            this.deltaMouseDragged = newDeltaX;
        } else {
            this.previousXMouseDragged = e.x;
        }
        if (startPosBlueLabel < this.minXDragTimeLine) {
            this.minXDragTimeLine -= 5;
            if (this.minXDragTimeLine < 0) {
                this.minXDragTimeLine = 0;
            }
            this.maxXDragTimeLine = this.minXDragTimeLine + this.currentWidthTimeLine;
            this.instParentView.resetLocationTimeLine(this.minXDragTimeLine * 20, endPosBlueLabel * 20);
        } else if (endPosBlueLabel > this.maxXDragTimeLine) {
            this.maxXDragTimeLine += 5;
            this.minXDragTimeLine += 5;
            int delta = nowEndTime - this.maxXDragTimeLine;
            if (delta < 0) {
                this.maxXDragTimeLine = nowEndTime;
                this.minXDragTimeLine = this.maxXDragTimeLine - this.currentWidthTimeLine;
            }
            endPosBlueLabel = this.maxXDragTimeLine;
            pos.x = endPosBlueLabel - pos.width;
            this.dragAudioLabel.setBounds(pos);
            this.instParentView.resetLocationTimeLine(this.minXDragTimeLine * 20, endPosBlueLabel * 20);
        }
    }

    private void endMouseDraggedEvent(MouseEvent e) {
        this.execDataConvMouseDragged = true;
        this.statusMouseDragged = false;
        this.setVisibleDragAudioLabel(false);
        int newStartTime = this.startTimeMouseDragged + this.deltaMouseDragged * 20;
        AudioLabelInfo tempInfo = this.audioLabelInfo.get(this.audioStartTimeList.indexOf(this.startTimeMouseDragged));
        String newStrAudioLabel = tempInfo.getStrAudioLabel();
        boolean newExtended = tempInfo.getExtended();
        int newEndTime = 0;
        int index = this.instScriptData.getIndexScriptData(this.startTimeMouseDragged);
        if (index >= 0) {
            newEndTime = this.instScriptData.getScriptEndTime(index) + this.deltaMouseDragged * 20;
        }
        int newEndTimeWav = 0;
        index = this.instScriptData.getIndexWavList(this.startTimeMouseDragged);
        if (index >= 0 && this.instScriptData.getEnableWavList(index)) {
            newEndTimeWav = this.instScriptData.getEndTimeWavList(index) + this.deltaMouseDragged * 20;
        }
        int nowMaxTimeLine = this.instParentView.getMaxTimeLine();
        int nowMinTimeLine = this.currentTimeLineLocation * 300000;
        if (newEndTime > nowMaxTimeLine) {
            newStartTime = nowMaxTimeLine - (tempInfo.getEndTime() - this.startTimeMouseDragged);
            newEndTime = nowMaxTimeLine;
        } else if (newStartTime < nowMinTimeLine) {
            newStartTime = nowMinTimeLine;
            newEndTime = newStartTime + (tempInfo.getEndTime() - this.startTimeMouseDragged);
        }
        this.instParentView.reqRefreshScriptData(this.startTimeMouseDragged, newStartTime, newEndTime, newEndTimeWav, this.editMode);
        if (index >= 0 && this.instScriptData.getEnableWavList(index)) {
            newEndTime = newEndTimeWav;
        }
        this.deleteAudioLabel(this.startTimeMouseDragged);
        this.putAudioLabel(0, newStartTime, newEndTime, newStrAudioLabel, newExtended);
        this.redrawAudioLabelAll();
        this.instParentView.adjustEndTimeLine();
        this.execDataConvMouseDragged = false;
    }

    public boolean getStatusDragAudioLabel() {
        return this.statusMouseDragged;
    }

    @Override
    public void handleSyncTimeEvent(SyncTimeEvent e) {
        if (e.getEventType() == 0) {
            this.synchronizeTimeLine(e.getCurrentTime());
        } else if (e.getEventType() == 1) {
            this.refreshTimeLine(e.getCurrentTime());
        }
    }

    class AudioLabelInfo {
        private int index = -1;
        private int startTime = 0;
        private int endTime = 0;
        private String strAudioLabel = null;
        private boolean extended = false;
        private int color = 5;

        public AudioLabelInfo(int index, int startTime, int endTime, String strAudioLabel, boolean extended, int color) {
            this.index = index;
            this.startTime = startTime;
            this.endTime = endTime;
            this.strAudioLabel = new String(strAudioLabel);
            this.extended = extended;
            this.color = color;
        }

        public int getIndex() {
            return this.index;
        }

        public int getStartTime() {
            return this.startTime;
        }

        public int getEndTime() {
            return this.endTime;
        }

        public String getStrAudioLabel() {
            return this.strAudioLabel;
        }

        public boolean getExtended() {
            return this.extended;
        }

        public int getColor() {
            return this.color;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setStartTime(int startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(int endTime) {
            this.endTime = endTime;
        }

        public void setStrAudioLabel(String strAudioLabel) {
            this.strAudioLabel = strAudioLabel;
        }

        public void setExtended(boolean extended) {
            this.extended = extended;
        }

        public void setColor(int color) {
            this.color = color;
        }
    }

    class AudioLabelMouseAdapter
    extends MouseAdapter {
        private int ownStartTime = -1;

        public AudioLabelMouseAdapter(int parentStartTime) {
            this.ownStartTime = parentStartTime;
        }

        public void mouseDown(MouseEvent e) {
            if (!ScriptAudioComposite.this.execDataConvMouseDragged && !ScriptAudioComposite.this.statusMouseDragged && e.button == 1) {
                ScriptAudioComposite.this.precheckMouseDraggedEvent(e);
                EditPanelView.getInstance().getInstanceTabEditPanel().endSelectMultiItems();
            }
        }

        public void mouseUp(MouseEvent e) {
            if (!ScriptAudioComposite.this.execDataConvMouseDragged && !ScriptAudioComposite.this.statusMouseDragged && e.button == 1 && ScriptAudioComposite.this.currentDragStatus) {
                long timeReleaseMouseLButton = e.time;
                if (timeReleaseMouseLButton - ScriptAudioComposite.this.timePushMouseLButton < 200L) {
                    ScriptAudioComposite.this.instParentView.reqSelectScriptData(this.ownStartTime);
                }
                ScriptAudioComposite.this.currentDragStatus = false;
            } else if (!ScriptAudioComposite.this.execDataConvMouseDragged && ScriptAudioComposite.this.statusMouseDragged && e.button == 1) {
                ScriptAudioComposite.this.endMouseDraggedEvent(e);
            }
        }
    }

    class AudioLabelMouseMoveListener
    implements MouseMoveListener {
        private int parentStartTime = -1;

        public AudioLabelMouseMoveListener(int parentStartTime) {
            this.parentStartTime = parentStartTime;
        }

        public void mouseMove(MouseEvent e) {
            if (!ScriptAudioComposite.this.execDataConvMouseDragged && ScriptAudioComposite.this.statusMouseDragged) {
                ScriptAudioComposite.this.moveMouseDraggedEvent(e);
            } else if (!ScriptAudioComposite.this.execDataConvMouseDragged && !ScriptAudioComposite.this.statusMouseDragged && ScriptAudioComposite.this.currentDragStatus) {
                ScriptAudioComposite.this.startMouseDraggedEvent(e, this.parentStartTime);
                ScriptAudioComposite.this.currentDragStatus = false;
                Point wsiz = ScriptAudioComposite.this.instParentView.getCurrentSizeScrollBar();
                ScriptAudioComposite.this.currentWidthTimeLine = wsiz.x;
                Rectangle comp = ScriptAudioComposite.this.parentInst.getBounds();
                ScriptAudioComposite.this.minXDragTimeLine = -1 * comp.x;
                ScriptAudioComposite.this.maxXDragTimeLine = ScriptAudioComposite.this.minXDragTimeLine + ScriptAudioComposite.this.currentWidthTimeLine;
            }
        }
    }

    class LabelMouseCursorTrackAdapter
    extends MouseTrackAdapter {
        LabelMouseCursorTrackAdapter() {
        }

        public void mouseEnter(MouseEvent e) {
            Label parentLabel = (Label)e.getSource();
            parentLabel.setCursor(new Cursor(null, 21));
        }

        public void mouseExit(MouseEvent e) {
            Label parentLabel = (Label)e.getSource();
            parentLabel.setCursor(new Cursor(null, 21));
        }
    }
}

