/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.dom;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.actf.util.dom.TreeWalkerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.html.HTMLTitleElement;
import org.w3c.dom.traversal.NodeFilter;

public class DomPrintUtil {
    public static final String UTF8 = "UTF8";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String EMPTY_STR = "";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String AMP = "&";
    private static final String QUAT = "\"";
    private static final String SINGLE_QUAT = "'";
    private static final String ESC_LT = "&lt;";
    private static final String ESC_GT = "&gt;";
    private static final String ESC_AMP = "&amp;";
    private Document document;
    private int whatToShow = -1;
    private NodeFilter nodeFilter = null;
    private boolean entityReferenceExpansion = false;
    private boolean indent = true;
    private boolean escapeTagBracket = false;
    private AttributeFilter attrFilter = null;

    public DomPrintUtil(Document document) {
        this.document = document;
    }

    private String getXMLString(String targetS) {
        return targetS.replaceAll(AMP, ESC_AMP).replaceAll(LT, ESC_LT).replaceAll(GT, ESC_GT);
    }

    private String getAttributeString(Element element, Node attr) {
        if (this.attrFilter == null || this.attrFilter.acceptNode(element, attr)) {
            String value = this.getXMLString(attr.getNodeValue());
            String quat = QUAT;
            if (value.contains(QUAT)) {
                quat = SINGLE_QUAT;
            }
            return " " + attr.getNodeName() + "=" + quat + value + quat;
        }
        return EMPTY_STR;
    }

    private boolean checkNewLine(Node target) {
        if (this.indent && target.hasChildNodes()) {
            short type = target.getFirstChild().getNodeType();
            return type != 3 && type != 4;
        }
        return false;
    }

    public String toXMLString() {
        StringBuffer tmpSB = new StringBuffer(8192);
        TreeWalkerImpl treeWalker = new TreeWalkerImpl(this.document, this.whatToShow, this.nodeFilter, this.entityReferenceExpansion);
        String lt = this.escapeTagBracket ? ESC_LT : LT;
        String gt = this.escapeTagBracket ? ESC_GT : GT;
        String line_sep = this.indent ? LINE_SEP : EMPTY_STR;
        Node tmpN = treeWalker.nextNode();
        boolean prevIsText = false;
        String indentS = EMPTY_STR;
        block8: while (tmpN != null) {
            short type = tmpN.getNodeType();
            switch (type) {
                case 1: {
                    if (prevIsText) {
                        tmpSB.append(line_sep);
                    }
                    tmpSB.append(String.valueOf(indentS) + lt + tmpN.getNodeName());
                    NamedNodeMap attrs = tmpN.getAttributes();
                    int len = attrs.getLength();
                    int i = 0;
                    while (i < len) {
                        Node attr = attrs.item(i);
                        String value = attr.getNodeValue();
                        if (value != null) {
                            tmpSB.append(this.getAttributeString((Element)tmpN, attr));
                        }
                        ++i;
                    }
                    if (tmpN instanceof HTMLTitleElement && !tmpN.hasChildNodes()) {
                        tmpSB.append(String.valueOf(gt) + ((HTMLTitleElement)tmpN).getText());
                        prevIsText = true;
                        break;
                    }
                    if (this.checkNewLine(tmpN)) {
                        tmpSB.append(String.valueOf(gt) + line_sep);
                        prevIsText = false;
                        break;
                    }
                    tmpSB.append(gt);
                    prevIsText = true;
                    break;
                }
                case 3: {
                    if (!prevIsText) {
                        tmpSB.append(indentS);
                    }
                    tmpSB.append(this.getXMLString(tmpN.getNodeValue()));
                    prevIsText = true;
                    break;
                }
                case 8: {
                    String comment = this.escapeTagBracket ? this.getXMLString(tmpN.getNodeValue()) : tmpN.getNodeValue();
                    tmpSB.append(String.valueOf(line_sep) + indentS + lt + "!--" + comment + "--" + gt + line_sep);
                    prevIsText = false;
                    break;
                }
                case 4: {
                    tmpSB.append(String.valueOf(line_sep) + indentS + lt + "!CDATA[" + tmpN.getNodeValue() + "]]" + line_sep);
                    break;
                }
                case 10: {
                    if (tmpN instanceof DocumentType) {
                        DocumentType docType = (DocumentType)tmpN;
                        String pubId = docType.getPublicId();
                        String sysId = docType.getSystemId();
                        if (pubId != null && pubId.length() > 0) {
                            if (sysId != null && sysId.length() > 0) {
                                tmpSB.append(String.valueOf(lt) + "!DOCTYPE " + docType.getName() + " PUBLIC \"" + pubId + " \"" + sysId + "\">" + line_sep);
                                break;
                            }
                            tmpSB.append(String.valueOf(lt) + "!DOCTYPE " + docType.getName() + " PUBLIC \"" + pubId + "\">" + line_sep);
                            break;
                        }
                        tmpSB.append(String.valueOf(lt) + "!DOCTYPE " + docType.getName() + " SYSTEM \"" + docType.getSystemId() + "\">" + line_sep);
                        break;
                    }
                    System.out.println("Document Type node does not implement DocumentType: " + tmpN);
                    break;
                }
                case 7: {
                    if (!(tmpN instanceof ProcessingInstruction)) break;
                    String tmpS = ((ProcessingInstruction)tmpN).getData();
                    if (tmpS.startsWith("?")) {
                        tmpSB.append(lt);
                    } else {
                        tmpSB.append(String.valueOf(lt) + "?");
                    }
                    if (tmpS.endsWith("?")) {
                        tmpSB.append(String.valueOf(tmpS) + GT + LINE_SEP);
                        break;
                    }
                    tmpSB.append(String.valueOf(tmpS) + "?>" + LINE_SEP);
                    break;
                }
                default: {
                    System.out.println(String.valueOf(tmpN.getNodeType()) + " : " + tmpN.getNodeName());
                }
            }
            Node next = treeWalker.firstChild();
            if (next != null) {
                if (this.indent && type == 1) {
                    indentS = String.valueOf(indentS) + " ";
                }
                tmpN = next;
                continue;
            }
            if (tmpN.getNodeType() == 1) {
                tmpSB.append(String.valueOf(lt) + "/" + tmpN.getNodeName() + gt + line_sep);
                prevIsText = false;
            }
            if ((next = treeWalker.nextSibling()) != null) {
                tmpN = next;
                continue;
            }
            tmpN = null;
            next = treeWalker.parentNode();
            while (next != null) {
                if (next.getNodeType() == 1) {
                    if (this.indent) {
                        if (indentS.length() > 0) {
                            indentS = indentS.substring(1);
                        } else {
                            System.err.println("indent: " + next.getNodeName() + " " + next);
                        }
                    }
                    tmpSB.append(String.valueOf(line_sep) + indentS + lt + "/" + next.getNodeName() + gt + line_sep);
                    prevIsText = false;
                }
                if ((next = treeWalker.nextSibling()) != null) {
                    tmpN = next;
                    continue block8;
                }
                next = treeWalker.parentNode();
            }
        }
        return tmpSB.toString();
    }

    public String toString() {
        return this.toXMLString();
    }

    public void setWhatToShow(int whatToShow) {
        this.whatToShow = whatToShow;
    }

    public void setNodeFilter(NodeFilter nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    public void setEntityReferenceExpansion(boolean entityReferenceExpansion) {
        this.entityReferenceExpansion = entityReferenceExpansion;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setEscapeTagBracket(boolean escapeTagBracket) {
        this.escapeTagBracket = escapeTagBracket;
    }

    public void setAttrFilter(AttributeFilter attrFilter) {
        this.attrFilter = attrFilter;
    }

    public void writeToFile(String filePath) throws IOException {
        this.writeToFile(new File(filePath), UTF8);
    }

    public void writeToFile(File file) throws IOException {
        this.writeToFile(file, UTF8);
    }

    public void writeToFile(String filePath, String encode) throws IOException {
        this.writeToFile(new File(filePath), encode);
    }

    public void writeToFile(File file, String encode) throws IOException {
        PrintWriter tmpPW = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encode));
        tmpPW.println(this.toXMLString());
        tmpPW.flush();
        tmpPW.close();
    }

    public static interface AttributeFilter {
        public boolean acceptNode(Element var1, Node var2);
    }
}

